/*
 * Decompiled with CFR 0.152.
 */
package ttv.migami.jeg.debug;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.tuple.Pair;
import ttv.migami.jeg.client.ClientHandler;
import ttv.migami.jeg.common.Gun;
import ttv.migami.jeg.debug.IDebugWidget;
import ttv.migami.jeg.debug.IEditorMenu;
import ttv.migami.jeg.debug.client.screen.widget.DebugButton;
import ttv.migami.jeg.debug.client.screen.widget.DebugToggle;
import ttv.migami.jeg.item.GunItem;
import ttv.migami.jeg.item.ScopeItem;
import ttv.migami.jeg.item.attachment.impl.Scope;

@Mod.EventBusSubscriber(modid="jeg")
public class Debug {
    private static final Map<Item, Gun> GUNS = new HashMap<Item, Gun>();
    private static final Map<Item, Scope> SCOPES = new HashMap<Item, Scope>();
    private static boolean forceAim = false;

    @SubscribeEvent
    public static void onServerStarting(ServerStartedEvent event) {
        event.getServer().execute(() -> {
            GUNS.clear();
            SCOPES.clear();
        });
    }

    public static Gun getGun(GunItem item) {
        return GUNS.computeIfAbsent(item, item1 -> item.getGun().copy());
    }

    public static Scope getScope(ScopeItem item) {
        return SCOPES.computeIfAbsent(item, item1 -> item.getProperties().copy());
    }

    public static boolean isForceAim() {
        return forceAim;
    }

    public static void setForceAim(boolean forceAim) {
        Debug.forceAim = forceAim;
    }

    public static class Settings
    implements IEditorMenu {
        @Override
        public Component getEditorLabel() {
            return new TextComponent("Settings");
        }

        @Override
        public void getEditorWidgets(List<Pair<Component, Supplier<IDebugWidget>>> widgets) {
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> widgets.add(Pair.of((Object)new TextComponent("Force Aim"), () -> new DebugToggle(forceAim, value -> {
                forceAim = value;
            }))));
        }
    }

    public static class Menu
    implements IEditorMenu {
        @Override
        public Component getEditorLabel() {
            return new TextComponent("Editor Menu");
        }

        @Override
        public void getEditorWidgets(List<Pair<Component, Supplier<IDebugWidget>>> widgets) {
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
                ItemStack heldItem = Objects.requireNonNull(Minecraft.m_91087_().f_91074_).m_21205_();
                Item patt2623$temp = heldItem.m_41720_();
                if (patt2623$temp instanceof GunItem) {
                    GunItem gunItem = (GunItem)patt2623$temp;
                    widgets.add(Pair.of((Object)new TranslatableComponent(gunItem.m_5524_()), () -> new DebugButton((Component)new TextComponent("Edit"), btn -> Minecraft.m_91087_().m_91152_(ClientHandler.createEditorScreen(Debug.getGun(gunItem))))));
                }
                widgets.add(Pair.of((Object)new TextComponent("Settings"), () -> new DebugButton((Component)new TextComponent(">"), btn -> Minecraft.m_91087_().m_91152_(ClientHandler.createEditorScreen(new Settings())))));
            });
        }
    }
}

