/*
 * Decompiled with CFR 0.152.
 */
package caeruleustait.world.preview.backend.color;

import caeruleustait.world.preview.backend.color.ColorMap;
import caeruleustait.world.preview.backend.color.PreviewData;
import it.unimi.dsi.fastutil.objects.Object2ShortMap;
import it.unimi.dsi.fastutil.objects.Object2ShortOpenHashMap;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;

public class PreviewMappingData {
    private final Map<String, ColorEntry> resourceOnlyColorMappingData = new HashMap<String, ColorEntry>();
    private final Map<String, ColorEntry> colorMappingData = new HashMap<String, ColorEntry>();
    private final Map<String, StructureEntry> structMappingData = new HashMap<String, StructureEntry>();
    private final List<PreviewData.HeightmapPresetData> heightmapPresets = new ArrayList<PreviewData.HeightmapPresetData>();
    private final List<ColorMap> colorMaps = new ArrayList<ColorMap>();
    private static final MessageDigest sha1;

    void clearBiomes() {
        this.colorMappingData.clear();
        this.resourceOnlyColorMappingData.clear();
    }

    void clearStructures() {
        this.structMappingData.clear();
    }

    void clearColorMappings() {
        this.colorMaps.clear();
    }

    void clearHeightmapPresets() {
        this.heightmapPresets.clear();
    }

    public void makeBiomeResourceOnlyBackup() {
        this.resourceOnlyColorMappingData.putAll(this.colorMappingData);
    }

    public void update(Map<ResourceLocation, ColorEntry> newData) {
        this.colorMappingData.putAll(newData.entrySet().stream().collect(Collectors.toMap(x -> ((ResourceLocation)x.getKey()).toString(), Map.Entry::getValue)));
    }

    public void updateStruct(Map<ResourceLocation, StructureEntry> newData) {
        this.structMappingData.putAll(newData.entrySet().stream().collect(Collectors.toMap(x -> ((ResourceLocation)x.getKey()).toString(), Map.Entry::getValue)));
    }

    public void addHeightmapPreset(PreviewData.HeightmapPresetData presetData) {
        this.heightmapPresets.add(presetData);
    }

    public void addColormap(ColorMap colorMap) {
        this.colorMaps.add(colorMap);
    }

    public PreviewData generateMapData(Set<ResourceLocation> biomesSet, Set<ResourceLocation> caveBiomesSet, Set<ResourceLocation> structuresSet, Set<ResourceLocation> displayByDefaultStructuresSet) {
        short id;
        List<String> biomes = biomesSet.stream().map(ResourceLocation::toString).sorted().toList();
        List<String> structures = structuresSet.stream().map(ResourceLocation::toString).sorted().toList();
        PreviewData res = new PreviewData(new PreviewData.BiomeData[biomes.size()], new PreviewData.StructureData[structures.size()], (Object2ShortMap<String>)new Object2ShortOpenHashMap(), (Object2ShortMap<String>)new Object2ShortOpenHashMap(), this.heightmapPresets, this.colorMaps.stream().collect(Collectors.toMap(x -> x.key().toString(), x -> x)));
        for (id = 0; id < biomes.size(); id = (short)(id + 1)) {
            ColorEntry resourceOnlyColor;
            String biome = biomes.get(id);
            res.biome2Id().put((Object)biome, id);
            ColorEntry color = this.colorMappingData.get(biome);
            if (color == null) {
                color = new ColorEntry();
                color.dataSource = PreviewData.DataSource.MISSING;
                byte[] hash = sha1.digest(biome.getBytes(StandardCharsets.UTF_8));
                ByteBuffer byteBuffer = ByteBuffer.allocate(4);
                for (int i = 0; i < 4 && i < hash.length; ++i) {
                    byteBuffer.put(hash[i]);
                }
                color.color = byteBuffer.getInt(0) & 0xFFFFFF;
                color.name = null;
            }
            if ((resourceOnlyColor = this.resourceOnlyColorMappingData.get(biome)) == null) {
                resourceOnlyColor = color;
            }
            ResourceLocation biomeRes = ResourceLocation.parse((String)biome);
            res.biomeId2BiomeData()[id] = new PreviewData.BiomeData(id, biomeRes, color.color, resourceOnlyColor.color, color.cave.orElse(caveBiomesSet.contains(biomeRes)), resourceOnlyColor.cave.orElse(caveBiomesSet.contains(biomeRes)), color.name, resourceOnlyColor.name, color.dataSource);
        }
        for (id = 0; id < structures.size(); id = (short)(id + 1)) {
            String structTag = structures.get(id);
            res.struct2Id().put((Object)structTag, id);
            StructureEntry structure = this.structMappingData.get(structTag);
            if (structure == null) {
                structure = new StructureEntry();
                structure.dataSource = PreviewData.DataSource.MISSING;
                structure.texture = "world_preview:textures/structure/unknown.png";
                structure.name = structTag;
                structure.showByDefault = Optional.empty();
            }
            ResourceLocation structureRes = ResourceLocation.parse((String)structTag);
            res.structId2StructData()[id] = new PreviewData.StructureData(id, structureRes, structure.name, structure.texture == null ? null : ResourceLocation.parse((String)structure.texture), structure.item == null ? null : ResourceLocation.parse((String)structure.item), structure.showByDefault.orElse(displayByDefaultStructuresSet.contains(structureRes)), structure.dataSource);
        }
        return res;
    }

    static {
        try {
            sha1 = MessageDigest.getInstance("SHA1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static class ColorEntry {
        public PreviewData.DataSource dataSource;
        public int color;
        public Optional<Boolean> cave = Optional.empty();
        public String name = null;

        public ColorEntry() {
        }

        public ColorEntry(PreviewData.DataSource dataSource, int color, boolean cave, String name) {
            this.dataSource = dataSource;
            this.color = color;
            this.cave = Optional.of(cave);
            this.name = name;
        }
    }

    public static class StructureEntry {
        public PreviewData.DataSource dataSource;
        public String name = null;
        public String texture = null;
        public String item = null;
        public Optional<Boolean> showByDefault = Optional.empty();
    }
}

