/*
 * Decompiled with CFR 0.152.
 */
package caeruleustait.world.preview.backend.sampler;

import caeruleustait.world.preview.backend.sampler.ChunkSampler;
import caeruleustait.world.preview.backend.worker.WorkResult;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.QuartPos;
import net.minecraft.core.SectionPos;
import net.minecraft.world.level.ChunkPos;

public class SingleQuartSampler
implements ChunkSampler {
    @Override
    public List<BlockPos> blocksForChunk(ChunkPos chunkPos, int y) {
        int xMin = SectionPos.sectionToBlockCoord((int)chunkPos.x, (int)0);
        int zMin = SectionPos.sectionToBlockCoord((int)chunkPos.z, (int)0);
        return List.of(new BlockPos(xMin, y, zMin));
    }

    @Override
    public void expandRaw(BlockPos pos, short raw, WorkResult result) {
        int quartX = QuartPos.fromBlock((int)pos.getX());
        int quartZ = QuartPos.fromBlock((int)pos.getZ());
        for (int x = 0; x < 4; ++x) {
            for (int z = 0; z < 4; ++z) {
                result.results().add(new WorkResult.BlockResult(quartX + x, quartZ + z, raw));
            }
        }
    }

    @Override
    public int blockStride() {
        return 16;
    }
}

