/*
 * Decompiled with CFR 0.152.
 */
package caeruleustait.world.preview.backend.worker;

import caeruleustait.world.preview.WorldPreviewConfig;
import caeruleustait.world.preview.backend.color.PreviewData;
import caeruleustait.world.preview.backend.sampler.ChunkSampler;
import caeruleustait.world.preview.backend.worker.SampleUtils;
import caeruleustait.world.preview.backend.worker.WorkResult;
import caeruleustait.world.preview.backend.worker.WorkUnit;
import caeruleustait.world.preview.mixin.NoiseChunkAccessor;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.QuartPos;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.NoiseChunk;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.NoiseSettings;

public class HeightmapWorkUnit
extends WorkUnit {
    private final ChunkSampler sampler;
    private final int numChunks;

    public HeightmapWorkUnit(ChunkSampler sampler, SampleUtils sampleUtils, ChunkPos chunkPos, int numChunks, PreviewData previewData) {
        super(sampleUtils, chunkPos, previewData, 0);
        this.sampler = sampler;
        this.numChunks = numChunks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List<WorkResult> doWork() {
        WorkResult res = new WorkResult(this, QuartPos.fromBlock((int)0), this.primarySection, new ArrayList<WorkResult.BlockResult>(this.numChunks * this.numChunks * 4 * 4), List.of());
        NoiseGeneratorSettings noiseGeneratorSettings = this.sampleUtils.noiseGeneratorSettings();
        WorldPreviewConfig config = this.workManager.config();
        if (noiseGeneratorSettings == null) {
            return List.of(res);
        }
        NoiseSettings noiseSettings = noiseGeneratorSettings.noiseSettings();
        NoiseChunk noiseChunk = this.sampleUtils.getNoiseChunk(this.chunkPos, this.numChunks, false);
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        int cellWidth = noiseSettings.getCellWidth();
        int cellHeight = noiseSettings.getCellHeight();
        int minY = config.onlySampleInVisualRange ? config.heightmapMinY : noiseSettings.minY();
        int maxY = config.onlySampleInVisualRange ? config.heightmapMaxY : minY + noiseSettings.height();
        int cellMinY = Mth.floorDiv((int)minY, (int)noiseSettings.getCellHeight());
        int cellCountY = Mth.floorDiv((int)(maxY - minY), (int)noiseSettings.getCellHeight());
        int cellOffsetY = config.onlySampleInVisualRange ? cellMinY - Mth.floorDiv((int)noiseSettings.minY(), (int)noiseSettings.getCellHeight()) : 0;
        int minBlockX = this.chunkPos.getMinBlockX();
        int minBlockZ = this.chunkPos.getMinBlockZ();
        int cellCountXZ = 16 * this.numChunks / cellWidth;
        int cellStrideXZ = Math.max(1, this.sampler.blockStride() / cellWidth);
        int todoArraySize = Math.max(1, cellWidth / this.sampler.blockStride()) * Math.max(1, cellWidth / this.sampler.blockStride());
        Predicate predicate = Heightmap.Types.OCEAN_FLOOR_WG.isOpaque();
        noiseChunk.initializeForFirstCellX();
        try {
            for (int cellX = 0; cellX < cellCountXZ && !this.isCanceled(); cellX += cellStrideXZ) {
                noiseChunk.advanceCellX(cellX);
                for (int cellZ = 0; cellZ < cellCountXZ && !this.isCanceled(); cellZ += cellStrideXZ) {
                    ArrayList<XZPair> positions = new ArrayList<XZPair>(todoArraySize);
                    for (int xInCell = 0; xInCell < cellWidth; xInCell += this.sampler.blockStride()) {
                        for (int zInCell = 0; zInCell < cellWidth; zInCell += this.sampler.blockStride()) {
                            int x = minBlockX + cellX * cellWidth + xInCell;
                            int z = minBlockZ + cellZ * cellWidth + zInCell;
                            positions.add(new XZPair(x, (double)xInCell / (double)cellWidth, z, (double)zInCell / (double)cellWidth));
                        }
                    }
                    for (int cellY = cellCountY - 1; cellY >= 0 && !positions.isEmpty() && !this.isCanceled(); --cellY) {
                        noiseChunk.selectCellYZ(cellY + cellOffsetY, cellZ);
                        for (int yInCell = cellHeight - 1; yInCell >= 0 && !positions.isEmpty(); --yInCell) {
                            int y = (cellMinY + cellY) * cellHeight + yInCell;
                            noiseChunk.updateForY(y, (double)yInCell / (double)cellHeight);
                            for (int idx = 0; idx < positions.size(); ++idx) {
                                XZPair curr = (XZPair)positions.get(idx);
                                noiseChunk.updateForX(curr.x, curr.dX);
                                noiseChunk.updateForZ(curr.z, curr.dZ);
                                BlockState blockState = ((NoiseChunkAccessor)noiseChunk).invokeGetInterpolatedState();
                                if (blockState == null) {
                                    blockState = noiseGeneratorSettings.defaultBlock();
                                }
                                if (!predicate.test(blockState)) continue;
                                mutableBlockPos.set(curr.x, 0, curr.z);
                                this.sampler.expandRaw((BlockPos)mutableBlockPos, (short)(y + 1), res);
                                positions.remove(idx--);
                            }
                        }
                    }
                }
                noiseChunk.swapSlices();
            }
        }
        finally {
            noiseChunk.stopInterpolation();
        }
        return List.of(res);
    }

    @Override
    public long flags() {
        return 2L;
    }

    private record XZPair(int x, double dX, int z, double dZ) {
    }
}

