/*
 * Decompiled with CFR 0.152.
 */
package caeruleustait.world.preview.backend.worker;

import caeruleustait.world.preview.WorldPreview;
import caeruleustait.world.preview.WorldPreviewConfig;
import caeruleustait.world.preview.backend.storage.PreviewLevel;
import caeruleustait.world.preview.backend.stubs.DummyMinecraftServer;
import caeruleustait.world.preview.backend.stubs.DummyServerLevelData;
import caeruleustait.world.preview.backend.stubs.EmptyAquifer;
import caeruleustait.world.preview.mixin.MinecraftServerAccessor;
import caeruleustait.world.preview.mixin.NoiseBasedChunkGeneratorAccessor;
import caeruleustait.world.preview.mixin.NoiseChunkAccessor;
import com.mojang.datafixers.DataFixer;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Lifecycle;
import java.io.File;
import java.io.IOException;
import java.net.Proxy;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Stream;
import net.minecraft.FileUtil;
import net.minecraft.Util;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.LayeredRegistryAccess;
import net.minecraft.core.QuartPos;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.RegistryLayer;
import net.minecraft.server.ReloadableServerResources;
import net.minecraft.server.Services;
import net.minecraft.server.WorldLoader;
import net.minecraft.server.WorldStem;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.progress.ChunkProgressListener;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.server.packs.repository.ServerPacksSource;
import net.minecraft.server.packs.resources.CloseableResourceManager;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.datafix.DataFixers;
import net.minecraft.world.Difficulty;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.LevelSettings;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldDataConfiguration;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.MultiNoiseBiomeSource;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkGeneratorStructureState;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.DensityFunctions;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseChunk;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.NoiseSettings;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.WorldOptions;
import net.minecraft.world.level.levelgen.blending.Blender;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureCheck;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.level.storage.DerivedLevelData;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.PrimaryLevelData;
import net.minecraft.world.level.storage.ServerLevelData;
import net.minecraft.world.level.storage.WorldData;
import net.minecraft.world.level.validation.DirectoryValidator;
import net.minecraft.world.level.validation.PathAllowList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SampleUtils
implements AutoCloseable {
    private final Path tempDir;
    private final DataFixer dataFixer;
    private final LevelStorageSource.LevelStorageAccess levelStorageAccess;
    private final LevelHeightAccessor levelHeightAccessor;
    private final CloseableResourceManager resourceManager;
    private final BiomeSource biomeSource;
    private final RandomState randomState;
    private final ChunkGenerator chunkGenerator;
    private final RegistryAccess registryAccess;
    private final ChunkGeneratorStructureState chunkGeneratorStructureState;
    private final StructureCheck structureCheck;
    private final StructureManager structureManager;
    private final StructureTemplateManager structureTemplateManager;
    private final PreviewLevel previewLevel;
    private final Registry<Structure> structureRegistry;
    private final ResourceKey<Level> dimension;
    private final NoiseGeneratorSettings noiseGeneratorSettings;
    private final MinecraftServer minecraftServer;
    private final ServerLevel serverLevel;
    private final WorldPreviewConfig cfg = WorldPreview.get().cfg();

    public SampleUtils(@NotNull MinecraftServer server, BiomeSource biomeSource, ChunkGenerator chunkGenerator, WorldOptions worldOptions, LevelStem levelStem, LevelHeightAccessor levelHeightAccessor) throws IOException {
        NoiseBasedChunkGenerator noiseBasedChunkGenerator;
        this.tempDir = null;
        this.minecraftServer = server;
        this.dataFixer = this.minecraftServer.getFixerUpper();
        this.levelStorageAccess = ((MinecraftServerAccessor)this.minecraftServer).getStorageSource();
        this.levelHeightAccessor = levelHeightAccessor;
        this.resourceManager = (CloseableResourceManager)this.minecraftServer.getResourceManager();
        this.biomeSource = biomeSource;
        this.chunkGenerator = chunkGenerator;
        this.registryAccess = this.minecraftServer.registryAccess();
        this.structureRegistry = this.registryAccess.registryOrThrow(Registries.STRUCTURE);
        this.structureTemplateManager = this.minecraftServer.getStructureManager();
        this.previewLevel = new PreviewLevel(this.registryAccess, this.levelHeightAccessor);
        ResourceKey levelStemResourceKey = (ResourceKey)this.registryAccess.registryOrThrow(Registries.LEVEL_STEM).getResourceKey((Object)levelStem).orElseThrow();
        this.dimension = Registries.levelStemToLevel((ResourceKey)levelStemResourceKey);
        if (chunkGenerator instanceof NoiseBasedChunkGenerator) {
            noiseBasedChunkGenerator = (NoiseBasedChunkGenerator)chunkGenerator;
            this.randomState = RandomState.create((NoiseGeneratorSettings)((NoiseGeneratorSettings)noiseBasedChunkGenerator.generatorSettings().value()), (HolderGetter)this.registryAccess.lookupOrThrow(Registries.NOISE), (long)worldOptions.seed());
        } else {
            this.randomState = RandomState.create((NoiseGeneratorSettings)NoiseGeneratorSettings.dummy(), (HolderGetter)this.registryAccess.lookupOrThrow(Registries.NOISE), (long)worldOptions.seed());
        }
        this.structureCheck = new StructureCheck(null, this.registryAccess, this.structureTemplateManager, this.dimension, this.chunkGenerator, this.randomState, this.levelHeightAccessor, chunkGenerator.getBiomeSource(), worldOptions.seed(), this.dataFixer);
        this.structureManager = new StructureManager((LevelAccessor)this.previewLevel, worldOptions, this.structureCheck);
        this.chunkGeneratorStructureState = this.chunkGenerator.createState((HolderLookup)this.registryAccess.lookupOrThrow(Registries.STRUCTURE_SET), this.randomState, worldOptions.seed());
        if (chunkGenerator instanceof NoiseBasedChunkGenerator) {
            noiseBasedChunkGenerator = (NoiseBasedChunkGenerator)chunkGenerator;
            this.noiseGeneratorSettings = (NoiseGeneratorSettings)noiseBasedChunkGenerator.generatorSettings().value();
        } else {
            this.noiseGeneratorSettings = null;
        }
        this.serverLevel = null;
    }

    public SampleUtils(BiomeSource biomeSource, ChunkGenerator chunkGenerator, LayeredRegistryAccess<RegistryLayer> layeredRegistryAccess, WorldOptions worldOptions, LevelStem levelStem, LevelHeightAccessor levelHeightAccessor, WorldDataConfiguration worldDataConfiguration, Proxy proxy, @Nullable Path tempDataPackDir) throws IOException, RuntimeException {
        ReloadableServerResources reloadableServerResources;
        try {
            this.tempDir = Files.createTempDirectory("world_preview", new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.dataFixer = DataFixers.getDataFixer();
        LevelStorageSource levelStorageSource = new LevelStorageSource(this.tempDir, this.tempDir.resolve("backups"), new DirectoryValidator((PathMatcher)new PathAllowList(List.of())), this.dataFixer);
        this.levelStorageAccess = levelStorageSource.createAccess("world_preview");
        this.levelHeightAccessor = levelHeightAccessor;
        Path dataPackDir = this.levelStorageAccess.getLevelPath(LevelResource.DATAPACK_DIR);
        FileUtil.createDirectoriesSafe((Path)dataPackDir);
        if (tempDataPackDir != null) {
            try (Stream<Path> stream = Files.walk(tempDataPackDir, new FileVisitOption[0]);){
                stream.filter(x -> !x.equals(tempDataPackDir)).forEach(x -> {
                    try {
                        Util.copyBetweenDirs((Path)tempDataPackDir, (Path)dataPackDir, (Path)x);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                });
            }
        }
        this.biomeSource = biomeSource;
        this.chunkGenerator = chunkGenerator;
        this.registryAccess = layeredRegistryAccess.compositeAccess();
        this.structureRegistry = this.registryAccess.registryOrThrow(Registries.STRUCTURE);
        this.previewLevel = new PreviewLevel(this.registryAccess, this.levelHeightAccessor);
        PackRepository packRepository = ServerPacksSource.createPackRepository((LevelStorageSource.LevelStorageAccess)this.levelStorageAccess);
        this.resourceManager = (CloseableResourceManager)new WorldLoader.PackConfig(packRepository, worldDataConfiguration, false, false).createResourceManager().getSecond();
        HolderLookup.RegistryLookup holderGetter = this.registryAccess.registryOrThrow(Registries.BLOCK).asLookup().filterFeatures(worldDataConfiguration.enabledFeatures());
        this.structureTemplateManager = new StructureTemplateManager((ResourceManager)this.resourceManager, this.levelStorageAccess, this.dataFixer, (HolderGetter)holderGetter);
        ResourceKey levelStemResourceKey = (ResourceKey)this.registryAccess.registryOrThrow(Registries.LEVEL_STEM).getResourceKey((Object)levelStem).orElseThrow();
        this.dimension = Registries.levelStemToLevel((ResourceKey)levelStemResourceKey);
        boolean functionCompilationLevel = false;
        ExecutorService executor = Executors.newSingleThreadExecutor();
        LevelSettings levelSettings = new LevelSettings("temp", GameType.CREATIVE, false, Difficulty.NORMAL, true, new GameRules(), worldDataConfiguration);
        PrimaryLevelData primaryLevelData = new PrimaryLevelData(levelSettings, worldOptions, PrimaryLevelData.SpecialWorldProperty.NONE, Lifecycle.stable());
        CompletableFuture future = ReloadableServerResources.loadResources((ResourceManager)this.resourceManager, layeredRegistryAccess, (FeatureFlagSet)worldDataConfiguration.enabledFeatures(), (Commands.CommandSelection)Commands.CommandSelection.DEDICATED, (int)0, (Executor)executor, (Executor)executor);
        try {
            reloadableServerResources = (ReloadableServerResources)future.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        WorldStem worldStem = new WorldStem(this.resourceManager, reloadableServerResources, layeredRegistryAccess, (WorldData)primaryLevelData);
        ChunkProgressListener chunkProgressListener = new ChunkProgressListener(this){

            public void updateSpawnPos(ChunkPos center) {
            }

            public void onStatusChange(ChunkPos chunkPosition, @Nullable ChunkStatus newStatus) {
            }

            public void start() {
            }

            public void stop() {
            }
        };
        this.minecraftServer = new DummyMinecraftServer(new Thread(() -> {}), this.levelStorageAccess, packRepository, worldStem, proxy, this.dataFixer, new Services(null, null, null, null), i -> chunkProgressListener);
        WorldPreview.get().loaderSpecificSetup(this.minecraftServer);
        new ServerLevel(this.minecraftServer, (Executor)Executors.newSingleThreadExecutor(), this.levelStorageAccess, (ServerLevelData)new DerivedLevelData(worldStem.worldData(), worldStem.worldData().overworldData()), this.dimension, levelStem, new ChunkProgressListener(this){

            public void updateSpawnPos(ChunkPos center) {
            }

            public void onStatusChange(ChunkPos chunkPosition, @Nullable ChunkStatus newStatus) {
            }

            public void start() {
            }

            public void stop() {
            }
        }, false, BiomeManager.obfuscateSeed((long)worldOptions.seed()), List.of(), false, null);
        if (chunkGenerator instanceof NoiseBasedChunkGenerator) {
            NoiseBasedChunkGenerator noiseBasedChunkGenerator = (NoiseBasedChunkGenerator)chunkGenerator;
            this.noiseGeneratorSettings = (NoiseGeneratorSettings)noiseBasedChunkGenerator.generatorSettings().value();
            this.randomState = RandomState.create((NoiseGeneratorSettings)((NoiseGeneratorSettings)noiseBasedChunkGenerator.generatorSettings().value()), (HolderGetter)this.registryAccess.lookupOrThrow(Registries.NOISE), (long)worldOptions.seed());
        } else {
            this.noiseGeneratorSettings = null;
            this.randomState = RandomState.create((NoiseGeneratorSettings)NoiseGeneratorSettings.dummy(), (HolderGetter)this.registryAccess.lookupOrThrow(Registries.NOISE), (long)worldOptions.seed());
        }
        this.structureCheck = new StructureCheck(null, this.registryAccess, this.structureTemplateManager, this.dimension, this.chunkGenerator, this.randomState, this.levelHeightAccessor, chunkGenerator.getBiomeSource(), worldOptions.seed(), this.dataFixer);
        this.structureManager = new StructureManager((LevelAccessor)this.previewLevel, worldOptions, this.structureCheck);
        this.chunkGeneratorStructureState = this.chunkGenerator.createState((HolderLookup)this.registryAccess.lookupOrThrow(Registries.STRUCTURE_SET), this.randomState, worldOptions.seed());
        this.chunkGeneratorStructureState.ensureStructuresGenerated();
        this.serverLevel = new ServerLevel(this.minecraftServer, (Executor)Executors.newSingleThreadExecutor(), this.levelStorageAccess, (ServerLevelData)new DummyServerLevelData(), this.dimension, levelStem, chunkProgressListener, false, BiomeManager.obfuscateSeed((long)worldOptions.seed()), List.of(), false, null);
    }

    @Nullable
    public ServerPlayer getPlayers(UUID playerId) {
        if (this.minecraftServer instanceof DummyMinecraftServer) {
            return null;
        }
        return this.minecraftServer.getPlayerList().getPlayer(playerId);
    }

    private static short doubleToShort(double val, double factor) {
        return (short)Math.min(32767L, Math.max(-32768L, (long)(val * factor * 32767.0)));
    }

    public boolean hasRawNoiseInfo() {
        return this.cfg.storeNoiseSamples && this.biomeSource instanceof MultiNoiseBiomeSource;
    }

    public BiomeResult doSample(BlockPos pos) {
        Climate.Sampler sampler = this.randomState.sampler();
        if (this.hasRawNoiseInfo()) {
            DensityFunction.SinglePointContext singlePointContext = new DensityFunction.SinglePointContext(pos.getX(), pos.getY(), pos.getZ());
            double temperature = sampler.temperature().compute((DensityFunction.FunctionContext)singlePointContext);
            double humidity = sampler.humidity().compute((DensityFunction.FunctionContext)singlePointContext);
            double continentalness = sampler.continentalness().compute((DensityFunction.FunctionContext)singlePointContext);
            double erosion = sampler.erosion().compute((DensityFunction.FunctionContext)singlePointContext);
            double depth = sampler.depth().compute((DensityFunction.FunctionContext)singlePointContext);
            double weirdness = sampler.weirdness().compute((DensityFunction.FunctionContext)singlePointContext);
            short[] noiseData = new short[]{SampleUtils.doubleToShort(temperature, 1.0), SampleUtils.doubleToShort(humidity, 1.0), SampleUtils.doubleToShort(continentalness, 0.5), SampleUtils.doubleToShort(erosion, 1.0), SampleUtils.doubleToShort(depth, 0.5), SampleUtils.doubleToShort(weirdness, 0.75)};
            Climate.TargetPoint targetPoint = Climate.target((float)((float)temperature), (float)((float)humidity), (float)((float)continentalness), (float)((float)erosion), (float)((float)depth), (float)((float)weirdness));
            MultiNoiseBiomeSource noiseBiomeSource = (MultiNoiseBiomeSource)this.biomeSource;
            Holder biome = noiseBiomeSource.getNoiseBiome(targetPoint);
            return new BiomeResult((ResourceKey<Biome>)((ResourceKey)biome.unwrapKey().orElseThrow()), noiseData);
        }
        return new BiomeResult((ResourceKey<Biome>)((ResourceKey)this.biomeSource.getNoiseBiome(QuartPos.fromBlock((int)pos.getX()), QuartPos.fromBlock((int)pos.getY()), QuartPos.fromBlock((int)pos.getZ()), this.randomState.sampler()).unwrapKey().orElseThrow()), null);
    }

    public List<Pair<ResourceLocation, StructureStart>> doStructures(ChunkPos chunkPos) {
        ProtoChunk protoChunk = (ProtoChunk)this.previewLevel.getChunk(chunkPos.x, chunkPos.z, ChunkStatus.FULL, false);
        this.chunkGenerator.createStructures(this.registryAccess, this.chunkGeneratorStructureState, this.structureManager, (ChunkAccess)protoChunk, this.structureTemplateManager);
        Map raw = protoChunk.getAllStarts();
        ArrayList<Pair<ResourceLocation, StructureStart>> res = new ArrayList<Pair<ResourceLocation, StructureStart>>(raw.size());
        for (Map.Entry x : protoChunk.getAllStarts().entrySet()) {
            res.add((Pair<ResourceLocation, StructureStart>)new Pair((Object)this.structureRegistry.getKey((Object)((Structure)x.getKey())), (Object)((StructureStart)x.getValue())));
        }
        return res;
    }

    public NoiseChunk getNoiseChunk(ChunkPos startChunk, int numChunks, boolean keepAquifer) {
        NoiseSettings noiseSettings = this.noiseGeneratorSettings.noiseSettings();
        NoiseChunk noiseChunk = new NoiseChunk(numChunks * 16 / noiseSettings.getCellWidth(), this.randomState, startChunk.getMinBlockX(), startChunk.getMinBlockZ(), noiseSettings, (DensityFunctions.BeardifierOrMarker)DensityFunctions.BeardifierMarker.INSTANCE, this.noiseGeneratorSettings, ((NoiseBasedChunkGeneratorAccessor)this.chunkGenerator).getGlobalFluidPicker().get(), Blender.empty());
        if (!keepAquifer) {
            ((NoiseChunkAccessor)noiseChunk).setAquifer(new EmptyAquifer());
        }
        return noiseChunk;
    }

    public NoiseGeneratorSettings noiseGeneratorSettings() {
        return this.noiseGeneratorSettings;
    }

    public short doHeightSlow(BlockPos pos) {
        return (short)this.chunkGenerator.getBaseHeight(pos.getX(), pos.getZ(), Heightmap.Types.OCEAN_FLOOR_WG, this.levelHeightAccessor, this.randomState);
    }

    public NoiseColumn doIntersectionsSlow(BlockPos pos) {
        return this.chunkGenerator.getBaseColumn(pos.getX(), pos.getZ(), this.levelHeightAccessor, this.randomState);
    }

    @Override
    public void close() throws Exception {
        if (this.serverLevel != null) {
            this.serverLevel.close();
        }
        if (this.minecraftServer instanceof DummyMinecraftServer) {
            WorldPreview.get().loaderSpecificTeardown(this.minecraftServer);
        }
        if (this.tempDir != null) {
            SampleUtils.deleteDirectoryLegacyIO(this.tempDir.toFile());
        }
    }

    public static void deleteDirectoryLegacyIO(File file) {
        File[] list = file.listFiles();
        if (list != null) {
            for (File temp : list) {
                SampleUtils.deleteDirectoryLegacyIO(temp);
            }
        }
        if (!file.delete()) {
            WorldPreview.LOGGER.warn("Unable to delete file or directory : {}", (Object)file);
        }
    }

    public CloseableResourceManager resourceManager() {
        return this.resourceManager;
    }

    public RegistryAccess registryAccess() {
        return this.registryAccess;
    }

    public ResourceKey<Level> dimension() {
        return this.dimension;
    }

    public record BiomeResult(ResourceKey<Biome> biome, short[] noiseResult) {
    }
}

