/*
 * Decompiled with CFR 0.152.
 */
package caeruleustait.world.preview.client.gui.screens;

import caeruleustait.world.preview.RenderSettings;
import caeruleustait.world.preview.WorldPreview;
import caeruleustait.world.preview.WorldPreviewConfig;
import caeruleustait.world.preview.backend.WorkManager;
import caeruleustait.world.preview.backend.color.ColorMap;
import caeruleustait.world.preview.backend.color.PreviewData;
import caeruleustait.world.preview.backend.color.PreviewMappingData;
import caeruleustait.world.preview.client.WorldPreviewComponents;
import caeruleustait.world.preview.client.gui.PreviewContainerDataProvider;
import caeruleustait.world.preview.client.gui.PreviewDisplayDataProvider;
import caeruleustait.world.preview.client.gui.screens.SettingsScreen;
import caeruleustait.world.preview.client.gui.widgets.OldStyleImageButton;
import caeruleustait.world.preview.client.gui.widgets.PreviewDisplay;
import caeruleustait.world.preview.client.gui.widgets.ToggleButton;
import caeruleustait.world.preview.client.gui.widgets.lists.BaseObjectSelectionList;
import caeruleustait.world.preview.client.gui.widgets.lists.BiomesList;
import caeruleustait.world.preview.client.gui.widgets.lists.SeedsList;
import caeruleustait.world.preview.client.gui.widgets.lists.StructuresList;
import caeruleustait.world.preview.mixin.client.ScreenAccessor;
import com.mojang.blaze3d.platform.NativeImage;
import it.unimi.dsi.fastutil.shorts.Short2LongMap;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.worldselection.WorldCreationContext;
import net.minecraft.core.Holder;
import net.minecraft.core.LayeredRegistryAccess;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.RegistryLayer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.WorldDataConfiguration;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.structure.Structure;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PreviewContainer
implements AutoCloseable,
PreviewDisplayDataProvider {
    public static final TagKey<Biome> C_CAVE = TagKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"caves"));
    public static final TagKey<Biome> C_IS_CAVE = TagKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"is_cave"));
    public static final TagKey<Biome> FORGE_CAVE = TagKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"forge", (String)"caves"));
    public static final TagKey<Biome> FORGE_IS_CAVE = TagKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"forge", (String)"is_cave"));
    public static final TagKey<Structure> DISPLAY_BY_DEFAULT = TagKey.create((ResourceKey)Registries.STRUCTURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"display_on_map_by_default"));
    public static final ResourceLocation BUTTONS_TEXTURE = ResourceLocation.parse((String)"world_preview:textures/gui/buttons.png");
    public static final int BUTTONS_TEX_WIDTH = 400;
    public static final int BUTTONS_TEX_HEIGHT = 60;
    public static final int LINE_HEIGHT = 20;
    public static final int LINE_VSPACE = 4;
    private final PreviewContainerDataProvider dataProvider;
    private final Minecraft minecraft;
    private final WorldPreview worldPreview;
    private final WorldPreviewConfig cfg;
    private final WorkManager workManager;
    private final RenderSettings renderSettings;
    private final PreviewMappingData previewMappingData;
    private PreviewData previewData;
    private List<ResourceLocation> levelStemKeys;
    private Registry<LevelStem> levelStemRegistry;
    private final EditBox seedEdit;
    private final Button randomSeedButton;
    private final Button saveSeed;
    private final Button settings;
    private final Button resetToZeroZero;
    private final ToggleButton toggleCaves;
    private final ToggleButton toggleShowStructures;
    private final ToggleButton toggleBiomes;
    private final ToggleButton toggleNoise;
    private final ToggleButton toggleHeightmap;
    private final ToggleButton toggleIntersections;
    private final ToggleButton toggleExpand;
    private final CycleButton<RenderSettings.RenderMode> noiseCycleButton;
    private final Button resetDefaultStructureVisibility;
    private final Button switchBiomes;
    private final Button switchStructures;
    private final Button switchSeeds;
    private final PreviewDisplay previewDisplay;
    private final BiomesList biomesList;
    private final StructuresList structuresList;
    private final SeedsList seedsList;
    private BiomesList.BiomeEntry[] allBiomes;
    private StructuresList.StructureEntry[] allStructures;
    private NativeImage[] allStructureIcons;
    private NativeImage playerIcon;
    private NativeImage spawnIcon;
    private List<SeedsList.SeedEntry> seedEntries;
    private ScreenRectangle lastScreenRectangle;
    private boolean inhibitUpdates = true;
    private boolean isUpdating = false;
    private boolean setupFailed = false;
    private final Executor reloadExecutor = Executors.newSingleThreadExecutor();
    private final Executor serverThreadPoolExecutor;
    private final AtomicInteger reloadRevision = new AtomicInteger(0);
    private final List<AbstractWidget> toRender = new ArrayList<AbstractWidget>();

    public PreviewContainer(Screen screen, PreviewContainerDataProvider previewContainerDataProvider) {
        Font font = ((ScreenAccessor)screen).getFont();
        this.dataProvider = previewContainerDataProvider;
        this.minecraft = Minecraft.getInstance();
        this.allBiomes = new BiomesList.BiomeEntry[0];
        this.worldPreview = WorldPreview.get();
        this.cfg = this.worldPreview.cfg();
        this.workManager = this.worldPreview.workManager();
        this.previewMappingData = this.worldPreview.biomeColorMap();
        this.renderSettings = this.worldPreview.renderSettings();
        this.serverThreadPoolExecutor = this.worldPreview.serverThreadPoolExecutor();
        this.seedEdit = new EditBox(font, 0, 0, 100, 18, WorldPreviewComponents.SEED_FIELD);
        this.seedEdit.setHint(WorldPreviewComponents.SEED_FIELD);
        this.seedEdit.setValue(this.dataProvider.seed());
        this.seedEdit.setResponder(this::setSeed);
        this.seedEdit.setTooltip(Tooltip.create((Component)WorldPreviewComponents.SEED_LABEL));
        this.seedEdit.active = this.dataProvider.seedIsEditable();
        this.toRender.add((AbstractWidget)this.seedEdit);
        this.randomSeedButton = new OldStyleImageButton(0, 0, 20, 20, 0, 20, 20, BUTTONS_TEXTURE, 400, 60, this::randomizeSeed);
        this.randomSeedButton.setTooltip(Tooltip.create((Component)WorldPreviewComponents.BTN_RANDOM));
        this.randomSeedButton.active = this.dataProvider.seedIsEditable();
        this.toRender.add((AbstractWidget)this.randomSeedButton);
        this.saveSeed = new OldStyleImageButton(0, 0, 20, 20, 20, 20, 20, BUTTONS_TEXTURE, 400, 60, this::saveCurrentSeed);
        this.saveSeed.setTooltip(Tooltip.create((Component)WorldPreviewComponents.BTN_SAVE_SEED));
        this.saveSeed.active = false;
        this.toRender.add((AbstractWidget)this.saveSeed);
        this.settings = new OldStyleImageButton(0, 0, 20, 20, 60, 20, 20, BUTTONS_TEXTURE, 400, 60, x -> {
            this.workManager.cancel();
            this.minecraft.setScreen((Screen)new SettingsScreen(screen, this));
        });
        this.settings.setTooltip(Tooltip.create((Component)WorldPreviewComponents.BTN_SETTINGS));
        this.settings.active = false;
        this.toRender.add((AbstractWidget)this.settings);
        this.resetToZeroZero = new OldStyleImageButton(0, 0, 20, 20, 120, 20, 20, BUTTONS_TEXTURE, 400, 60, x -> this.renderSettings.resetCenter());
        this.resetToZeroZero.setTooltip(Tooltip.create((Component)WorldPreviewComponents.BTN_HOME));
        this.toRender.add((AbstractWidget)this.resetToZeroZero);
        this.resetDefaultStructureVisibility = Button.builder((Component)WorldPreviewComponents.BTN_RESET_STRUCTURES, x -> Arrays.stream(this.allStructures).forEach(StructuresList.StructureEntry::reset)).build();
        this.resetDefaultStructureVisibility.setTooltip(Tooltip.create((Component)WorldPreviewComponents.BTN_RESET_STRUCTURES_TOOLTIP));
        this.resetDefaultStructureVisibility.visible = false;
        this.toRender.add((AbstractWidget)this.resetDefaultStructureVisibility);
        this.switchBiomes = Button.builder((Component)DisplayType.BIOMES.component(), x -> this.onTabButtonChange(x, DisplayType.BIOMES)).size(100, 20).build();
        this.switchStructures = Button.builder((Component)DisplayType.STRUCTURES.component(), x -> this.onTabButtonChange(x, DisplayType.STRUCTURES)).size(100, 20).build();
        this.switchSeeds = Button.builder((Component)DisplayType.SEEDS.component(), x -> this.onTabButtonChange(x, DisplayType.SEEDS)).size(100, 20).build();
        this.toRender.add((AbstractWidget)this.switchBiomes);
        this.toRender.add((AbstractWidget)this.switchStructures);
        this.toRender.add((AbstractWidget)this.switchSeeds);
        this.biomesList = new BiomesList(this, this.minecraft, 200, 300, 4, 100, true);
        this.toRender.add((AbstractWidget)this.biomesList);
        this.structuresList = new StructuresList(this.minecraft, 200, 300, 4, 100);
        this.toRender.add((AbstractWidget)this.structuresList);
        this.seedsList = new SeedsList(this.minecraft, this);
        this.updateSeedListWidget();
        this.toRender.add((AbstractWidget)this.seedsList);
        this.previewDisplay = new PreviewDisplay(this.minecraft, this, WorldPreviewComponents.TITLE);
        this.toRender.add(this.previewDisplay);
        this.toggleCaves = new ToggleButton(0, 0, 20, 20, 80, 20, 20, 20, BUTTONS_TEXTURE, 400, 60, x -> {
            this.biomesList.setSelected((BiomesList.BiomeEntry)null);
            this.previewDisplay.setSelectedBiomeId((short)-1);
            this.previewDisplay.setHighlightCaves(((ToggleButton)x).selected);
        });
        this.toggleCaves.setTooltip(Tooltip.create((Component)WorldPreviewComponents.BTN_CAVES));
        this.toRender.add((AbstractWidget)this.toggleCaves);
        this.toggleShowStructures = new ToggleButton(0, 0, 20, 20, 140, 20, 20, 20, BUTTONS_TEXTURE, 400, 60, x -> {
            this.renderSettings.hideAllStructures = !((ToggleButton)x).selected;
        });
        this.toggleShowStructures.selected = !this.renderSettings.hideAllStructures;
        this.toggleShowStructures.active = false;
        this.toRender.add((AbstractWidget)this.toggleShowStructures);
        this.toggleBiomes = new ToggleButton(0, 0, 20, 20, 360, 20, 20, 20, BUTTONS_TEXTURE, 400, 60, x -> this.selectViewMode(RenderSettings.RenderMode.BIOMES));
        this.toggleBiomes.visible = false;
        this.toggleBiomes.active = true;
        this.toggleBiomes.setTooltip(Tooltip.create((Component)WorldPreviewComponents.BTN_TOGGLE_BIOMES));
        this.toRender.add((AbstractWidget)this.toggleBiomes);
        this.toggleNoise = new ToggleButton(0, 0, 20, 20, 280, 20, 20, 20, BUTTONS_TEXTURE, 400, 60, x -> this.selectViewMode(this.renderSettings.lastNoise));
        this.toggleNoise.visible = false;
        this.toggleNoise.active = false;
        this.toggleNoise.setTooltip(Tooltip.create((Component)WorldPreviewComponents.BTN_TOGGLE_NOISE));
        this.toRender.add((AbstractWidget)this.toggleNoise);
        this.toggleHeightmap = new ToggleButton(0, 0, 20, 20, 200, 20, 20, 20, BUTTONS_TEXTURE, 400, 60, x -> this.selectViewMode(RenderSettings.RenderMode.HEIGHTMAP));
        this.toggleHeightmap.visible = false;
        this.toggleHeightmap.active = false;
        this.toRender.add((AbstractWidget)this.toggleHeightmap);
        this.toggleIntersections = new ToggleButton(0, 0, 20, 20, 240, 20, 20, 20, BUTTONS_TEXTURE, 400, 60, x -> this.selectViewMode(RenderSettings.RenderMode.INTERSECTIONS));
        this.toggleIntersections.active = false;
        this.toggleIntersections.visible = false;
        this.toRender.add((AbstractWidget)this.toggleIntersections);
        this.noiseCycleButton = CycleButton.builder(RenderSettings.RenderMode::toComponent).withValues(List.of(RenderSettings.RenderMode.NOISE_TEMPERATURE, RenderSettings.RenderMode.NOISE_HUMIDITY, RenderSettings.RenderMode.NOISE_DEPTH, RenderSettings.RenderMode.NOISE_CONTINENTALNESS, RenderSettings.RenderMode.NOISE_WEIRDNESS, RenderSettings.RenderMode.NOISE_EROSION, RenderSettings.RenderMode.NOISE_PEAKS_AND_VALLEYS)).withInitialValue((Object)this.renderSettings.lastNoise).create(0, 0, 200, 20, WorldPreviewComponents.BTN_CYCLE_NOISE, (btn, val) -> this.selectViewMode((RenderSettings.RenderMode)((Object)val)));
        this.noiseCycleButton.active = false;
        this.noiseCycleButton.visible = false;
        this.toRender.add((AbstractWidget)this.noiseCycleButton);
        this.toggleExpand = new ToggleButton(0, 0, 20, 20, 320, 20, 20, 20, BUTTONS_TEXTURE, 400, 60, x -> {
            boolean expanded;
            this.toggleBiomes.visible = expanded = ((ToggleButton)x).selected;
            this.toggleNoise.visible = expanded;
            this.toggleIntersections.visible = expanded;
            this.toggleHeightmap.visible = expanded;
            this.noiseCycleButton.visible = expanded;
            this.doLayout(this.lastScreenRectangle);
        });
        this.toggleExpand.setTooltip(Tooltip.create((Component)WorldPreviewComponents.BTN_TOGGLE_EXPAND));
        this.toRender.add((AbstractWidget)this.toggleExpand);
        this.biomesList.setBiomeChangeListener(x -> {
            this.previewDisplay.setSelectedBiomeId(x == null ? (short)-1 : (short)x.id());
            this.toggleCaves.selected = x == null && this.toggleCaves.selected;
            this.previewDisplay.setHighlightCaves(x == null && this.toggleCaves.selected);
        });
        this.dataProvider.registerSettingsChangeListener(this::updateSettings);
        this.onTabButtonChange(this.switchBiomes, DisplayType.BIOMES);
        this.selectViewMode(RenderSettings.RenderMode.BIOMES);
    }

    public void patchColorData() {
        Map<ResourceLocation, PreviewMappingData.ColorEntry> configured = Arrays.stream(this.allBiomes).filter(x -> x.dataSource() == PreviewData.DataSource.CONFIG).collect(Collectors.toMap(x -> x.entry().key().location(), x -> new PreviewMappingData.ColorEntry(PreviewData.DataSource.MISSING, x.color(), x.isCave(), x.name())));
        Map<ResourceLocation, PreviewMappingData.ColorEntry> defaults = Arrays.stream(this.allBiomes).filter(x -> x.dataSource() == PreviewData.DataSource.RESOURCE).collect(Collectors.toMap(x -> x.entry().key().location(), x -> new PreviewMappingData.ColorEntry(PreviewData.DataSource.RESOURCE, x.color(), x.isCave(), x.name())));
        Map<ResourceLocation, PreviewMappingData.ColorEntry> missing = Arrays.stream(this.allBiomes).filter(x -> x.dataSource() == PreviewData.DataSource.MISSING).collect(Collectors.toMap(x -> x.entry().key().location(), x -> new PreviewMappingData.ColorEntry(PreviewData.DataSource.CONFIG, x.color(), x.isCave(), x.name())));
        this.previewMappingData.update(missing);
        this.previewMappingData.update(defaults);
        this.previewMappingData.update(configured);
        this.updateSettings();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void selectViewMode(RenderSettings.RenderMode mode) {
        this.toggleBiomes.selected = false;
        this.toggleHeightmap.selected = false;
        this.toggleIntersections.selected = false;
        this.toggleNoise.selected = false;
        this.noiseCycleButton.active = false;
        RenderSettings renderSettings = this.renderSettings;
        synchronized (renderSettings) {
            switch (mode) {
                case BIOMES: {
                    this.toggleBiomes.selected = true;
                    break;
                }
                case HEIGHTMAP: {
                    this.toggleHeightmap.selected = true;
                    break;
                }
                case INTERSECTIONS: {
                    this.toggleIntersections.selected = true;
                    break;
                }
                case NOISE_TEMPERATURE: 
                case NOISE_HUMIDITY: 
                case NOISE_CONTINENTALNESS: 
                case NOISE_EROSION: 
                case NOISE_DEPTH: 
                case NOISE_WEIRDNESS: 
                case NOISE_PEAKS_AND_VALLEYS: {
                    this.renderSettings.lastNoise = mode;
                    this.toggleNoise.selected = true;
                    this.noiseCycleButton.active = true;
                }
            }
            this.renderSettings.mode = mode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void updateSettings() {
        if (this.inhibitUpdates) {
            return;
        }
        this.inhibitUpdates = true;
        try {
            int revision;
            AtomicInteger atomicInteger = this.reloadRevision;
            synchronized (atomicInteger) {
                revision = this.reloadRevision.incrementAndGet();
            }
            this.isUpdating = true;
            ((CompletableFuture)CompletableFuture.supplyAsync(() -> {
                if (this.reloadRevision.get() > revision) {
                    return null;
                }
                return this.dataProvider.previewWorldCreationContext();
            }, this.reloadExecutor).thenAcceptAsync(x -> {
                if (this.reloadRevision.get() > revision) {
                    return;
                }
                this.updateSettings_real((WorldCreationContext)x);
                AtomicInteger atomicInteger = this.reloadRevision;
                synchronized (atomicInteger) {
                    if (this.reloadRevision.get() <= revision) {
                        this.isUpdating = false;
                    }
                }
            }, (Executor)this.minecraft)).handle((r, e) -> {
                if (e == null) {
                    this.setupFailed = false;
                } else {
                    e.printStackTrace();
                    this.setupFailed = true;
                }
                return null;
            });
        }
        finally {
            this.inhibitUpdates = false;
        }
    }

    private void updateSettings_real(@Nullable WorldCreationContext wcContext) {
        this.saveSeed.active = !this.dataProvider.seed().isEmpty() && !this.cfg.savedSeeds.contains(this.dataProvider.seed());
        this.updateSeedListWidget();
        this.seedEdit.setValue(this.dataProvider.seed());
        if (!this.seedEdit.isFocused()) {
            this.seedEdit.moveCursorToStart(false);
        }
        if (this.cfg.heightmapMinY == this.cfg.heightmapMaxY) {
            ++this.cfg.heightmapMaxY;
        } else if (this.cfg.heightmapMaxY < this.cfg.heightmapMinY) {
            int tmp = this.cfg.heightmapMaxY;
            this.cfg.heightmapMaxY = this.cfg.heightmapMinY;
            this.cfg.heightmapMinY = tmp;
        }
        WorldDataConfiguration worldDataConfiguration = this.dataProvider.worldDataConfiguration(wcContext);
        Registry biomeRegistry = this.dataProvider.registryAccess(wcContext).registryOrThrow(Registries.BIOME);
        Registry strucutreRegistry = this.dataProvider.registryAccess(wcContext).registryOrThrow(Registries.STRUCTURE);
        this.levelStemRegistry = this.dataProvider.levelStemRegistry(wcContext);
        this.levelStemKeys = this.levelStemRegistry.keySet().stream().sorted(Comparator.comparing(Object::toString)).toList();
        this.settings.active = true;
        if (this.renderSettings.dimension == null || !this.levelStemRegistry.containsKey(this.renderSettings.dimension)) {
            this.renderSettings.dimension = this.levelStemRegistry.containsKey(LevelStem.OVERWORLD) ? LevelStem.OVERWORLD.location() : (ResourceLocation)this.levelStemRegistry.keySet().iterator().next();
        }
        LevelStem levelStem = (LevelStem)this.levelStemRegistry.get(this.renderSettings.dimension);
        HashSet<ResourceLocation> caveBiomes = new HashSet<ResourceLocation>();
        for (TagKey<Biome> tagKey : List.of(C_CAVE, C_IS_CAVE, FORGE_CAVE, FORGE_IS_CAVE)) {
            caveBiomes.addAll(StreamSupport.stream(biomeRegistry.getTagOrEmpty(tagKey).spliterator(), false).map(x -> ((ResourceKey)x.unwrapKey().orElseThrow()).location()).toList());
        }
        this.previewData = this.previewMappingData.generateMapData(biomeRegistry.keySet(), caveBiomes, strucutreRegistry.keySet(), StreamSupport.stream(strucutreRegistry.getTagOrEmpty(DISPLAY_BY_DEFAULT).spliterator(), false).map(x -> ((ResourceKey)x.unwrapKey().orElseThrow()).location()).collect(Collectors.toSet()));
        ColorMap colorMap = this.previewData.colorMaps().get(this.cfg.colorMap);
        if (colorMap == null) {
            this.cfg.colorMap = "world_preview:inferno";
        }
        LayeredRegistryAccess<RegistryLayer> layeredRegistryAccess = this.dataProvider.layeredRegistryAccess(wcContext);
        this.workManager.cancel();
        Runnable changeWorldGenState = () -> this.workManager.changeWorldGenState(levelStem, layeredRegistryAccess, this.previewData, this.dataProvider.worldOptions(wcContext), worldDataConfiguration, this.dataProvider, this.minecraft.getProxy(), this.dataProvider.tempDataPackDir(), this.dataProvider.minecraftServer());
        if (this.serverThreadPoolExecutor != null) {
            try {
                CompletableFuture.runAsync(changeWorldGenState, this.serverThreadPoolExecutor).get();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
        } else {
            changeWorldGenState.run();
        }
        this.workManager.postChangeWorldGenState();
        List<String> missing = Arrays.stream(this.previewData.biomeId2BiomeData()).filter(x -> x.dataSource() == PreviewData.DataSource.MISSING).map(PreviewData.BiomeData::tag).map(ResourceLocation::toString).toList();
        this.worldPreview.writeMissingColors(missing);
        this.allBiomes = (BiomesList.BiomeEntry[])biomeRegistry.holders().map(x -> {
            short id = this.previewData.biome2Id().getShort((Object)x.key().location().toString());
            PreviewData.BiomeData biomeData = this.previewData.biomeId2BiomeData()[id];
            int color = biomeData.color();
            int initialColor = biomeData.resourceOnlyColor();
            boolean isCave = biomeData.isCave();
            boolean initialIsCave = biomeData.resourceOnlyIsCave();
            String explicitName = biomeData.name();
            PreviewData.DataSource dataSource = biomeData.dataSource();
            return this.biomesList.createEntry((Holder.Reference<Biome>)x, id, color, initialColor, isCave, initialIsCave, explicitName, dataSource);
        }).sorted(Comparator.comparing(BiomesList.BiomeEntry::id)).toArray(BiomesList.BiomeEntry[]::new);
        this.biomesList.replaceEntries((Collection<BiomesList.BiomeEntry>)new ArrayList<BiomesList.BiomeEntry>());
        this.biomesList.setSelected((BiomesList.BiomeEntry)null);
        missing = Arrays.stream(this.previewData.structId2StructData()).filter(x -> x.dataSource() == PreviewData.DataSource.MISSING).map(PreviewData.StructureData::tag).map(ResourceLocation::toString).toList();
        this.worldPreview.writeMissingStructures(missing);
        this.freeStructureIcons();
        ResourceManager builtinResourceManager = this.minecraft.getResourceManager();
        HashMap<ResourceLocation, NativeImage> icons = new HashMap<ResourceLocation, NativeImage>();
        this.allStructureIcons = new NativeImage[this.previewData.structId2StructData().length];
        for (int i = 0; i < this.previewData.structId2StructData().length; ++i) {
            PreviewData.StructureData data = this.previewData.structId2StructData()[i];
            this.allStructureIcons[i] = icons.computeIfAbsent(data.icon(), x -> {
                NativeImage nativeImage;
                block12: {
                    Optional resource;
                    if (x == null) {
                        x = ResourceLocation.parse((String)"world_preview:textures/structure/unknown.png");
                    }
                    if ((resource = builtinResourceManager.getResource(x)).isEmpty()) {
                        resource = this.workManager.sampleResourceManager().getResource(x);
                    }
                    if (resource.isEmpty()) {
                        WorldPreview.LOGGER.error("Failed to load structure icon: '{}'", x);
                        resource = builtinResourceManager.getResource(ResourceLocation.parse((String)"world_preview:textures/structure/unknown.png"));
                    }
                    if (resource.isEmpty()) {
                        WorldPreview.LOGGER.error("FATAL ERROR LOADING: '{}' -- unable to load fallback!", x);
                        return new NativeImage(16, 16, true);
                    }
                    InputStream in = ((Resource)resource.get()).open();
                    try {
                        nativeImage = NativeImage.read((InputStream)in);
                        if (in == null) break block12;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (in != null) {
                                try {
                                    in.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            return new NativeImage(16, 16, true);
                        }
                    }
                    in.close();
                }
                return nativeImage;
            });
        }
        Optional playerResource = builtinResourceManager.getResource(ResourceLocation.parse((String)"world_preview:textures/etc/player.png"));
        Optional spawnResource = builtinResourceManager.getResource(ResourceLocation.parse((String)"world_preview:textures/etc/bed.png"));
        try (InputStream inPlayer = ((Resource)playerResource.orElseThrow()).open();
             InputStream inSpawn = ((Resource)spawnResource.orElseThrow()).open();){
            this.playerIcon = NativeImage.read((InputStream)inPlayer);
            this.spawnIcon = NativeImage.read((InputStream)inSpawn);
        }
        catch (IOException e) {
            this.playerIcon = new NativeImage(16, 16, true);
            this.spawnIcon = new NativeImage(16, 16, true);
            e.printStackTrace();
        }
        Registry itemRegistry = layeredRegistryAccess.compositeAccess().registryOrThrow(Registries.ITEM);
        this.allStructures = (StructuresList.StructureEntry[])strucutreRegistry.holders().map(x -> {
            short id = this.previewData.struct2Id().getShort((Object)x.key().location().toString());
            PreviewData.StructureData structureData = this.previewData.structId2StructData()[id];
            return this.structuresList.createEntry(id, x.key().location(), this.allStructureIcons[id], structureData.item() == null ? null : (Item)itemRegistry.get(structureData.item()), structureData.name(), structureData.showByDefault(), structureData.showByDefault());
        }).sorted(Comparator.comparing(StructuresList.StructureEntry::id)).toArray(StructuresList.StructureEntry[]::new);
        this.structuresList.replaceEntries((Collection<StructuresList.StructureEntry>)new ArrayList<StructuresList.StructureEntry>());
        this.renderSettings.resetCenter();
        if (this.cfg.sampleStructures) {
            this.toggleShowStructures.active = true;
            this.toggleShowStructures.setTooltip(Tooltip.create((Component)WorldPreviewComponents.BTN_TOGGLE_STRUCTURES));
        } else {
            this.toggleShowStructures.active = false;
            this.toggleShowStructures.setTooltip(Tooltip.create((Component)WorldPreviewComponents.BTN_TOGGLE_STRUCTURES_DISABLED));
        }
        if (this.cfg.sampleHeightmap) {
            this.toggleHeightmap.active = true;
            this.toggleHeightmap.setTooltip(Tooltip.create((Component)WorldPreviewComponents.BTN_TOGGLE_HEIGHTMAP));
        } else {
            this.toggleHeightmap.active = false;
            this.toggleHeightmap.setTooltip(Tooltip.create((Component)WorldPreviewComponents.BTN_TOGGLE_HEIGHTMAP_DISABLED));
            RenderSettings.RenderMode renderMode = this.renderSettings.mode = this.renderSettings.mode == RenderSettings.RenderMode.HEIGHTMAP ? RenderSettings.RenderMode.BIOMES : this.renderSettings.mode;
        }
        if (this.cfg.sampleIntersections) {
            this.toggleIntersections.active = true;
            this.toggleIntersections.setTooltip(Tooltip.create((Component)WorldPreviewComponents.BTN_TOGGLE_INTERSECT));
        } else {
            this.toggleIntersections.active = false;
            this.toggleIntersections.setTooltip(Tooltip.create((Component)WorldPreviewComponents.BTN_TOGGLE_INTERSECT_DISABLED));
            RenderSettings.RenderMode renderMode = this.renderSettings.mode = this.renderSettings.mode == RenderSettings.RenderMode.INTERSECTIONS ? RenderSettings.RenderMode.BIOMES : this.renderSettings.mode;
        }
        if (this.cfg.storeNoiseSamples) {
            this.toggleNoise.active = true;
            this.toggleNoise.setTooltip(Tooltip.create((Component)WorldPreviewComponents.BTN_TOGGLE_NOISE));
        } else {
            this.toggleNoise.active = false;
            this.toggleNoise.setTooltip(Tooltip.create((Component)WorldPreviewComponents.BTN_TOGGLE_NOISE_DISABLED));
            this.renderSettings.mode = this.renderSettings.mode.isNoise() ? RenderSettings.RenderMode.BIOMES : this.renderSettings.mode;
        }
        this.selectViewMode(this.renderSettings.mode);
        this.previewDisplay.reloadData();
        this.previewDisplay.setSelectedBiomeId((short)-1);
        this.previewDisplay.setHighlightCaves(false);
        this.toggleCaves.selected = false;
    }

    @Override
    public void onVisibleBiomesChanged(Short2LongMap visibleBiomes) {
        List<BiomesList.BiomeEntry> res = visibleBiomes.short2LongEntrySet().stream().sorted(Comparator.comparing(Short2LongMap.Entry::getLongValue).reversed()).map(Short2LongMap.Entry::getShortKey).map(x -> this.allBiomes[x]).toList();
        this.biomesList.replaceEntries((Collection<BiomesList.BiomeEntry>)res);
    }

    @Override
    public void onVisibleStructuresChanged(Short2LongMap visibleStructures) {
        List<StructuresList.StructureEntry> res = visibleStructures.short2LongEntrySet().stream().sorted(Comparator.comparing(Short2LongMap.Entry::getLongValue)).map(Short2LongMap.Entry::getShortKey).map(x -> this.allStructures[x]).toList();
        this.structuresList.replaceEntries((Collection<StructuresList.StructureEntry>)res);
    }

    private void randomizeSeed(Button btn) {
        UUID uuid = UUID.randomUUID();
        ByteBuffer bb = ByteBuffer.allocate(16);
        bb.putLong(uuid.getMostSignificantBits());
        bb.putLong(uuid.getLeastSignificantBits());
        String uuidSeed = Base64.getEncoder().encodeToString(bb.array()).substring(0, 16);
        this.setSeed(uuidSeed);
    }

    private void saveCurrentSeed(Button btn) {
        this.cfg.savedSeeds.add(this.dataProvider.seed());
        this.saveSeed.active = false;
        this.updateSeedListWidget();
    }

    public void deleteSeed(String seed) {
        this.cfg.savedSeeds.remove(seed);
        this.updateSeedListWidget();
    }

    public void setSeed(String seed) {
        if (Objects.equals(this.dataProvider.seed(), seed) || !this.dataProvider.seedIsEditable()) {
            return;
        }
        boolean initialInhibitUpdates = this.inhibitUpdates;
        this.inhibitUpdates = true;
        try {
            this.dataProvider.updateSeed(seed);
        }
        finally {
            this.inhibitUpdates = initialInhibitUpdates;
        }
        this.updateSettings();
    }

    private void updateSeedListWidget() {
        this.seedEntries = this.cfg.savedSeeds.stream().map(this.seedsList::createEntry).toList();
        this.seedsList.replaceEntries(this.seedEntries);
        int idx = this.cfg.savedSeeds.indexOf(this.dataProvider.seed());
        if (idx >= 0) {
            this.seedsList.setSelected((AbstractSelectionList.Entry)this.seedEntries.get(idx));
        }
    }

    public void resetTabs() {
        this.onTabButtonChange(this.switchBiomes, DisplayType.BIOMES);
    }

    private void moveList(BaseObjectSelectionList<?> theList) {
        if (theList.active && theList.getX() > 0 || !theList.active && theList.getX() < 0) {
            return;
        }
        int newX = theList.getX() + (theList.active ? 4096 : -4096);
        theList.setPosition(newX, theList.getY());
    }

    private void onTabButtonChange(Button btn, DisplayType type) {
        this.biomesList.visible = false;
        this.biomesList.active = false;
        this.structuresList.visible = false;
        this.structuresList.active = false;
        this.seedsList.visible = false;
        this.seedsList.active = false;
        this.switchBiomes.active = true;
        this.switchStructures.active = true;
        this.switchSeeds.active = true;
        this.resetDefaultStructureVisibility.visible = false;
        if (this.cfg.sampleStructures) {
            this.switchStructures.setTooltip(null);
        } else {
            this.switchStructures.setTooltip(Tooltip.create((Component)WorldPreviewComponents.BTN_SWITCH_STRUCT_DISABLED));
            this.switchStructures.active = false;
        }
        btn.active = false;
        switch (type.ordinal()) {
            case 0: {
                this.biomesList.visible = true;
                this.biomesList.active = true;
                break;
            }
            case 1: {
                this.resetDefaultStructureVisibility.visible = true;
                this.structuresList.visible = true;
                this.structuresList.active = true;
                break;
            }
            case 2: {
                this.seedsList.visible = true;
                this.seedsList.active = true;
            }
        }
        this.moveList(this.biomesList);
        this.moveList(this.structuresList);
        this.moveList(this.seedsList);
    }

    public synchronized void start() {
        WorldPreview.LOGGER.info("Start generating biome data...");
        if (this.dataProvider.seed().isEmpty()) {
            this.randomizeSeed(null);
        }
        this.inhibitUpdates = false;
        this.updateSettings();
    }

    public synchronized void stop() {
        WorldPreview.LOGGER.info("Stop generating biome data...");
        this.inhibitUpdates = true;
        this.workManager.cancel();
    }

    public void doLayout(ScreenRectangle screenRectangle) {
        if (screenRectangle == null) {
            screenRectangle = this.minecraft.screen.getRectangle();
        }
        this.lastScreenRectangle = screenRectangle;
        int leftWidth = Math.max(130, Math.min(180, screenRectangle.width() / 3));
        int left = screenRectangle.left() + 3;
        int previewLeft = left + leftWidth + 3;
        int top = screenRectangle.top() + 2;
        int bottom = screenRectangle.bottom() - 32;
        int expand = this.toggleExpand.selected ? 24 : 0;
        this.previewDisplay.setPosition(previewLeft, top + expand + 1);
        this.previewDisplay.setSize(screenRectangle.right() - this.previewDisplay.getX() - 4, screenRectangle.bottom() - this.previewDisplay.getY() - 14);
        this.seedEdit.setWidth(leftWidth - 1 - 44);
        this.seedEdit.setX(left);
        this.seedEdit.setY(bottom + 1);
        this.randomSeedButton.setX(left + leftWidth - 20);
        this.randomSeedButton.setY(bottom);
        this.saveSeed.setX(left + leftWidth - 22 - 20);
        this.saveSeed.setY(bottom);
        int cycleWith = leftWidth - 88;
        int btnStart = left + cycleWith + 2;
        this.settings.setPosition(left, top);
        int i = 0;
        this.toggleShowStructures.setPosition(btnStart + 22 * i++, top);
        this.toggleCaves.setPosition(btnStart + 22 * i++, top);
        this.resetToZeroZero.setPosition(btnStart + 22 * i++, top);
        this.toggleExpand.setPosition(btnStart + 22 * i++, top);
        i = 0;
        this.toggleBiomes.setPosition(previewLeft + 22 * i++, top);
        this.toggleIntersections.setPosition(previewLeft + 22 * i++, top);
        this.toggleHeightmap.setPosition(previewLeft + 22 * i++, top);
        this.toggleNoise.setPosition(previewLeft + 22 * i++, top);
        this.noiseCycleButton.setPosition(previewLeft + 22 * i++, top);
        int switchBiomesWidth = 45;
        int switchSeedsWidth = 45;
        int switchStructuresWidth = leftWidth - switchBiomesWidth - switchSeedsWidth - 4;
        this.switchBiomes.setPosition(left, top += 24);
        this.switchStructures.setPosition(left + switchBiomesWidth + 2, top);
        this.switchSeeds.setPosition(left + switchBiomesWidth + switchStructuresWidth + 4, top);
        this.switchBiomes.setWidth(switchBiomesWidth);
        this.switchStructures.setWidth(switchStructuresWidth);
        this.switchSeeds.setWidth(switchSeedsWidth);
        this.biomesList.setPosition(left, top += 24);
        this.biomesList.setSize(leftWidth, bottom - top - 4);
        this.seedsList.setPosition(left, top);
        this.seedsList.setSize(leftWidth, bottom - top - 4);
        this.resetDefaultStructureVisibility.setPosition(left, bottom -= 24);
        this.resetDefaultStructureVisibility.setWidth(leftWidth);
        this.structuresList.setPosition(left, top);
        this.structuresList.setSize(leftWidth, bottom - top - 4);
        this.moveList(this.biomesList);
        this.moveList(this.structuresList);
        this.moveList(this.seedsList);
    }

    @Override
    public void close() {
        this.workManager.cancel();
        this.previewDisplay.close();
        this.freeStructureIcons();
    }

    private void freeStructureIcons() {
        if (this.allStructureIcons == null) {
            return;
        }
        Arrays.stream(this.allStructureIcons).filter(Objects::nonNull).forEach(NativeImage::close);
    }

    public List<BiomesList.BiomeEntry> allBiomes() {
        return Arrays.stream(this.allBiomes).sorted(Comparator.comparing(BiomesList.BiomeEntry::name)).toList();
    }

    public List<ResourceLocation> levelStemKeys() {
        return this.levelStemKeys;
    }

    public Registry<LevelStem> levelStemRegistry() {
        return this.levelStemRegistry;
    }

    @Override
    public BiomesList.BiomeEntry biome4Id(int id) {
        return this.allBiomes[id];
    }

    @Override
    public StructuresList.StructureEntry structure4Id(int id) {
        return this.allStructures[id];
    }

    @Override
    public NativeImage[] structureIcons() {
        return this.allStructureIcons;
    }

    @Override
    public NativeImage playerIcon() {
        return this.playerIcon;
    }

    @Override
    public NativeImage spawnIcon() {
        return this.spawnIcon;
    }

    @Override
    public ItemStack[] structureItems() {
        return (ItemStack[])Arrays.stream(this.allStructures).map(StructuresList.StructureEntry::itemStack).toArray(ItemStack[]::new);
    }

    @Override
    public void onBiomeVisuallySelected(BiomesList.BiomeEntry entry) {
        this.biomesList.setSelected(entry, true);
        this.toggleCaves.selected = false;
        this.previewDisplay.setHighlightCaves(false);
    }

    @Override
    public PreviewData previewData() {
        return this.previewData;
    }

    public WorkManager workManager() {
        return this.workManager;
    }

    @Override
    public PreviewDisplayDataProvider.StructureRenderInfo[] renderStructureMap() {
        return this.allStructures;
    }

    @Override
    public int[] heightColorMap() {
        ColorMap colorMap = this.previewData.colorMaps().get(this.cfg.colorMap);
        if (colorMap == null) {
            int[] black = new int[this.workManager.yMax() - this.workManager.yMin()];
            Arrays.fill(black, -16777216);
            return black;
        }
        return colorMap.bake(this.workManager.yMin(), this.workManager.yMax(), this.cfg.heightmapMinY, this.cfg.heightmapMaxY);
    }

    @Override
    public int[] noiseColorMap() {
        ColorMap colorMap = this.previewData.colorMaps().get(this.cfg.colorMap);
        if (colorMap == null) {
            int[] black = new int[256];
            Arrays.fill(black, -16777216);
            return black;
        }
        return colorMap.bake(1024);
    }

    @Override
    public int yMin() {
        return this.workManager.yMin();
    }

    @Override
    public int yMax() {
        return this.workManager.yMax();
    }

    @Override
    public boolean isUpdating() {
        return this.isUpdating;
    }

    @Override
    public boolean setupFailed() {
        return this.setupFailed;
    }

    @Override
    @NotNull
    public PreviewDisplayDataProvider.PlayerData getPlayerData(UUID playerId) {
        if (this.workManager == null || this.workManager.sampleUtils() == null) {
            return new PreviewDisplayDataProvider.PlayerData(null, null);
        }
        ServerPlayer player = this.workManager.sampleUtils().getPlayers(playerId);
        if (player == null) {
            return new PreviewDisplayDataProvider.PlayerData(null, null);
        }
        ResourceKey playerDimension = player.level().dimension();
        ResourceKey respawnDimension = player.getRespawnDimension();
        ResourceKey<Level> currentDimension = this.workManager.sampleUtils().dimension();
        return new PreviewDisplayDataProvider.PlayerData(currentDimension.equals((Object)playerDimension) ? player.blockPosition() : null, currentDimension.equals((Object)respawnDimension) ? player.getRespawnPosition() : null);
    }

    public ToggleButton toggleCaves() {
        return this.toggleCaves;
    }

    public ToggleButton toggleShowStructures() {
        return this.toggleShowStructures;
    }

    public ToggleButton toggleHeightmap() {
        return this.toggleHeightmap;
    }

    public ToggleButton toggleIntersections() {
        return this.toggleIntersections;
    }

    public PreviewContainerDataProvider dataProvider() {
        return this.dataProvider;
    }

    public List<AbstractWidget> widgets() {
        return this.toRender;
    }

    public static enum DisplayType {
        BIOMES,
        STRUCTURES,
        SEEDS;


        public Component component() {
            return DisplayType.toComponent(this);
        }

        public static Component toComponent(DisplayType x) {
            return Component.translatable((String)("world_preview.preview.btn-cycle." + x.name()));
        }
    }
}

