/*
 * Decompiled with CFR 0.152.
 */
package caeruleustait.world.preview.client.gui.widgets;

import caeruleustait.world.preview.client.WorldPreviewClient;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.CommonComponents;
import org.joml.Matrix4f;

public class ColorChooser
extends AbstractWidget {
    public static final int INITIAL_SV_SQUARE_SIZE = 128;
    public static final int INITIAL_H_BAR_WIDTH = 16;
    public static final int SEPARATOR = 10;
    public static final int INITIAL_FINAL_COLOR_HEIGHT = 20;
    private int svSquareSize = 128;
    private int hBarWidth = 16;
    private int finalColorHeight = 20;
    private float hue = 0.0f;
    private float saturation = 0.0f;
    private float value = 0.0f;
    private int argbColor = -16777216;
    private int argbHueOnly = -16777216;
    private ColorUpdater updater;

    public ColorChooser(int x, int y) {
        super(x, y, 10, 10, CommonComponents.EMPTY);
        this.recalculateSize();
    }

    private void recalculateSize() {
        this.width = this.svSquareSize + 10 + this.hBarWidth;
        this.height = this.svSquareSize + 10 + this.finalColorHeight;
    }

    public void setSquareSize(int squareSize) {
        float scalor = (float)squareSize / 128.0f;
        this.svSquareSize = squareSize;
        this.hBarWidth = (int)(16.0f * scalor);
        this.finalColorHeight = (int)(20.0f * scalor);
        this.recalculateSize();
    }

    public void renderWidget(GuiGraphics guiGraphics, int i, int j, float f) {
        guiGraphics.fill(this.getX() - 2, this.getY() - 2, this.getX() + this.width + 2, this.getY() + this.height + 2, 0x77000000);
        RenderSystem.setShader(() -> WorldPreviewClient.HSV_SHADER);
        Matrix4f posMatrix = guiGraphics.pose().last().pose();
        int leftX = this.getX();
        int topY = this.getY();
        int rightX = leftX + this.svSquareSize;
        int botY = topY + this.svSquareSize;
        BufferBuilder buffer = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        buffer.addVertex(posMatrix, (float)leftX, (float)topY, 0.0f).setColor(this.hue, 0.0f, 1.0f, 1.0f);
        buffer.addVertex(posMatrix, (float)leftX, (float)botY, 0.0f).setColor(this.hue, 0.0f, 0.0f, 1.0f);
        buffer.addVertex(posMatrix, (float)rightX, (float)botY, 0.0f).setColor(this.hue, 1.0f, 0.0f, 1.0f);
        buffer.addVertex(posMatrix, (float)rightX, (float)topY, 0.0f).setColor(this.hue, 1.0f, 1.0f, 1.0f);
        try (MeshData data = buffer.build();){
            if (data != null) {
                BufferUploader.drawWithShader((MeshData)data);
            }
        }
        int satX = leftX + Math.round(this.saturation * (float)this.svSquareSize);
        int valY = topY + Math.round((1.0f - this.value) * (float)this.svSquareSize);
        guiGraphics.fill(satX - 4, valY - 4, satX + 4, valY + 4, (double)this.value > 0.3 ? -16777216 : -1);
        guiGraphics.fill(satX - 3, valY - 3, satX + 3, valY + 3, this.argbColor);
        RenderSystem.setShader(() -> WorldPreviewClient.HSV_SHADER);
        leftX = rightX + 10;
        rightX = leftX + this.hBarWidth;
        buffer = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        buffer.addVertex(posMatrix, (float)leftX, (float)topY, 0.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        buffer.addVertex(posMatrix, (float)leftX, (float)botY, 0.0f).setColor(0.0f, 1.0f, 1.0f, 1.0f);
        buffer.addVertex(posMatrix, (float)rightX, (float)botY, 0.0f).setColor(0.0f, 1.0f, 1.0f, 1.0f);
        buffer.addVertex(posMatrix, (float)rightX, (float)topY, 0.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f);
        try (MeshData data = buffer.build();){
            if (data != null) {
                BufferUploader.drawWithShader((MeshData)data);
            }
        }
        int hueY = topY + Math.round((1.0f - this.hue) * (float)this.svSquareSize);
        guiGraphics.fill(leftX - 2, hueY - 4, rightX + 2, hueY + 4, -16777216);
        guiGraphics.fill(leftX - 1, hueY - 3, rightX + 1, hueY + 3, this.argbHueOnly);
        guiGraphics.fill(this.getX(), botY + 10, this.getX() + this.width, this.getY() + this.height, this.argbColor);
    }

    public boolean mouseEvent(double mouseX, double mouseY, int button, boolean playSound) {
        if (!(this.active && this.visible && this.isValidClickButton(button) && this.isMouseOver(mouseX, mouseY))) {
            return false;
        }
        if (Minecraft.getInstance().screen != null) {
            Minecraft.getInstance().screen.setFocused((GuiEventListener)this);
        }
        double leftX = this.getX();
        double topY = this.getY();
        double rightX = leftX + (double)this.svSquareSize;
        double botY = topY + (double)this.svSquareSize;
        boolean updated = false;
        if (mouseX >= leftX && mouseX <= rightX && mouseY >= topY && mouseY <= botY) {
            if (playSound) {
                this.playDownSound(Minecraft.getInstance().getSoundManager());
            }
            this.value = 1.0f - (float)((mouseY - topY) / (botY - topY));
            this.saturation = (float)((mouseX - leftX) / (rightX - leftX));
            updated = true;
        }
        leftX = rightX + 10.0;
        rightX = leftX + (double)this.hBarWidth;
        if (mouseX >= leftX && mouseX <= rightX && mouseY >= topY && mouseY <= botY) {
            if (playSound) {
                this.playDownSound(Minecraft.getInstance().getSoundManager());
            }
            this.hue = 1.0f - (float)((mouseY - topY) / (botY - topY));
            updated = true;
        }
        this.argbColor = Color.HSBtoRGB(this.hue, this.saturation, this.value);
        this.argbHueOnly = Color.HSBtoRGB(this.hue, 1.0f, 1.0f);
        if (updated) {
            this.runUpdater();
        }
        return updated;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        return this.mouseEvent(mouseX, mouseY, button, true);
    }

    protected void onDrag(double mouseX, double mouseY, double dragX, double dragY) {
        this.mouseEvent(mouseX, mouseY, 0, false);
    }

    public void runUpdater() {
        if (this.updater == null) {
            return;
        }
        this.updater.doUpdate((int)(this.hue * 360.0f), (int)(this.saturation * 100.0f), (int)(this.value * 100.0f));
    }

    public void setUpdater(ColorUpdater updater) {
        this.updater = updater;
    }

    public void updateHSV(int h, int s, int v) {
        this.hue = (float)h / 360.0f;
        this.saturation = (float)s / 100.0f;
        this.value = (float)v / 100.0f;
        this.argbColor = Color.HSBtoRGB(this.hue, this.saturation, this.value);
        this.argbHueOnly = Color.HSBtoRGB(this.hue, 1.0f, 1.0f);
        this.runUpdater();
    }

    public void updateRGB(int rgb) {
        int r = rgb >> 16 & 0xFF;
        int g = rgb >> 8 & 0xFF;
        int b = rgb & 0xFF;
        float[] hsv = Color.RGBtoHSB(r, g, b, null);
        this.hue = hsv[0];
        this.saturation = hsv[1];
        this.value = hsv[2];
        this.argbColor = Color.HSBtoRGB(this.hue, this.saturation, this.value);
        this.argbHueOnly = Color.HSBtoRGB(this.hue, 1.0f, 1.0f);
        this.runUpdater();
    }

    public int colorRGB() {
        return this.argbColor & 0xFFFFFF;
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }

    public static interface ColorUpdater {
        public void doUpdate(int var1, int var2, int var3);
    }
}

