/*
 * Decompiled with CFR 0.152.
 */
package phcmod.cubed_potions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.minecraft.class_1269;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1842;
import net.minecraft.class_1844;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5546;
import net.minecraft.class_6880;
import net.minecraft.class_9334;
import net.minecraft.server.MinecraftServer;
import phcmod.cubed_potions.PotionMixingHandler;

public class PotionMixingEvents {
    private static final Map<class_2338, CauldronState> CAULDRON_CONTENTS = new HashMap<class_2338, CauldronState>();
    private static int tickCounter = 0;

    public static void register() {
        UseBlockCallback.EVENT.register((player, world, hand, hitResult) -> {
            if (world.field_9236 || player == null) {
                return class_1269.field_5811;
            }
            class_2338 pos = hitResult.method_17777();
            if (!(world.method_8320(pos).method_26204() instanceof class_5546)) {
                return class_1269.field_5811;
            }
            class_1799 item = player.method_5998(hand);
            if (item.method_7960()) {
                CauldronState cauldronState = CAULDRON_CONTENTS.get(pos);
                if (cauldronState != null) {
                    for (int i = 0; i < cauldronState.count; ++i) {
                        class_1799 potion = PotionMixingEvents.createNamedPotion(cauldronState.effects, "\u0417\u0435\u043b\u044c\u0435 \u0438\u0437 \u043a\u043e\u0442\u043b\u0430");
                        potion.method_57379(class_9334.field_49651, (Object)new class_1844(Optional.empty(), Optional.empty(), cauldronState.effects));
                        PotionMixingEvents.dropItemAtCauldron(pos, potion, world);
                    }
                    CAULDRON_CONTENTS.remove(pos);
                    world.method_8396(null, pos, class_3417.field_14779, class_3419.field_15245, 1.0f, 1.0f);
                    return class_1269.field_5812;
                }
                return class_1269.field_5811;
            }
            if (item.method_7909() != class_1802.field_8574 && item.method_7909() != class_1802.field_8436 && item.method_7909() != class_1802.field_8150) {
                return class_1269.field_5811;
            }
            class_1844 potionContents = (class_1844)item.method_57824(class_9334.field_49651);
            if (potionContents == null) {
                return class_1269.field_5811;
            }
            ArrayList<class_1293> inputEffects = new ArrayList<class_1293>();
            if (potionContents.comp_2378().isPresent()) {
                inputEffects.addAll(((class_1842)((class_6880)potionContents.comp_2378().get()).comp_349()).method_8049());
            }
            inputEffects.addAll(potionContents.comp_2380());
            if (inputEffects.isEmpty()) {
                return class_1269.field_5811;
            }
            CauldronState cauldronState = CAULDRON_CONTENTS.get(pos);
            PotionMixingEvents.processPotionInCauldron(pos, inputEffects, cauldronState, player, world);
            return class_1269.field_5812;
        });
    }

    private static void processPotionInCauldron(class_2338 pos, List<class_1293> inputEffects, CauldronState cauldronState, class_1657 player, class_1937 world) {
        class_1293 lowered;
        if (cauldronState == null) {
            cauldronState = new CauldronState(new ArrayList<class_1293>(inputEffects), 1);
            CAULDRON_CONTENTS.put(pos, cauldronState);
            player.method_6047().method_7934(1);
            world.method_8396(null, pos, class_3417.field_14826, class_3419.field_15245, 1.0f, 1.0f);
            return;
        }
        if (PotionMixingEvents.isSamePotions(inputEffects, cauldronState.effects)) {
            ++cauldronState.count;
            if (cauldronState.count >= 3) {
                ArrayList<class_1293> upgradedEffects = new ArrayList<class_1293>();
                for (class_1293 effect : inputEffects) {
                    class_1293 upgraded = PotionMixingHandler.upgradePotionLevel(effect);
                    if (upgraded != null) {
                        upgradedEffects.add(upgraded);
                        continue;
                    }
                    player.method_6047().method_7934(1);
                    PotionMixingEvents.spawnFailureParticles(pos, world);
                    world.method_8396(null, pos, class_3417.field_15102, class_3419.field_15245, 0.5f, 1.0f);
                    for (int i = 0; i < cauldronState.count; ++i) {
                        class_1799 potion = PotionMixingEvents.createNamedPotion(cauldronState.effects, "\u0417\u0435\u043b\u044c\u0435 \u0438\u0437 \u043a\u043e\u0442\u043b\u0430");
                        potion.method_57379(class_9334.field_49651, (Object)new class_1844(Optional.empty(), Optional.empty(), cauldronState.effects));
                        PotionMixingEvents.dropItemAtCauldron(pos, potion, world);
                    }
                    CAULDRON_CONTENTS.remove(pos);
                    return;
                }
                class_1799 result = PotionMixingEvents.createNamedPotion(upgradedEffects, "\u0423\u043b\u0443\u0447\u0448\u0435\u043d\u043d\u043e\u0435 \u0437\u0435\u043b\u044c\u0435");
                result.method_57379(class_9334.field_49651, (Object)new class_1844(Optional.empty(), Optional.empty(), upgradedEffects));
                PotionMixingEvents.dropItemAtCauldron(pos, result, world);
                CAULDRON_CONTENTS.remove(pos);
                player.method_6047().method_7934(1);
                PotionMixingEvents.spawnUpgradeSuccessParticles(pos, world);
                world.method_8396(null, pos, class_3417.field_14978, class_3419.field_15245, 1.0f, 1.5f);
            } else {
                player.method_6047().method_7934(1);
                world.method_8396(null, pos, class_3417.field_14826, class_3419.field_15245, 1.0f, 1.0f + (float)cauldronState.count * 0.1f);
            }
            return;
        }
        ArrayList<class_1293> mixedEffects = new ArrayList<class_1293>();
        for (class_1293 effect : cauldronState.effects) {
            lowered = PotionMixingHandler.lowerPotionLevel(effect);
            if (lowered != null) {
                mixedEffects.add(lowered);
                continue;
            }
            player.method_6047().method_7934(1);
            PotionMixingEvents.spawnFailureParticles(pos, world);
            world.method_8396(null, pos, class_3417.field_15102, class_3419.field_15245, 0.5f, 1.0f);
            for (int i = 0; i < cauldronState.count; ++i) {
                class_1799 potion = PotionMixingEvents.createNamedPotion(cauldronState.effects, "\u0417\u0435\u043b\u044c\u0435 \u0438\u0437 \u043a\u043e\u0442\u043b\u0430");
                potion.method_57379(class_9334.field_49651, (Object)new class_1844(Optional.empty(), Optional.empty(), cauldronState.effects));
                PotionMixingEvents.dropItemAtCauldron(pos, potion, world);
            }
            class_1799 currentPotion = PotionMixingEvents.createNamedPotion(inputEffects, "\u0417\u0435\u043b\u044c\u0435 \u0438\u0437 \u043a\u043e\u0442\u043b\u0430");
            currentPotion.method_57379(class_9334.field_49651, (Object)new class_1844(Optional.empty(), Optional.empty(), inputEffects));
            PotionMixingEvents.dropItemAtCauldron(pos, currentPotion, world);
            CAULDRON_CONTENTS.remove(pos);
            return;
        }
        for (class_1293 effect : inputEffects) {
            lowered = PotionMixingHandler.lowerPotionLevel(effect);
            if (lowered != null) {
                mixedEffects.add(lowered);
                continue;
            }
            player.method_6047().method_7934(1);
            PotionMixingEvents.spawnFailureParticles(pos, world);
            world.method_8396(null, pos, class_3417.field_15102, class_3419.field_15245, 0.5f, 1.0f);
            for (int i = 0; i < cauldronState.count; ++i) {
                class_1799 potion = new class_1799((class_1935)class_1802.field_8574);
                potion.method_57379(class_9334.field_49651, (Object)new class_1844(Optional.empty(), Optional.empty(), cauldronState.effects));
                PotionMixingEvents.dropItemAtCauldron(pos, potion, world);
            }
            class_1799 currentPotion = new class_1799((class_1935)class_1802.field_8574);
            currentPotion.method_57379(class_9334.field_49651, (Object)new class_1844(Optional.empty(), Optional.empty(), inputEffects));
            PotionMixingEvents.dropItemAtCauldron(pos, currentPotion, world);
            CAULDRON_CONTENTS.remove(pos);
            return;
        }
        class_1799 potion1 = PotionMixingEvents.createNamedPotion(mixedEffects, "\u0421\u043c\u0435\u0448\u0430\u043d\u043d\u043e\u0435 \u0437\u0435\u043b\u044c\u0435");
        class_1799 potion2 = PotionMixingEvents.createNamedPotion(mixedEffects, "\u0421\u043c\u0435\u0448\u0430\u043d\u043d\u043e\u0435 \u0437\u0435\u043b\u044c\u0435");
        potion1.method_57379(class_9334.field_49651, (Object)new class_1844(Optional.empty(), Optional.empty(), mixedEffects));
        potion2.method_57379(class_9334.field_49651, (Object)new class_1844(Optional.empty(), Optional.empty(), mixedEffects));
        PotionMixingEvents.dropItemAtCauldron(pos, potion1, world);
        PotionMixingEvents.dropItemAtCauldron(pos, potion2, world);
        CAULDRON_CONTENTS.remove(pos);
        player.method_6047().method_7934(1);
        PotionMixingEvents.spawnMixSuccessParticles(pos, world);
        world.method_8396(null, pos, class_3417.field_14978, class_3419.field_15245, 1.0f, 0.8f);
    }

    private static boolean isSamePotions(List<class_1293> a, List<class_1293> b) {
        if (a.isEmpty() || b.isEmpty()) {
            return false;
        }
        if (a.size() != b.size()) {
            return false;
        }
        for (int i = 0; i < a.size(); ++i) {
            if (a.get(i).method_5579() == b.get(i).method_5579() && a.get(i).method_5578() == b.get(i).method_5578()) continue;
            return false;
        }
        return true;
    }

    private static class_1799 createNamedPotion(List<class_1293> effects, String name) {
        class_1799 potion = new class_1799((class_1935)class_1802.field_8574);
        potion.method_57379(class_9334.field_49651, (Object)new class_1844(Optional.empty(), Optional.empty(), effects));
        potion.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)name));
        return potion;
    }

    private static void dropItemAtCauldron(class_2338 pos, class_1799 stack, class_1937 world) {
        double x = (double)pos.method_10263() + 0.5;
        double y = (double)pos.method_10264() + 1.0;
        double z = (double)pos.method_10260() + 0.5;
        class_1542 itemEntity = new class_1542(world, x, y, z, stack);
        itemEntity.method_6988();
        world.method_8649((class_1297)itemEntity);
    }

    private static void spawnFailureParticles(class_2338 pos, class_1937 world) {
        if (world instanceof class_3218) {
            double offsetZ;
            double offsetY;
            double offsetX;
            int i;
            class_3218 serverWorld = (class_3218)world;
            double x = (double)pos.method_10263() + 0.5;
            double y = (double)pos.method_10264() + 1.0;
            double z = (double)pos.method_10260() + 0.5;
            for (i = 0; i < 15; ++i) {
                offsetX = (world.field_9229.method_43058() - 0.5) * 0.5;
                offsetY = world.field_9229.method_43058() * 0.5;
                offsetZ = (world.field_9229.method_43058() - 0.5) * 0.5;
                serverWorld.method_14199((class_2394)class_2398.field_11209, x + offsetX, y + offsetY, z + offsetZ, 1, 0.0, 0.0, 0.0, 0.0);
            }
            for (i = 0; i < 10; ++i) {
                offsetX = (world.field_9229.method_43058() - 0.5) * 0.3;
                offsetY = world.field_9229.method_43058() * 0.3;
                offsetZ = (world.field_9229.method_43058() - 0.5) * 0.3;
                serverWorld.method_14199((class_2394)class_2398.field_11237, x + offsetX, y + offsetY, z + offsetZ, 1, 0.0, 0.1, 0.0, 0.01);
            }
        }
    }

    private static void spawnUpgradeSuccessParticles(class_2338 pos, class_1937 world) {
        if (world instanceof class_3218) {
            double offsetZ;
            double offsetY;
            double offsetX;
            int i;
            class_3218 serverWorld = (class_3218)world;
            double x = (double)pos.method_10263() + 0.5;
            double y = (double)pos.method_10264() + 1.0;
            double z = (double)pos.method_10260() + 0.5;
            for (i = 0; i < 20; ++i) {
                offsetX = (world.field_9229.method_43058() - 0.5) * 0.6;
                offsetY = world.field_9229.method_43058() * 0.6;
                offsetZ = (world.field_9229.method_43058() - 0.5) * 0.6;
                serverWorld.method_14199((class_2394)class_2398.field_11215, x + offsetX, y + offsetY, z + offsetZ, 1, 0.0, 0.05, 0.0, 0.5);
            }
            for (i = 0; i < 8; ++i) {
                offsetX = (world.field_9229.method_43058() - 0.5) * 0.4;
                offsetY = world.field_9229.method_43058() * 0.4;
                offsetZ = (world.field_9229.method_43058() - 0.5) * 0.4;
                serverWorld.method_14199((class_2394)class_2398.field_11211, x + offsetX, y + offsetY, z + offsetZ, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }

    private static void spawnMixSuccessParticles(class_2338 pos, class_1937 world) {
        if (world instanceof class_3218) {
            double offsetZ;
            double offsetY;
            double offsetX;
            int i;
            class_3218 serverWorld = (class_3218)world;
            double x = (double)pos.method_10263() + 0.5;
            double y = (double)pos.method_10264() + 1.0;
            double z = (double)pos.method_10260() + 0.5;
            for (i = 0; i < 25; ++i) {
                offsetX = (world.field_9229.method_43058() - 0.5) * 0.5;
                offsetY = world.field_9229.method_43058() * 0.5;
                offsetZ = (world.field_9229.method_43058() - 0.5) * 0.5;
                serverWorld.method_14199((class_2394)class_2398.field_11249, x + offsetX, y + offsetY, z + offsetZ, 1, 0.0, 0.1, 0.0, 0.1);
            }
            for (i = 0; i < 12; ++i) {
                offsetX = (world.field_9229.method_43058() - 0.5) * 0.3;
                offsetY = world.field_9229.method_43058() * 0.4;
                offsetZ = (world.field_9229.method_43058() - 0.5) * 0.3;
                serverWorld.method_14199((class_2394)class_2398.field_11241, x + offsetX, y + offsetY, z + offsetZ, 1, 0.0, 0.0, 0.0, 0.0);
            }
            for (i = 0; i < 15; ++i) {
                offsetX = (world.field_9229.method_43058() - 0.5) * 0.4;
                offsetY = world.field_9229.method_43058() * 0.5;
                offsetZ = (world.field_9229.method_43058() - 0.5) * 0.4;
                serverWorld.method_14199((class_2394)class_2398.field_23114, x + offsetX, y + offsetY, z + offsetZ, 1, 0.0, 0.05, 0.0, 0.02);
            }
        }
    }

    public static void tickCauldronEffects(MinecraftServer server) {
        if (++tickCounter % 10 != 0) {
            return;
        }
        block0: for (Map.Entry<class_2338, CauldronState> entry : CAULDRON_CONTENTS.entrySet()) {
            class_2338 pos = entry.getKey();
            CauldronState state = entry.getValue();
            for (class_3218 world : server.method_3738()) {
                if (!(world.method_8320(pos).method_26204() instanceof class_5546)) continue;
                PotionMixingEvents.spawnAmbientCauldronParticles(pos, (class_1937)world, state.count);
                continue block0;
            }
        }
    }

    private static void spawnAmbientCauldronParticles(class_2338 pos, class_1937 world, int count) {
        if (world instanceof class_3218) {
            double offsetX;
            class_3218 serverWorld = (class_3218)world;
            double x = (double)pos.method_10263() + 0.5;
            double y = (double)pos.method_10264() + 0.3;
            double z = (double)pos.method_10260() + 0.5;
            if (world.field_9229.method_43057() < 0.3f) {
                offsetX = (world.field_9229.method_43058() - 0.5) * 0.2;
                double offsetZ = (world.field_9229.method_43058() - 0.5) * 0.2;
                serverWorld.method_14199((class_2394)class_2398.field_11251, x + offsetX, y + 0.5, z + offsetZ, 1, 0.0, 0.02, 0.0, 0.005);
            }
            if (count >= 2 && world.field_9229.method_43057() < 0.2f) {
                offsetX = (world.field_9229.method_43058() - 0.5) * 0.4;
                double offsetY = world.field_9229.method_43058() * 0.3;
                double offsetZ = (world.field_9229.method_43058() - 0.5) * 0.4;
                serverWorld.method_14199((class_2394)class_2398.field_11249, x + offsetX, y + offsetY, z + offsetZ, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }

    private static class CauldronState {
        List<class_1293> effects;
        int count;

        CauldronState(List<class_1293> effects, int count) {
            this.effects = effects;
            this.count = count;
        }
    }
}

