/*
 * Decompiled with CFR 0.152.
 */
package fr.lynzel.fdn.config;

import fr.lynzel.fdn.util.ColorUtils;
import fr.lynzel.fdn.util.DamageTypeUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.common.ModConfigSpec;

public class ClientConfig {
    public static final ModConfigSpec.BooleanValue MOD_IS_ENABLED;
    public static final ModConfigSpec.IntValue ANIM_DURATION;
    public static final ModConfigSpec.DoubleValue ANIM_MIN_SIZE;
    public static final ModConfigSpec.DoubleValue ANIM_MAX_SIZE;
    public static final ModConfigSpec.DoubleValue ANIM_MIN_BRIGHTNESS;
    public static final ModConfigSpec.DoubleValue ANIM_MAX_BRIGHTNESS;
    public static final ModConfigSpec.DoubleValue ANIM_MIN_OPACITY;
    public static final ModConfigSpec.DoubleValue ANIM_MAX_OPACITY;
    public static final ModConfigSpec.DoubleValue ANIM_MIN_SPEED;
    public static final ModConfigSpec.DoubleValue ANIM_MAX_SPEED;
    public static final Map<String, ModConfigSpec.ConfigValue<String>> DAMAGE_COLORS;
    public static final Map<String, ModConfigSpec.ConfigValue<String>> HEAL_COLORS;
    private static final Set<String> DAMAGE_TYPES;
    private static final ModConfigSpec.Builder BUILDER;
    private static final ModConfigSpec SPEC;

    public static void register(ModContainer modContainer) {
        modContainer.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)SPEC);
    }

    private static boolean isValidColor(Object input) {
        if (!(input instanceof String)) {
            return false;
        }
        String str = (String)input;
        String color = str.toUpperCase();
        return color.equals("NONE") || ColorUtils.isValidMinecraftColor(color) || ColorUtils.isValidHexColor(color);
    }

    static {
        DAMAGE_COLORS = new HashMap<String, ModConfigSpec.ConfigValue<String>>();
        HEAL_COLORS = new HashMap<String, ModConfigSpec.ConfigValue<String>>();
        DAMAGE_TYPES = DamageTypeUtils.loadFromDisk();
        BUILDER = new ModConfigSpec.Builder();
        MOD_IS_ENABLED = BUILDER.define("enabled", true);
        BUILDER.push("animation");
        ANIM_DURATION = BUILDER.defineInRange("duration", 16, 0, Integer.MAX_VALUE);
        BUILDER.push("size");
        ANIM_MIN_SIZE = BUILDER.defineInRange("min", 0.5, 0.0, 3.4028234663852886E38);
        ANIM_MAX_SIZE = BUILDER.defineInRange("max", 1.0, 0.0, 3.4028234663852886E38);
        BUILDER.pop();
        BUILDER.push("brightness");
        ANIM_MIN_BRIGHTNESS = BUILDER.defineInRange("min", 0.85, 0.0, 1.0);
        ANIM_MAX_BRIGHTNESS = BUILDER.defineInRange("max", 1.0, 0.0, 1.0);
        BUILDER.pop();
        BUILDER.push("opacity");
        ANIM_MIN_OPACITY = BUILDER.defineInRange("min", 0.0, 0.0, 1.0);
        ANIM_MAX_OPACITY = BUILDER.defineInRange("max", 1.0, 0.0, 1.0);
        BUILDER.pop();
        BUILDER.push("speed");
        ANIM_MIN_SPEED = BUILDER.defineInRange("min", 0.0, 0.0, 3.4028234663852886E38);
        ANIM_MAX_SPEED = BUILDER.defineInRange("max", 1.0, 0.0, 3.4028234663852886E38);
        BUILDER.pop();
        BUILDER.pop();
        BUILDER.push("color").comment("Colors can be Minecraft color name (GOLD), hex code (#FFAA00), or NONE to disable damage numbers for that type");
        BUILDER.push("damage");
        DAMAGE_COLORS.put("default", (ModConfigSpec.ConfigValue<String>)BUILDER.define("default", (Object)"GOLD", ClientConfig::isValidColor));
        DAMAGE_TYPES.forEach(damageType -> DAMAGE_COLORS.put((String)damageType, (ModConfigSpec.ConfigValue<String>)BUILDER.define(damageType, (Object)"GOLD", ClientConfig::isValidColor)));
        BUILDER.pop();
        BUILDER.push("heal");
        HEAL_COLORS.put("default", (ModConfigSpec.ConfigValue<String>)BUILDER.define("default", (Object)"DARK_GREEN", ClientConfig::isValidColor));
        BUILDER.pop();
        BUILDER.pop();
        SPEC = BUILDER.build();
    }
}

