/*
 * Decompiled with CFR 0.152.
 */
package fr.lynzel.fdn.events;

import com.mojang.blaze3d.vertex.PoseStack;
import fr.lynzel.fdn.particle.DamageParticle;
import fr.lynzel.fdn.util.DamageTypeUtils;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;
import net.neoforged.neoforge.client.event.RenderGuiEvent;

public class ClientForgeEventHandler {
    public ClientForgeEventHandler(IEventBus forgeEventBus) {
        forgeEventBus.addListener(EventPriority.NORMAL, this::onClientLoginIn);
        forgeEventBus.addListener(EventPriority.NORMAL, this::onRenderGui);
    }

    public void onClientLoginIn(ClientPlayerNetworkEvent.LoggingIn event) {
        Minecraft minecraft = Minecraft.getInstance();
        ClientLevel level = minecraft.level;
        if (level == null) {
            return;
        }
        Set<ResourceLocation> damageTypes = level.registryAccess().lookupOrThrow(Registries.DAMAGE_TYPE).listElements().map(holder -> holder.key().location()).collect(Collectors.toSet());
        DamageTypeUtils.saveToDisk(damageTypes);
    }

    public void onRenderGui(RenderGuiEvent.Post event) {
        PoseStack poseStack = event.getGuiGraphics().pose();
        float partialTicks = event.getPartialTick().getGameTimeDeltaPartialTick(true);
        DamageParticle.DAMAGE_PARTICLES.forEach(damageParticle -> damageParticle.customRender(poseStack, partialTicks));
    }
}

