/*
 * Decompiled with CFR 0.152.
 */
package net.mrwilfis.treasures_of_the_dead.block;

import java.util.function.Supplier;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import net.mrwilfis.treasures_of_the_dead.block.custom.SkullMerchantTableBlock;
import net.mrwilfis.treasures_of_the_dead.block.custom.SmallBrazierBlock;
import net.mrwilfis.treasures_of_the_dead.item.ModItems;

public class ModBlocks {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"treasures_of_the_dead");
    public static final RegistryObject<Block> SKULL_MERCHANT_TABLE = ModBlocks.registryBlock("skull_merchant_table", () -> new SkullMerchantTableBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283825_).m_60978_(2.5f).m_60918_(SoundType.f_56736_).m_278183_()));
    public static final RegistryObject<Block> SMALL_IRON_BRAZIER = ModBlocks.registryBlock("small_iron_brazier", () -> new SmallBrazierBlock(1, 15, BlockBehaviour.Properties.m_284310_().m_60955_().m_284180_(MapColor.f_283906_).m_60978_(3.5f).m_60918_(SoundType.f_56762_)));
    public static final RegistryObject<Block> SMALL_GOLDEN_BRAZIER = ModBlocks.registryBlock("small_golden_brazier", () -> new SmallBrazierBlock(1, 15, BlockBehaviour.Properties.m_284310_().m_60955_().m_284180_(MapColor.f_283906_).m_60978_(3.5f).m_60918_(SoundType.f_56762_)));
    public static final RegistryObject<Block> SMALL_IRON_SOUL_BRAZIER = ModBlocks.registryBlock("small_iron_soul_brazier", () -> new SmallBrazierBlock(2, 10, BlockBehaviour.Properties.m_284310_().m_60955_().m_284180_(MapColor.f_283906_).m_60978_(3.5f).m_60918_(SoundType.f_56762_)));
    public static final RegistryObject<Block> SMALL_GOLDEN_SOUL_BRAZIER = ModBlocks.registryBlock("small_golden_soul_brazier", () -> new SmallBrazierBlock(2, 10, BlockBehaviour.Properties.m_284310_().m_60955_().m_284180_(MapColor.f_283906_).m_60978_(3.5f).m_60918_(SoundType.f_56762_)));

    private static <T extends Block> RegistryObject<T> registryBlock(String name, Supplier<T> block) {
        RegistryObject toReturn = BLOCKS.register(name, block);
        ModBlocks.registerBlockItem(name, toReturn);
        return toReturn;
    }

    private static <T extends Block> RegistryObject<Item> registerBlockItem(String name, RegistryObject<T> block) {
        return ModItems.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
    }

    public static void register(IEventBus eventBus) {
        BLOCKS.register(eventBus);
    }
}

