/*
 * Decompiled with CFR 0.152.
 */
package net.mrwilfis.treasures_of_the_dead.entity.client;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.mrwilfis.treasures_of_the_dead.entity.client.CaptainSkeletonModel;
import net.mrwilfis.treasures_of_the_dead.entity.custom.CaptainSkeletonEntity;
import net.mrwilfis.treasures_of_the_dead.entity.variant.CaptainSkeletonVariant;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;
import software.bernie.geckolib.renderer.GeoRenderer;
import software.bernie.geckolib.renderer.layer.BlockAndItemGeoLayer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;
import software.bernie.geckolib.renderer.layer.ItemArmorGeoLayer;

public class CaptainSkeletonRenderer
extends GeoEntityRenderer<CaptainSkeletonEntity> {
    private static final String LEFT_HAND = "left_hand";
    private static final String RIGHT_HAND = "right_hand";
    private static final String LEFT_BOOT = "left_boot";
    private static final String RIGHT_BOOT = "right_boot";
    private static final String LEFT_ARMOR_LEG = "left_armor_leg";
    private static final String RIGHT_ARMOR_LEG = "right_armor_leg";
    private static final String CHESTPLATE = "chestplate";
    private static final String CHEST_LEGGINGS = "chest_leggings";
    private static final String HELMET = "helmet";
    private static final String RIGHT_SLEEVE = "right_sleeve";
    private static final String LEFT_SLEEVE = "left_sleeve";
    protected ItemStack mainHandItem;
    protected ItemStack offhandItem;
    public static final Map<CaptainSkeletonVariant, ResourceLocation> LOCATION_BY_VARIANT = (Map)Util.m_137469_((Object)Maps.newEnumMap(CaptainSkeletonVariant.class), p_114874_ -> {
        p_114874_.put(CaptainSkeletonVariant.DEFAULT, new ResourceLocation("treasures_of_the_dead", "textures/entity/pirate_skeleton1.png"));
        p_114874_.put(CaptainSkeletonVariant.VAR1, new ResourceLocation("treasures_of_the_dead", "textures/entity/pirate_skeleton2.png"));
        p_114874_.put(CaptainSkeletonVariant.VAR2, new ResourceLocation("treasures_of_the_dead", "textures/entity/pirate_skeleton3.png"));
        p_114874_.put(CaptainSkeletonVariant.VAR3, new ResourceLocation("treasures_of_the_dead", "textures/entity/pirate_skeleton4.png"));
        p_114874_.put(CaptainSkeletonVariant.VAR4, new ResourceLocation("treasures_of_the_dead", "textures/entity/pirate_skeleton5.png"));
        p_114874_.put(CaptainSkeletonVariant.VAR5, new ResourceLocation("treasures_of_the_dead", "textures/entity/pirate_skeleton6.png"));
        p_114874_.put(CaptainSkeletonVariant.VAR6, new ResourceLocation("treasures_of_the_dead", "textures/entity/captain_skeleton1.png"));
        p_114874_.put(CaptainSkeletonVariant.VAR7, new ResourceLocation("treasures_of_the_dead", "textures/entity/captain_skeleton2.png"));
    });

    public CaptainSkeletonRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager, (GeoModel)new CaptainSkeletonModel());
        this.f_114477_ = 0.5f;
        this.addRenderLayer((GeoRenderLayer)new ItemArmorGeoLayer<CaptainSkeletonEntity>((GeoRenderer)this){

            @Nullable
            protected ItemStack getArmorItemForBone(GeoBone bone, CaptainSkeletonEntity animatable) {
                return switch (bone.getName()) {
                    case CaptainSkeletonRenderer.LEFT_BOOT, CaptainSkeletonRenderer.RIGHT_BOOT -> this.bootsStack;
                    case CaptainSkeletonRenderer.LEFT_ARMOR_LEG, CaptainSkeletonRenderer.RIGHT_ARMOR_LEG, CaptainSkeletonRenderer.CHEST_LEGGINGS -> this.leggingsStack;
                    case CaptainSkeletonRenderer.CHESTPLATE, CaptainSkeletonRenderer.RIGHT_SLEEVE, CaptainSkeletonRenderer.LEFT_SLEEVE -> this.chestplateStack;
                    case CaptainSkeletonRenderer.HELMET -> this.helmetStack;
                    default -> null;
                };
            }

            @Nonnull
            protected EquipmentSlot getEquipmentSlotForBone(GeoBone bone, ItemStack stack, CaptainSkeletonEntity animatable) {
                return switch (bone.getName()) {
                    case CaptainSkeletonRenderer.LEFT_BOOT, CaptainSkeletonRenderer.RIGHT_BOOT -> EquipmentSlot.FEET;
                    case CaptainSkeletonRenderer.LEFT_ARMOR_LEG, CaptainSkeletonRenderer.RIGHT_ARMOR_LEG, CaptainSkeletonRenderer.CHEST_LEGGINGS -> EquipmentSlot.LEGS;
                    case CaptainSkeletonRenderer.RIGHT_SLEEVE -> {
                        if (!animatable.m_21526_()) {
                            yield EquipmentSlot.MAINHAND;
                        }
                        yield EquipmentSlot.OFFHAND;
                    }
                    case CaptainSkeletonRenderer.LEFT_SLEEVE -> {
                        if (animatable.m_21526_()) {
                            yield EquipmentSlot.OFFHAND;
                        }
                        yield EquipmentSlot.MAINHAND;
                    }
                    case CaptainSkeletonRenderer.CHESTPLATE -> EquipmentSlot.CHEST;
                    case CaptainSkeletonRenderer.HELMET -> EquipmentSlot.HEAD;
                    default -> super.getEquipmentSlotForBone(bone, stack, (LivingEntity)animatable);
                };
            }

            @Nonnull
            protected ModelPart getModelPartForBone(GeoBone bone, EquipmentSlot slot, ItemStack stack, CaptainSkeletonEntity animatable, HumanoidModel<?> baseModel) {
                return switch (bone.getName()) {
                    case CaptainSkeletonRenderer.LEFT_BOOT, CaptainSkeletonRenderer.LEFT_ARMOR_LEG -> baseModel.f_102814_;
                    case CaptainSkeletonRenderer.RIGHT_BOOT, CaptainSkeletonRenderer.RIGHT_ARMOR_LEG -> baseModel.f_102813_;
                    case CaptainSkeletonRenderer.RIGHT_SLEEVE -> baseModel.f_102811_;
                    case CaptainSkeletonRenderer.LEFT_SLEEVE -> baseModel.f_102812_;
                    case CaptainSkeletonRenderer.CHESTPLATE, CaptainSkeletonRenderer.CHEST_LEGGINGS -> baseModel.f_102810_;
                    case CaptainSkeletonRenderer.HELMET -> baseModel.f_102808_;
                    default -> super.getModelPartForBone(bone, slot, stack, (LivingEntity)animatable, baseModel);
                };
            }
        });
        this.addRenderLayer((GeoRenderLayer)new BlockAndItemGeoLayer<CaptainSkeletonEntity>((GeoRenderer)this){

            @Nullable
            protected ItemStack getStackForBone(GeoBone bone, CaptainSkeletonEntity animatable) {
                return switch (bone.getName()) {
                    case CaptainSkeletonRenderer.LEFT_HAND -> {
                        if (animatable.m_21526_()) {
                            yield CaptainSkeletonRenderer.this.mainHandItem;
                        }
                        yield CaptainSkeletonRenderer.this.offhandItem;
                    }
                    case CaptainSkeletonRenderer.RIGHT_HAND -> {
                        if (animatable.m_21526_()) {
                            yield CaptainSkeletonRenderer.this.offhandItem;
                        }
                        yield CaptainSkeletonRenderer.this.mainHandItem;
                    }
                    default -> null;
                };
            }

            protected ItemDisplayContext getTransformTypeForStack(GeoBone bone, ItemStack stack, CaptainSkeletonEntity animatable) {
                return switch (bone.getName()) {
                    case CaptainSkeletonRenderer.LEFT_HAND, CaptainSkeletonRenderer.RIGHT_HAND -> ItemDisplayContext.THIRD_PERSON_RIGHT_HAND;
                    default -> ItemDisplayContext.NONE;
                };
            }

            protected void renderStackForBone(PoseStack poseStack, GeoBone bone, ItemStack stack, CaptainSkeletonEntity animatable, MultiBufferSource bufferSource, float partialTick, int packedLight, int packedOverlay) {
                if (stack == CaptainSkeletonRenderer.this.mainHandItem) {
                    poseStack.m_252781_(Axis.f_252529_.m_252977_(-90.0f));
                    if (stack.m_41720_() instanceof ShieldItem) {
                        poseStack.m_85837_(0.0, 0.125, -0.25);
                    }
                } else if (stack == CaptainSkeletonRenderer.this.offhandItem) {
                    poseStack.m_252781_(Axis.f_252529_.m_252977_(-90.0f));
                    if (stack.m_41720_() instanceof ShieldItem) {
                        poseStack.m_85837_(0.0, 0.125, 0.25);
                        poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
                    }
                }
                super.renderStackForBone(poseStack, bone, stack, (GeoAnimatable)animatable, bufferSource, partialTick, packedLight, packedOverlay);
            }
        });
    }

    public ResourceLocation getTextureLocation(CaptainSkeletonEntity instance) {
        return LOCATION_BY_VARIANT.get((Object)instance.getCaptainVariant());
    }

    public void preRender(PoseStack poseStack, CaptainSkeletonEntity animatable, BakedGeoModel model, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        super.preRender(poseStack, (Entity)animatable, model, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
        this.mainHandItem = animatable.m_21205_();
        this.offhandItem = animatable.m_21206_();
    }

    public void render(CaptainSkeletonEntity pEntity, float pEntityYaw, float pPartialTicks, PoseStack pMatrixStack, MultiBufferSource pBuffer, int pPackedLight) {
        super.m_7392_((Entity)pEntity, pEntityYaw, pPartialTicks, pMatrixStack, pBuffer, pPackedLight);
    }
}

