/*
 * Decompiled with CFR 0.152.
 */
package net.mrwilfis.treasures_of_the_dead.entity.client;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.mrwilfis.treasures_of_the_dead.entity.client.TOTDSkeletonModel;
import net.mrwilfis.treasures_of_the_dead.entity.custom.TOTDSkeletonEntity;
import net.mrwilfis.treasures_of_the_dead.entity.variant.TOTDSkeletonVariant;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;
import software.bernie.geckolib.renderer.GeoRenderer;
import software.bernie.geckolib.renderer.layer.BlockAndItemGeoLayer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;
import software.bernie.geckolib.renderer.layer.ItemArmorGeoLayer;

public class TOTDSkeletonRenderer
extends GeoEntityRenderer<TOTDSkeletonEntity> {
    private static final String LEFT_HAND = "left_hand";
    private static final String RIGHT_HAND = "right_hand";
    private static final String LEFT_BOOT = "left_boot";
    private static final String RIGHT_BOOT = "right_boot";
    private static final String LEFT_ARMOR_LEG = "left_armor_leg";
    private static final String RIGHT_ARMOR_LEG = "right_armor_leg";
    private static final String CHESTPLATE = "chestplate";
    private static final String CHEST_LEGGINGS = "chest_leggings";
    private static final String HELMET = "helmet";
    private static final String RIGHT_SLEEVE = "right_sleeve";
    private static final String LEFT_SLEEVE = "left_sleeve";
    protected ItemStack mainHandItem;
    protected ItemStack offhandItem;
    public static final Map<TOTDSkeletonVariant, ResourceLocation> LOCATION_BY_VARIANT = (Map)Util.m_137469_((Object)Maps.newEnumMap(TOTDSkeletonVariant.class), p_114874_ -> {
        p_114874_.put(TOTDSkeletonVariant.DEFAULT, new ResourceLocation("treasures_of_the_dead", "textures/entity/pirate_skeleton1.png"));
        p_114874_.put(TOTDSkeletonVariant.VAR1, new ResourceLocation("treasures_of_the_dead", "textures/entity/pirate_skeleton2.png"));
        p_114874_.put(TOTDSkeletonVariant.VAR2, new ResourceLocation("treasures_of_the_dead", "textures/entity/pirate_skeleton3.png"));
        p_114874_.put(TOTDSkeletonVariant.VAR3, new ResourceLocation("treasures_of_the_dead", "textures/entity/pirate_skeleton4.png"));
        p_114874_.put(TOTDSkeletonVariant.VAR4, new ResourceLocation("treasures_of_the_dead", "textures/entity/pirate_skeleton5.png"));
        p_114874_.put(TOTDSkeletonVariant.VAR5, new ResourceLocation("treasures_of_the_dead", "textures/entity/pirate_skeleton6.png"));
    });

    public TOTDSkeletonRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager, (GeoModel)new TOTDSkeletonModel());
        this.f_114477_ = 0.5f;
        this.addRenderLayer((GeoRenderLayer)new ItemArmorGeoLayer<TOTDSkeletonEntity>((GeoRenderer)this){

            @Nullable
            protected ItemStack getArmorItemForBone(GeoBone bone, TOTDSkeletonEntity animatable) {
                return switch (bone.getName()) {
                    case TOTDSkeletonRenderer.LEFT_BOOT, TOTDSkeletonRenderer.RIGHT_BOOT -> this.bootsStack;
                    case TOTDSkeletonRenderer.LEFT_ARMOR_LEG, TOTDSkeletonRenderer.RIGHT_ARMOR_LEG, TOTDSkeletonRenderer.CHEST_LEGGINGS -> this.leggingsStack;
                    case TOTDSkeletonRenderer.CHESTPLATE, TOTDSkeletonRenderer.RIGHT_SLEEVE, TOTDSkeletonRenderer.LEFT_SLEEVE -> this.chestplateStack;
                    case TOTDSkeletonRenderer.HELMET -> this.helmetStack;
                    default -> null;
                };
            }

            @Nonnull
            protected EquipmentSlot getEquipmentSlotForBone(GeoBone bone, ItemStack stack, TOTDSkeletonEntity animatable) {
                return switch (bone.getName()) {
                    case TOTDSkeletonRenderer.LEFT_BOOT, TOTDSkeletonRenderer.RIGHT_BOOT -> EquipmentSlot.FEET;
                    case TOTDSkeletonRenderer.LEFT_ARMOR_LEG, TOTDSkeletonRenderer.RIGHT_ARMOR_LEG, TOTDSkeletonRenderer.CHEST_LEGGINGS -> EquipmentSlot.LEGS;
                    case TOTDSkeletonRenderer.RIGHT_SLEEVE -> {
                        if (!animatable.m_21526_()) {
                            yield EquipmentSlot.MAINHAND;
                        }
                        yield EquipmentSlot.OFFHAND;
                    }
                    case TOTDSkeletonRenderer.LEFT_SLEEVE -> {
                        if (animatable.m_21526_()) {
                            yield EquipmentSlot.OFFHAND;
                        }
                        yield EquipmentSlot.MAINHAND;
                    }
                    case TOTDSkeletonRenderer.CHESTPLATE -> EquipmentSlot.CHEST;
                    case TOTDSkeletonRenderer.HELMET -> EquipmentSlot.HEAD;
                    default -> super.getEquipmentSlotForBone(bone, stack, (LivingEntity)animatable);
                };
            }

            @Nonnull
            protected ModelPart getModelPartForBone(GeoBone bone, EquipmentSlot slot, ItemStack stack, TOTDSkeletonEntity animatable, HumanoidModel<?> baseModel) {
                return switch (bone.getName()) {
                    case TOTDSkeletonRenderer.LEFT_BOOT, TOTDSkeletonRenderer.LEFT_ARMOR_LEG -> baseModel.f_102814_;
                    case TOTDSkeletonRenderer.RIGHT_BOOT, TOTDSkeletonRenderer.RIGHT_ARMOR_LEG -> baseModel.f_102813_;
                    case TOTDSkeletonRenderer.RIGHT_SLEEVE -> baseModel.f_102811_;
                    case TOTDSkeletonRenderer.LEFT_SLEEVE -> baseModel.f_102812_;
                    case TOTDSkeletonRenderer.CHESTPLATE, TOTDSkeletonRenderer.CHEST_LEGGINGS -> baseModel.f_102810_;
                    case TOTDSkeletonRenderer.HELMET -> baseModel.f_102808_;
                    default -> super.getModelPartForBone(bone, slot, stack, (LivingEntity)animatable, baseModel);
                };
            }
        });
        this.addRenderLayer((GeoRenderLayer)new BlockAndItemGeoLayer<TOTDSkeletonEntity>((GeoRenderer)this){

            @Nullable
            protected ItemStack getStackForBone(GeoBone bone, TOTDSkeletonEntity animatable) {
                return switch (bone.getName()) {
                    case TOTDSkeletonRenderer.LEFT_HAND -> {
                        if (animatable.m_21526_()) {
                            yield TOTDSkeletonRenderer.this.mainHandItem;
                        }
                        yield TOTDSkeletonRenderer.this.offhandItem;
                    }
                    case TOTDSkeletonRenderer.RIGHT_HAND -> {
                        if (animatable.m_21526_()) {
                            yield TOTDSkeletonRenderer.this.offhandItem;
                        }
                        yield TOTDSkeletonRenderer.this.mainHandItem;
                    }
                    default -> null;
                };
            }

            protected ItemDisplayContext getTransformTypeForStack(GeoBone bone, ItemStack stack, TOTDSkeletonEntity animatable) {
                return switch (bone.getName()) {
                    case TOTDSkeletonRenderer.LEFT_HAND, TOTDSkeletonRenderer.RIGHT_HAND -> ItemDisplayContext.THIRD_PERSON_RIGHT_HAND;
                    default -> ItemDisplayContext.NONE;
                };
            }

            protected void renderStackForBone(PoseStack poseStack, GeoBone bone, ItemStack stack, TOTDSkeletonEntity animatable, MultiBufferSource bufferSource, float partialTick, int packedLight, int packedOverlay) {
                if (stack == TOTDSkeletonRenderer.this.mainHandItem) {
                    poseStack.m_252781_(Axis.f_252529_.m_252977_(-90.0f));
                    if (stack.m_41720_() instanceof ShieldItem) {
                        poseStack.m_85837_(0.0, 0.125, -0.25);
                    }
                } else if (stack == TOTDSkeletonRenderer.this.offhandItem) {
                    poseStack.m_252781_(Axis.f_252529_.m_252977_(-90.0f));
                    if (stack.m_41720_() instanceof ShieldItem) {
                        poseStack.m_85837_(0.0, 0.125, 0.25);
                        poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
                    }
                }
                super.renderStackForBone(poseStack, bone, stack, (GeoAnimatable)animatable, bufferSource, partialTick, packedLight, packedOverlay);
            }
        });
    }

    public ResourceLocation getTextureLocation(TOTDSkeletonEntity instance) {
        return LOCATION_BY_VARIANT.get((Object)instance.getVariant());
    }

    public void preRender(PoseStack poseStack, TOTDSkeletonEntity animatable, BakedGeoModel model, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        super.preRender(poseStack, (Entity)animatable, model, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
        this.mainHandItem = animatable.m_21205_();
        this.offhandItem = animatable.m_21206_();
    }

    public void render(TOTDSkeletonEntity pEntity, float pEntityYaw, float pPartialTicks, PoseStack pMatrixStack, MultiBufferSource pBuffer, int pPackedLight) {
        super.m_7392_((Entity)pEntity, pEntityYaw, pPartialTicks, pMatrixStack, pBuffer, pPackedLight);
    }
}

