/*
 * Decompiled with CFR 0.152.
 */
package net.mrwilfis.treasures_of_the_dead.entity.custom;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.mrwilfis.treasures_of_the_dead.entity.custom.AnyTreasureClass;
import net.mrwilfis.treasures_of_the_dead.entity.custom.BlunderBombEntity;
import org.jetbrains.annotations.NotNull;

public class AbstractPowderKegEntity
extends AnyTreasureClass {
    private static final EntityDataAccessor<Boolean> IS_GOING_TO_BLOW_UP = SynchedEntityData.m_135353_(AbstractPowderKegEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> PREPARE_TO_BLOW_UP = SynchedEntityData.m_135353_(AbstractPowderKegEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public int maxPrepareToBlowUp;
    public float explodeRadius;

    public AbstractPowderKegEntity(EntityType pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.f_19811_ = true;
        this.maxPrepareToBlowUp = this.getMaxPrepareToBlowUp();
        this.explodeRadius = this.getExplodeRadius();
    }

    public static AttributeSupplier setAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22279_, 0.0).m_22265_();
    }

    @NotNull
    public InteractionResult m_6071_(Player pPlayer, @NotNull InteractionHand pHand) {
        if (!pPlayer.m_6144_()) {
            boolean b = this.getIsGoingToBlowUp();
            if (!b) {
                this.setIsGoingToBlowUp(true);
                return InteractionResult.SUCCESS;
            }
            this.setIsGoingToBlowUp(false);
            return InteractionResult.SUCCESS;
        }
        this.m_146922_(pPlayer.m_146908_() - 180.0f);
        this.m_20049_("TOTD_Rotate");
        return super.m_6071_(pPlayer, pHand);
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            boolean b = this.getIsGoingToBlowUp();
            int i = this.getPrepareToBlowUp();
            if (b) {
                this.setPrepareToBlowUp(i + 1);
            } else if (i != 0) {
                this.setPrepareToBlowUp(0);
            }
            if (i >= this.maxPrepareToBlowUp) {
                this.explodeKeg();
            }
            if (b && i == 0) {
                this.m_5496_(SoundEvents.f_12512_, 1.0f, 0.5f);
            }
        }
        if (this.getIsGoingToBlowUp()) {
            this.createFuseParticles(this.m_9236_(), this.f_19796_, this.m_20182_());
        }
    }

    protected void explodeKeg() {
        if (!this.m_9236_().f_46443_) {
            this.f_20890_ = true;
            this.m_9236_().m_254849_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.explodeRadius, Level.ExplosionInteraction.MOB);
            this.m_146870_();
        }
    }

    protected void createFuseParticles(Level level, RandomSource random, Vec3 position) {
        double xOffset = this.f_19796_.m_188500_() * 0.2 - 0.1;
        double yOffset = this.f_19796_.m_188500_() * 0.2 - 0.1;
        double zOffset = this.f_19796_.m_188500_() * 0.2 - 0.1;
        double xSpeed = this.f_19796_.m_188500_() * 0.04 - 0.02;
        double ySpeed = this.f_19796_.m_188500_() * 0.05 + 0.03;
        double zSpeed = this.f_19796_.m_188500_() * 0.04 - 0.02;
        try {
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, position.f_82479_ + xOffset, position.f_82480_ + yOffset + 0.665, position.f_82481_ + zOffset, xSpeed, ySpeed, zSpeed);
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
    }

    @Override
    public boolean m_6673_(DamageSource pSource) {
        return pSource.m_276093_(DamageTypes.f_268612_) || pSource.m_276093_(DamageTypes.f_268659_) || pSource.m_276093_(DamageTypes.f_268585_) || pSource.m_276093_(DamageTypes.f_268482_) || pSource.m_276093_(DamageTypes.f_268444_) || pSource.m_276093_(DamageTypes.f_268530_) || pSource.m_276093_(DamageTypes.f_268565_) || pSource.m_276093_(DamageTypes.f_268448_) || pSource.m_276093_(DamageTypes.f_268468_) || pSource.m_276093_(DamageTypes.f_268434_) || pSource.m_276093_(DamageTypes.f_268546_);
    }

    @Override
    public boolean m_6469_(@NotNull DamageSource pSource, float pAmount) {
        boolean fastExplosion = pSource.m_276093_(DamageTypes.f_268526_) || pSource.m_276093_(DamageTypes.f_268513_) || pSource.m_276093_(DamageTypes.f_268428_) || pSource.m_276093_(DamageTypes.f_268450_) || pSource.m_276093_(DamageTypes.f_268739_) || pSource.m_276093_(DamageTypes.f_268684_) || pSource.m_276093_(DamageTypes.f_268556_) || pSource.m_276093_(DamageTypes.f_268714_) || pSource.m_276093_(DamageTypes.f_268534_) || pSource.m_276093_(DamageTypes.f_268679_);
        boolean slowExplosion = pSource.m_276093_(DamageTypes.f_268546_) || pSource.m_276093_(DamageTypes.f_268434_) || pSource.m_276093_(DamageTypes.f_268468_);
        boolean isSourceExplosion = pSource.m_276093_(DamageTypes.f_268448_) || pSource.m_276093_(DamageTypes.f_268565_);
        boolean isBlunderBomb = pSource.m_7640_() instanceof BlunderBombEntity;
        if (fastExplosion) {
            this.explodeKeg();
        } else if (isSourceExplosion && !isBlunderBomb) {
            if (pAmount > 30.0f) {
                this.setPrepareToBlowUp(this.getMaxPrepareToBlowUp() - 1);
            } else if (pAmount > 16.0f) {
                this.setPrepareToBlowUp(this.getMaxPrepareToBlowUp() - 20);
            }
            this.setIsGoingToBlowUp(true);
        } else if (isSourceExplosion && isBlunderBomb) {
            if (pAmount > 9.0f) {
                this.setPrepareToBlowUp(this.getMaxPrepareToBlowUp() - 1);
            } else if (pAmount > 5.0f) {
                this.setPrepareToBlowUp(this.getMaxPrepareToBlowUp() - 20);
            }
            this.setIsGoingToBlowUp(true);
        } else if (slowExplosion) {
            this.setIsGoingToBlowUp(true);
        } else if (!this.m_6673_(pSource)) {
            this.turnIntoItem();
        }
        return super.m_6469_(pSource, pAmount);
    }

    public int getMaxPrepareToBlowUp() {
        return 90;
    }

    public float getExplodeRadius() {
        return 3.0f;
    }

    public boolean getIsGoingToBlowUp() {
        return (Boolean)this.m_20088_().m_135370_(IS_GOING_TO_BLOW_UP);
    }

    public void setIsGoingToBlowUp(boolean b) {
        this.m_20088_().m_135381_(IS_GOING_TO_BLOW_UP, (Object)b);
    }

    public int getPrepareToBlowUp() {
        return (Integer)this.m_20088_().m_135370_(PREPARE_TO_BLOW_UP);
    }

    public void setPrepareToBlowUp(int i) {
        this.m_20088_().m_135381_(PREPARE_TO_BLOW_UP, (Object)i);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setPrepareToBlowUp(tag.m_128451_("PrepareToBlowUp"));
        this.setIsGoingToBlowUp(tag.m_128471_("IsGoingToBlowUp"));
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("PrepareToBlowUp", this.getPrepareToBlowUp());
        tag.m_128379_("IsGoingToBlowUp", this.getIsGoingToBlowUp());
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(PREPARE_TO_BLOW_UP, (Object)0);
        this.m_20088_().m_135372_(IS_GOING_TO_BLOW_UP, (Object)false);
    }
}

