/*
 * Decompiled with CFR 0.152.
 */
package net.mrwilfis.treasures_of_the_dead.entity.custom;

import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.TntBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.mrwilfis.treasures_of_the_dead.entity.ModEntities;
import net.mrwilfis.treasures_of_the_dead.particle.ModParticles;
import net.mrwilfis.treasures_of_the_dead.sound.ModSounds;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class BlunderBombEntity
extends ThrowableProjectile
implements GeoAnimatable {
    private final AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    protected static final RawAnimation FLY = RawAnimation.begin().then("animation.blunder_bomb.fly", Animation.LoopType.LOOP);
    private final float MAX_DAMAGE = 15.0f;
    private final float MIN_DISTANCE = 5.0f;
    private final float ON_HIT_ENTITY_DAMAGE = 4.0f;

    public BlunderBombEntity(EntityType<? extends ThrowableProjectile> entityType, Level level) {
        super(entityType, level);
    }

    public BlunderBombEntity(EntityType<? extends ThrowableProjectile> entityType, LivingEntity shooter, Level level) {
        super(entityType, shooter, level);
    }

    public BlunderBombEntity(Level level, double x, double y, double z) {
        super(ModEntities.BLUNDER_BOMB.get(), x, y, z, level);
    }

    public void m_8119_() {
        if (!this.m_9236_().f_46443_ && this.f_19803_) {
            this.m_5496_(SoundEvents.f_12553_, 0.4f, 0.8f);
        }
        super.m_8119_();
    }

    protected void m_6532_(HitResult result) {
        super.m_6532_(result);
        Random rand = new Random();
        if (!this.m_9236_().f_46443_) {
            this.explodeBomb();
            this.m_9236_().m_7605_((Entity)this, (byte)42);
            this.m_9236_().m_245803_((Entity)this, this.m_20097_(), ModSounds.BLUNDER_BOMB_EXPLODE.get(), SoundSource.AMBIENT, 2.0f, rand.nextFloat(0.8f, 1.2f));
            this.m_146870_();
        }
    }

    protected void m_5790_(EntityHitResult result) {
        super.m_5790_(result);
        if (!this.m_9236_().f_46443_) {
            Entity entity = result.m_82443_();
            entity.m_6469_(entity.m_269291_().m_269036_((Entity)this, this.m_19749_()), 4.0f);
        }
    }

    protected void m_8060_(BlockHitResult result) {
        super.m_8060_(result);
        Entity entity = this.m_19749_();
        Level level = this.m_9236_();
        BlockPos blockPos = result.m_82425_();
        BlockState state = level.m_8055_(blockPos);
        Block block = state.m_60734_();
        boolean isTNT = block instanceof TntBlock;
        if (isTNT) {
            ((TntBlock)block).onCaughtFire(state, level, blockPos, (Direction)null, entity instanceof LivingEntity ? (LivingEntity)entity : null);
            level.m_7471_(blockPos, false);
        }
    }

    public void m_7822_(byte id) {
        super.m_7822_(id);
        this.createParticles(this.m_9236_(), this.f_19796_, this.m_20182_());
    }

    private void explodeBomb() {
        AABB aabb = this.m_20191_().m_82377_(5.0, 2.5, 5.0);
        List list = this.m_9236_().m_45976_(LivingEntity.class, aabb);
        if (!list.isEmpty()) {
            for (LivingEntity entity : list) {
                float distance = this.m_20270_((Entity)entity);
                float damage = this.calculateDamage(distance);
                if (entity.m_5833_() || !entity.m_6469_(entity.m_269291_().m_269036_((Entity)this, this.m_19749_()), damage)) continue;
                Vec3 explosionCenter = this.m_20182_();
                Vec3 entityPos = entity.m_20182_();
                Vec3 direction = entityPos.m_82546_(explosionCenter).m_82541_();
                double knockbackStrength = (1.0 - (double)(distance / 5.0f)) * 0.75 + 0.2;
                entity.m_147240_(knockbackStrength, -direction.f_82479_, -direction.f_82481_);
                if (!(entity instanceof ServerPlayer)) continue;
                ((ServerPlayer)entity).f_19864_ = true;
            }
        }
    }

    private void createParticles(Level level, RandomSource random, Vec3 position) {
        int i;
        for (i = 0; i < 100; ++i) {
            double xDir = random.m_188500_() * 1.0 - 0.5;
            double yDir = random.m_188500_() * 1.0 - 0.5;
            double zDir = random.m_188500_() * 1.0 - 0.5;
            double length = Math.sqrt(xDir * xDir + yDir * yDir + zDir * zDir);
            double speed = 2.0;
            double xSpeed = (xDir /= length) * speed;
            double ySpeed = (yDir /= length) * speed;
            double zSpeed = (zDir /= length) * speed;
            level.m_7106_((ParticleOptions)ModParticles.BLUNDER_BOMB_EXPLOSION_PARTICLES.get(), position.f_82479_, position.f_82480_, position.f_82481_, xSpeed, ySpeed, zSpeed);
        }
        for (i = 0; i < 4; ++i) {
            double xOffset = random.m_188500_() * 0.5 - 0.25;
            double yOffset = random.m_188500_() * 0.5 - 0.25;
            double zOffset = random.m_188500_() * 0.5 - 0.25;
            double xSpeed = random.m_188500_() * 0.8 - 0.4;
            double ySpeed = random.m_188500_() * 0.8 - 0.4;
            double zSpeed = random.m_188500_() * 0.8 - 0.4;
            level.m_7106_((ParticleOptions)ParticleTypes.f_123813_, position.f_82479_ + xOffset, position.f_82480_ + yOffset, position.f_82481_ + zOffset, xSpeed, ySpeed, zSpeed);
        }
    }

    private float calculateDamage(float distance) {
        float damage = 15.0f * (1.0f - distance / 5.0f);
        return Math.max(damage, 0.0f);
    }

    protected float m_7139_() {
        return 0.055f;
    }

    protected void m_8097_() {
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller1", 3, this::flying)});
    }

    private PlayState flying(AnimationState<BlunderBombEntity> state) {
        state.getController().setAnimation(FLY);
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public double getTick(Object object) {
        return ((Entity)object).f_19797_;
    }
}

