/*
 * Decompiled with CFR 0.152.
 */
package net.mrwilfis.treasures_of_the_dead.entity.custom.chestVariants;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.mrwilfis.treasures_of_the_dead.common.ModLootTables;
import net.mrwilfis.treasures_of_the_dead.entity.custom.AbstractChestEntity;
import net.mrwilfis.treasures_of_the_dead.item.ModItems;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class TreasureChestEntity
extends AbstractChestEntity
implements GeoAnimatable,
GeoEntity {
    private static final EntityDataAccessor<Boolean> IS_OPEN = SynchedEntityData.m_135353_(TreasureChestEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IS_ROBBED = SynchedEntityData.m_135353_(TreasureChestEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private final AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    private static final RawAnimation IDLE = RawAnimation.begin().then("animation.model.idle", Animation.LoopType.LOOP);
    private static final RawAnimation IDLE_OPENED = RawAnimation.begin().then("animation.model.idle_opened", Animation.LoopType.LOOP);
    private static final RawAnimation OPENING = RawAnimation.begin().then("animation.model.opening", Animation.LoopType.HOLD_ON_LAST_FRAME);

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate)});
    }

    private <E extends GeoAnimatable> PlayState predicate(AnimationState<E> state) {
        if (!this.getIsOpen()) {
            state.getController().setAnimation(IDLE);
        } else {
            state.getController().setAnimationSpeed(1.3);
            state.getController().setAnimation(OPENING);
        }
        return PlayState.CONTINUE;
    }

    public double getTick(Object o) {
        return ((Entity)o).f_19797_;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public TreasureChestEntity(EntityType pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @NotNull
    public InteractionResult m_6071_(Player pPlayer, @NotNull InteractionHand pHand) {
        ItemStack key = pPlayer.m_21120_(pHand);
        if (pPlayer.m_6144_()) {
            this.m_146922_(pPlayer.m_146908_() - 180.0f);
            this.m_20049_("TOTD_Rotate");
        } else {
            if (!this.getIsRobbed() && key.m_41720_().equals(ModItems.TREASURE_KEY.get())) {
                this.setIsRobbed(true);
                this.setIsOpen(true);
                this.ejectItems(pPlayer.m_9236_());
                if (!pPlayer.m_7500_()) {
                    key.m_41774_(1);
                }
                this.m_5496_(SoundEvents.f_11873_, 0.85f, 0.5f);
                return InteractionResult.SUCCESS;
            }
            if (this.getIsRobbed() && this.getIsOpen()) {
                this.setIsOpen(false);
                this.m_5496_(SoundEvents.f_11872_, 0.85f, 0.5f);
                return InteractionResult.SUCCESS;
            }
            if (this.getIsRobbed() && !this.getIsOpen()) {
                this.setIsOpen(true);
                this.CreateUnderwaterParticlesOnOpening(pPlayer.m_9236_(), (int)this.m_20185_(), (int)this.m_20186_(), (int)this.m_20189_());
                this.m_5496_(SoundEvents.f_11873_, 0.85f, 0.5f);
                return InteractionResult.SUCCESS;
            }
        }
        return super.m_6071_(pPlayer, pHand);
    }

    private void ejectItems(Level level) {
        double x = this.m_20185_();
        double y = this.m_20186_();
        double z = this.m_20189_();
        if (!this.m_9236_().f_46443_) {
            LootTable loottable = level.m_7654_().m_278653_().m_278676_(ModLootTables.DEFAULT_TREASURE_CHEST_LOOT);
            LootParams lootParams = new LootParams.Builder(level.m_7654_().m_129783_()).m_287286_(LootContextParams.f_81460_, (Object)Vec3.f_82478_).m_287286_(LootContextParams.f_81455_, (Object)this).m_287235_(LootContextParamSets.f_81416_);
            ObjectArrayList list = loottable.m_287195_(lootParams);
            for (ItemStack itemstack : list) {
                ItemEntity itementity = new ItemEntity(level, x, y, z, itemstack);
                itementity.m_32060_();
                level.m_7967_((Entity)itementity);
            }
        }
    }

    private void CreateUnderwaterParticlesOnOpening(Level level, int x, int y, int z) {
        boolean isInWater;
        BlockPos pos1 = new BlockPos(x, y, z);
        boolean bl = isInWater = level.m_8055_(pos1).m_60734_() == Blocks.f_49990_;
        if (isInWater) {
            Vec3 position = this.m_20182_();
            for (int i = 0; i < 25; ++i) {
                double xOffset = this.f_19796_.m_188500_() * 0.5 - 0.25;
                double yOffset = this.f_19796_.m_188500_() * 0.5 - 0.25;
                double zOffset = this.f_19796_.m_188500_() * 0.5 - 0.25;
                double xSpeed = this.f_19796_.m_188500_() * 0.5 - 0.25;
                double ySpeed = this.f_19796_.m_188500_() * 0.5;
                double zSpeed = this.f_19796_.m_188500_() * 0.5 - 0.25;
                level.m_7106_((ParticleOptions)ParticleTypes.f_123774_, position.f_82479_ + xOffset, position.f_82480_ + yOffset + 0.5, position.f_82481_ + zOffset, xSpeed, ySpeed + 0.1, zSpeed);
            }
        }
    }

    @Override
    public ItemStack getTreasureItem() {
        ItemStack stack = new ItemStack((ItemLike)ModItems.TREASURE_CHEST_ITEM.get());
        stack.m_41751_(new CompoundTag());
        stack.m_41783_().m_128379_("IsOpen", this.getIsOpen());
        stack.m_41783_().m_128379_("IsRobbed", this.getIsRobbed());
        return stack;
    }

    public boolean getIsOpen() {
        return (Boolean)this.m_20088_().m_135370_(IS_OPEN);
    }

    public void setIsOpen(boolean var) {
        this.m_20088_().m_135381_(IS_OPEN, (Object)var);
    }

    public boolean getIsRobbed() {
        return (Boolean)this.m_20088_().m_135370_(IS_ROBBED);
    }

    public void setIsRobbed(boolean var) {
        this.m_20088_().m_135381_(IS_ROBBED, (Object)var);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(IS_OPEN, (Object)Boolean.FALSE);
        this.m_20088_().m_135372_(IS_ROBBED, (Object)Boolean.FALSE);
    }

    public void m_7378_(CompoundTag pCompound) {
        this.setIsOpen(pCompound.m_128471_("IsOpen"));
        this.setIsRobbed(pCompound.m_128471_("IsRobbed"));
        super.m_7378_(pCompound);
    }

    public void m_7380_(CompoundTag pCompound) {
        pCompound.m_128379_("IsOpen", this.getIsOpen());
        pCompound.m_128379_("IsRobbed", this.getIsRobbed());
        super.m_7380_(pCompound);
    }
}

