/*
 * Decompiled with CFR 0.152.
 */
package net.mrwilfis.treasures_of_the_dead.item.custom;

import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.Vanishable;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.mrwilfis.treasures_of_the_dead.item.ModItems;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class ModGunItem
extends ProjectileWeaponItem
implements Vanishable {
    private final int bulletCount;
    private final int reloadDuration;

    public ModGunItem(Item.Properties pProperties, int bulletCount, int reloadDuration) {
        super(pProperties);
        this.bulletCount = bulletCount;
        this.reloadDuration = reloadDuration;
    }

    public Predicate<ItemStack> m_6437_() {
        return f_43005_;
    }

    public int m_6615_() {
        return 25;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (ModGunItem.isCharged(itemstack)) {
            this.performShooting(level, (LivingEntity)player, hand, itemstack, 3.15f, 1.0f);
            ModGunItem.setCharged(itemstack, false);
            return InteractionResultHolder.m_19096_((Object)itemstack);
        }
        if (!ModGunItem.isCharged(itemstack)) {
            if (ModGunItem.findAmmo(player) == ItemStack.f_41583_ && !player.m_150110_().f_35937_) {
                return InteractionResultHolder.m_19100_((Object)itemstack);
            }
            ModGunItem.setCharged(itemstack, false);
            player.m_6672_(hand);
            return InteractionResultHolder.m_19096_((Object)itemstack);
        }
        return InteractionResultHolder.m_19100_((Object)itemstack);
    }

    public void m_5551_(ItemStack stack, Level level, LivingEntity livingEntity, int timeCharged) {
        System.out.println("release using, timeCharged - " + timeCharged);
    }

    public boolean m_41463_(ItemStack pStack) {
        System.out.println("use on release");
        return pStack.m_150930_((Item)this);
    }

    public void m_5929_(Level level, LivingEntity user, ItemStack stack, int remainingUseDuration) {
        int usingTicks = this.m_8105_(stack) - remainingUseDuration;
        SoundEvent sound = SoundEvents.f_11871_;
        System.out.println("on use tick " + remainingUseDuration + " " + usingTicks);
        if (usingTicks < this.m_8105_(stack) - 1) {
            ModGunItem.setCharged(stack, false);
        }
        if (usingTicks >= this.m_8105_(stack) - 1 && !ModGunItem.isCharged(stack)) {
            if (!ModGunItem.isCharged(stack) && user instanceof Player) {
                Player player = (Player)user;
                this.consumeAmmo(player, stack);
            }
            ModGunItem.setCharged(stack, true);
            level.m_6263_((Player)null, user.m_20185_(), user.m_20186_(), user.m_20189_(), sound, SoundSource.PLAYERS, 0.5f, 1.0f);
        }
    }

    public static boolean isCharged(ItemStack gunItem) {
        CompoundTag compoundtag = gunItem.m_41783_();
        return compoundtag != null && compoundtag.m_128471_("Charged");
    }

    public static void setCharged(ItemStack gunItem, boolean pIsCharged) {
        CompoundTag compoundtag = gunItem.m_41784_();
        compoundtag.m_128379_("Charged", pIsCharged);
    }

    public void consumeAmmo(Player player, ItemStack itemStack) {
        if (player.m_150110_().f_35937_) {
            return;
        }
        ItemStack ammoStack = ModGunItem.findAmmo(player);
        ammoStack.m_41774_(1);
        if (ammoStack.m_41619_()) {
            player.m_150109_().m_36057_(ammoStack);
        }
    }

    public static ItemStack findAmmo(Player player) {
        ItemStack stack = player.m_6844_(EquipmentSlot.OFFHAND);
        if (ModGunItem.isAmmo(stack)) {
            return stack;
        }
        stack = player.m_6844_(EquipmentSlot.MAINHAND);
        if (ModGunItem.isAmmo(stack)) {
            return stack;
        }
        int size = player.m_150109_().m_6643_();
        for (int i = 0; i < size; ++i) {
            stack = player.m_150109_().m_8020_(i);
            if (!ModGunItem.isAmmo(stack)) continue;
            return stack;
        }
        return ItemStack.f_41583_;
    }

    public static boolean isAmmo(ItemStack stack) {
        return stack.m_41720_() == ModItems.CARTRIDGE.get();
    }

    public void performShooting(Level level, LivingEntity shooter, InteractionHand hand, ItemStack gunStack, float velocity, float inaccuracy) {
        for (int i = 0; i < this.bulletCount; ++i) {
            boolean flag = shooter instanceof Player && ((Player)shooter).m_150110_().f_35937_;
            ItemStack arrow = new ItemStack((ItemLike)Items.f_42412_);
            if (i == 0) {
                ModGunItem.shootProjectile(level, shooter, hand, gunStack, arrow, 1.0f, flag, velocity, inaccuracy, 0.0f);
                continue;
            }
            if (i <= 0) continue;
            Random rand = new Random();
            ModGunItem.shootProjectile(level, shooter, hand, gunStack, arrow, 1.0f, flag, velocity, rand.nextFloat(-20.0f, 20.0f), 0.0f);
        }
    }

    private static void shootProjectile(Level level, LivingEntity shooter, InteractionHand hand, ItemStack gunItem, ItemStack ammostack, float pSoundPitch, boolean isCreativeMode, float velocity, float inaccuracy, float projectileAngle) {
        if (!level.f_46443_) {
            AbstractArrow projectile = ModGunItem.getArrow(level, shooter, gunItem, ammostack);
            if (isCreativeMode || projectileAngle != 0.0f) {
                projectile.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
            }
            Vec3 vec31 = shooter.m_20289_(1.0f);
            Quaternionf quaternionf = new Quaternionf().setAngleAxis((double)(projectileAngle * ((float)Math.PI / 180)), vec31.f_82479_, vec31.f_82480_, vec31.f_82481_);
            Vec3 vec3 = shooter.m_20252_(1.0f);
            Vector3f vector3f = vec3.m_252839_().rotate((Quaternionfc)quaternionf);
            ((Projectile)projectile).m_6686_((double)vector3f.x(), (double)vector3f.y(), (double)vector3f.z(), velocity, inaccuracy);
            gunItem.m_41622_(1, shooter, p_40858_ -> p_40858_.m_21190_(hand));
            level.m_7967_((Entity)projectile);
            level.m_6263_((Player)null, shooter.m_20185_(), shooter.m_20186_(), shooter.m_20189_(), SoundEvents.f_11847_, SoundSource.PLAYERS, 1.0f, pSoundPitch);
        }
    }

    private static AbstractArrow getArrow(Level pLevel, LivingEntity pLivingEntity, ItemStack pCrossbowStack, ItemStack pAmmoStack) {
        ArrowItem arrowitem = (ArrowItem)(pAmmoStack.m_41720_() instanceof ArrowItem ? pAmmoStack.m_41720_() : Items.f_42412_);
        AbstractArrow abstractarrow = arrowitem.m_6394_(pLevel, pAmmoStack, pLivingEntity);
        return abstractarrow;
    }

    public UseAnim m_6164_(ItemStack pStack) {
        return UseAnim.CROSSBOW;
    }

    public int m_8105_(ItemStack pStack) {
        return this.reloadDuration;
    }
}

