/*
 * Decompiled with CFR 0.152.
 */
package net.mrwilfis.treasures_of_the_dead.item.custom.chestVariants;

import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.mrwilfis.treasures_of_the_dead.entity.ModEntities;
import net.mrwilfis.treasures_of_the_dead.entity.custom.chestVariants.TreasureChestEntity;
import net.mrwilfis.treasures_of_the_dead.item.client.TreasureChestItemRenderer;
import net.mrwilfis.treasures_of_the_dead.item.custom.AbstractChestItem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.SingletonGeoAnimatable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class TreasureChestItem
extends AbstractChestItem
implements GeoItem {
    private AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    private static final RawAnimation IDLE = RawAnimation.begin().then("animation.model.idle", Animation.LoopType.LOOP);
    private static final RawAnimation IDLE_OPENED = RawAnimation.begin().then("animation.model.idle_opened", Animation.LoopType.LOOP);
    private static final RawAnimation OPENING = RawAnimation.begin().then("animation.model.opening", Animation.LoopType.HOLD_ON_LAST_FRAME);

    public TreasureChestItem(Item.Properties pProperties) {
        super(pProperties);
        SingletonGeoAnimatable.registerSyncedAnimatable((GeoAnimatable)this);
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext pContext) {
        ItemStack stack = pContext.m_43723_().m_21120_(pContext.m_43724_());
        TreasureChestEntity chest = new TreasureChestEntity((EntityType)ModEntities.TREASURE_CHEST.get(), pContext.m_43725_());
        chest.m_20049_("TOTD_Rotate");
        if (stack.m_41783_() != null) {
            chest.setIsOpen(stack.m_41783_().m_128471_("IsOpen"));
            chest.setIsRobbed(stack.m_41783_().m_128471_("IsRobbed"));
        }
        BlockPos offset = pContext.m_8083_().m_5484_(pContext.m_43719_(), 1);
        chest.m_7678_((double)offset.m_123341_() + 0.5, offset.m_123342_(), (double)offset.m_123343_() + 0.5, 0.0f, 0.0f);
        float yaw = pContext.m_43723_().m_146908_();
        if (pContext.m_43719_() != Direction.UP) {
            yaw = pContext.m_43723_().m_6350_().m_122435_();
        }
        chest.m_146922_(yaw - 180.0f);
        chest.f_20885_ = yaw - 180.0f;
        if (stack.m_41788_()) {
            chest.m_6593_(stack.m_41786_());
        }
        if (!pContext.m_43725_().f_46443_) {
            pContext.m_43725_().m_7967_((Entity)chest);
        }
        if (!pContext.m_43723_().m_7500_()) {
            stack.m_41774_(1);
        }
        return InteractionResult.SUCCESS;
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        if (pStack.m_41783_() != null && pStack.m_41783_().m_128471_("IsRobbed")) {
            pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.treasures_of_the_dead.chest_is_robbed.tooltip"));
        }
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            private TreasureChestItemRenderer renderer;

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                if (this.renderer == null) {
                    this.renderer = new TreasureChestItemRenderer();
                }
                return this.renderer;
            }
        });
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate)});
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> state) {
        state.getController().setAnimation(IDLE);
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

