/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarysurvivaloverhaul.api;

import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageEffects;
import net.minecraft.world.damagesource.DamageScaling;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import sfiomn.legendarysurvivaloverhaul.util.DamageSourceUtil;

public class ModDamageTypes {
    public static final ResourceKey<DamageType> HYPOTHERMIA = ModDamageTypes.registerKey("hypothermia");
    public static final ResourceKey<DamageType> HYPERTHERMIA = ModDamageTypes.registerKey("hyperthermia");
    public static final ResourceKey<DamageType> DEHYDRATION = ModDamageTypes.registerKey("dehydration");

    public static ResourceKey<DamageType> registerKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"legendarysurvivaloverhaul", (String)name));
    }

    public static void hyperthermia(Entity entity, float amount) {
        entity.hurt(DamageSourceUtil.getDamageSource(entity.level(), HYPERTHERMIA), amount);
    }

    public static void hypothermia(Entity entity, float amount) {
        entity.hurt(DamageSourceUtil.getDamageSource(entity.level(), HYPOTHERMIA), amount);
    }

    public static void dehydration(Entity entity, float amount) {
        entity.hurt(DamageSourceUtil.getDamageSource(entity.level(), DEHYDRATION), amount);
    }

    public static void bootstrap(BootstrapContext<DamageType> context) {
        context.register(HYPOTHERMIA, (Object)new DamageType("legendarysurvivaloverhaul.hypothermia", DamageScaling.NEVER, 0.1f, DamageEffects.FREEZING));
        context.register(HYPERTHERMIA, (Object)new DamageType("legendarysurvivaloverhaul.hyperthermia", DamageScaling.NEVER, 0.1f, DamageEffects.BURNING));
        context.register(DEHYDRATION, (Object)new DamageType("legendarysurvivaloverhaul.dehydration", DamageScaling.NEVER, 0.1f, DamageEffects.POKING));
    }
}

