/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarysurvivaloverhaul.api.data.json;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.registries.DeferredHolder;
import sfiomn.legendarysurvivaloverhaul.api.temperature.TemporaryModifierGroupEnum;

public class JsonTemperatureConsumableBlock {
    public static final Codec<JsonTemperatureConsumableBlock> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.STRING.fieldOf("group").forGetter(c -> c.group.name()), (App)Codec.INT.fieldOf("temperature_level").forGetter(c -> c.temperatureLevel), (App)Codec.INT.fieldOf("duration").forGetter(c -> c.duration), (App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.STRING).optionalFieldOf("properties", new HashMap()).forGetter(c -> c.properties)).apply((Applicative)inst, JsonTemperatureConsumableBlock::new));
    public static final Codec<List<JsonTemperatureConsumableBlock>> LIST_CODEC = CODEC.listOf();
    public TemporaryModifierGroupEnum group;
    public int temperatureLevel;
    public int duration;
    public Map<String, String> properties;
    private DeferredHolder<MobEffect, ? extends MobEffect> effect;
    private DeferredHolder<MobEffect, ? extends MobEffect> oppositeEffect;

    public JsonTemperatureConsumableBlock(String group, int temperatureLevel, int duration, Map<String, String> properties) {
        this.temperatureLevel = temperatureLevel;
        this.duration = duration;
        this.group = TemporaryModifierGroupEnum.get(group);
        this.properties = new HashMap<String, String>();
        this.properties.putAll(properties);
        this.effect = null;
        this.oppositeEffect = null;
        if (temperatureLevel > 0) {
            this.effect = this.group.hotEffect;
            this.oppositeEffect = this.group.coldEffect;
        } else if (temperatureLevel < 0) {
            this.effect = this.group.coldEffect;
            this.oppositeEffect = this.group.hotEffect;
        }
    }

    public MobEffect getEffect() {
        return (MobEffect)this.effect.get();
    }

    public MobEffect getOppositeEffect() {
        return (MobEffect)this.oppositeEffect.get();
    }

    public boolean isDefault() {
        return this.properties.isEmpty();
    }

    public boolean matchesState(BlockState blockState) {
        for (Property property : blockState.getProperties()) {
            String name = property.getName();
            if (!this.properties.containsKey(name)) continue;
            String stateValue = blockState.getValue(property).toString();
            if (this.properties.get(name).equalsIgnoreCase(stateValue)) continue;
            return false;
        }
        return true;
    }

    public DeferredHolder<MobEffect, ? extends MobEffect> getEffectHolder() {
        return this.effect;
    }

    public DeferredHolder<MobEffect, ? extends MobEffect> getOppositeEffectHolder() {
        return this.oppositeEffect;
    }
}

