/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarysurvivaloverhaul.api.data.providers;

import com.google.gson.JsonElement;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import sfiomn.legendarysurvivaloverhaul.api.data.builder.IBodyPartResistanceData;
import sfiomn.legendarysurvivaloverhaul.api.data.builder.IBodyPartsDamageSourceData;
import sfiomn.legendarysurvivaloverhaul.api.data.builder.IHealingConsumableData;
import sfiomn.legendarysurvivaloverhaul.data.builders.BodyPartResistanceData;
import sfiomn.legendarysurvivaloverhaul.data.builders.BodyPartsDamageSourceData;
import sfiomn.legendarysurvivaloverhaul.data.builders.HealingConsumableData;

public abstract class BodyDamageDataProvider
implements DataProvider {
    private final String modId;
    private final CompletableFuture<HolderLookup.Provider> lookupProvider;
    private final PackOutput.PathProvider consumablesPathProvider;
    private final PackOutput.PathProvider bodyPartsDamageSourcePathProvider;
    private final PackOutput.PathProvider bodyPartResistancePathProvider;
    private final Map<String, IHealingConsumableData> consumablesBuilders = new HashMap<String, IHealingConsumableData>();
    private final Map<String, IBodyPartsDamageSourceData> bodyPartsDamageSourceBuilders = new HashMap<String, IBodyPartsDamageSourceData>();
    private final Map<String, IBodyPartResistanceData> bodyPartResistanceBuilders = new HashMap<String, IBodyPartResistanceData>();
    private final ExistingFileHelper fileHelper;

    public BodyDamageDataProvider(String modId, PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider, ExistingFileHelper fileHelper) {
        this.modId = modId;
        this.fileHelper = fileHelper;
        this.consumablesPathProvider = output.createPathProvider(PackOutput.Target.DATA_PACK, "legendarysurvivaloverhaul/body_damage/consumables");
        this.bodyPartsDamageSourcePathProvider = output.createPathProvider(PackOutput.Target.DATA_PACK, "legendarysurvivaloverhaul/body_damage/damage_sources");
        this.bodyPartResistancePathProvider = output.createPathProvider(PackOutput.Target.DATA_PACK, "legendarysurvivaloverhaul/body_damage/items");
        this.lookupProvider = lookupProvider;
    }

    public abstract void generate(HolderLookup.Provider var1, ExistingFileHelper var2);

    @Nonnull
    public CompletableFuture<?> run(@Nonnull CachedOutput pOutput) {
        return this.lookupProvider.thenCompose(p_255484_ -> {
            ArrayList list = new ArrayList();
            this.generate((HolderLookup.Provider)p_255484_, this.fileHelper);
            this.consumablesBuilders.forEach((consumable, builder) -> {
                ResourceLocation jsonKey = consumable.split(":").length == 1 ? ResourceLocation.fromNamespaceAndPath((String)this.modId, (String)consumable.toLowerCase()) : ResourceLocation.parse((String)consumable);
                list.add(DataProvider.saveStable((CachedOutput)pOutput, (JsonElement)builder.build(), (Path)this.consumablesPathProvider.json(jsonKey)));
            });
            this.bodyPartsDamageSourceBuilders.forEach((damageSource, builder) -> {
                Path path = this.bodyPartsDamageSourcePathProvider.json(ResourceLocation.fromNamespaceAndPath((String)this.modId, (String)damageSource.toLowerCase()));
                list.add(DataProvider.saveStable((CachedOutput)pOutput, (JsonElement)builder.build(), (Path)path));
            });
            this.bodyPartResistanceBuilders.forEach((bodyResistance, builder) -> {
                ResourceLocation jsonKey = bodyResistance.split(":").length == 1 ? ResourceLocation.fromNamespaceAndPath((String)this.modId, (String)bodyResistance.toLowerCase()) : ResourceLocation.parse((String)bodyResistance);
                list.add(DataProvider.saveStable((CachedOutput)pOutput, (JsonElement)builder.build(), (Path)this.bodyPartResistancePathProvider.json(jsonKey)));
            });
            return CompletableFuture.allOf((CompletableFuture[])list.toArray(CompletableFuture[]::new));
        });
    }

    public final IHealingConsumableData consumable(String id) {
        return this.consumablesBuilders.computeIfAbsent(id, k -> new HealingConsumableData());
    }

    public final IHealingConsumableData consumable(Item item) {
        ResourceLocation itemRegistryName = BuiltInRegistries.ITEM.getKey((Object)item);
        assert (itemRegistryName != null);
        return this.consumablesBuilders.computeIfAbsent(itemRegistryName.toString(), k -> new HealingConsumableData());
    }

    public final IBodyPartsDamageSourceData damageSource(String id) {
        return this.bodyPartsDamageSourceBuilders.computeIfAbsent(id, k -> new BodyPartsDamageSourceData());
    }

    public final IBodyPartResistanceData item(String id) {
        return this.bodyPartResistanceBuilders.computeIfAbsent(id, k -> new BodyPartResistanceData());
    }

    public final IBodyPartResistanceData item(Item item) {
        ResourceLocation itemRegistryName = BuiltInRegistries.ITEM.getKey((Object)item);
        assert (itemRegistryName != null);
        return this.bodyPartResistanceBuilders.computeIfAbsent(itemRegistryName.toString(), k -> new BodyPartResistanceData());
    }

    @Nonnull
    public final String getName() {
        return "Body Damage for " + this.modId;
    }
}

