/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarysurvivaloverhaul.client.particles;

import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;

public class FernBlossomParticle
extends TextureSheetParticle {
    protected final SpriteSet animatedSprite;
    private float angle;

    protected FernBlossomParticle(SpriteSet animatedSprite, ClientLevel level, double x, double y, double z, double xd, double yd, double zd) {
        super(level, x, y, z, xd, yd, zd);
        this.setSpriteFromAge(animatedSprite);
        this.animatedSprite = animatedSprite;
        this.angle = this.random.nextFloat() * ((float)Math.PI * 2);
        this.lifetime = this.random.nextInt(75) + 75;
        this.quadSize *= (float)(2.0 + (double)this.random.nextFloat() * 0.5);
        this.xd = xd;
        this.yd = yd + this.random.nextDouble() * 0.05;
        this.zd = zd;
        this.rCol = 1.0f;
        this.gCol = 1.0f;
        this.bCol = 1.0f;
    }

    public void tick() {
        super.tick();
        if (this.age % 5 == 0) {
            this.angle = (float)(Math.random() * 6.28318530718);
        }
        this.xd += Math.cos(this.angle) * 5.0E-4;
        this.zd += Math.sin(this.angle) * 5.0E-4;
        this.setSpriteFromAge(this.animatedSprite);
        this.fadeOut();
    }

    private void fadeOut() {
        this.alpha = (float)this.age / (float)this.lifetime < 0.5f ? 1.0f : 1.0f - ((float)this.age / (float)this.lifetime - 0.5f) * 2.0f;
    }

    protected int getLightColor(float partialTick) {
        float f = (float)this.lifetime / ((float)this.age + (float)this.lifetime * 0.5f + partialTick);
        f = Mth.clamp((float)f, (float)0.0f, (float)0.5f);
        int i = super.getLightColor(partialTick);
        int j = i & 0xFF;
        int k = i >> 16 & 0xFF;
        if ((j += (int)(f * 15.0f * 16.0f)) > 240) {
            j = 240;
        }
        return j | k << 16;
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet animatedSprite;

        public Factory(SpriteSet animatedSprite) {
            this.animatedSprite = animatedSprite;
        }

        @Nullable
        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xd, double yd, double zd) {
            return new FernBlossomParticle(this.animatedSprite, level, x, y, z, xd, yd, zd);
        }
    }
}

