/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarysurvivaloverhaul.client.render;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import sfiomn.legendarysurvivaloverhaul.LegendarySurvivalOverhaul;
import sfiomn.legendarysurvivaloverhaul.common.attachments.temperature.TemperatureItemAttachment;
import sfiomn.legendarysurvivaloverhaul.common.integration.eclipticseasons.EclipticSeasonsUtil;
import sfiomn.legendarysurvivaloverhaul.common.integration.sereneseasons.SereneSeasonsUtil;
import sfiomn.legendarysurvivaloverhaul.config.Config;
import sfiomn.legendarysurvivaloverhaul.registry.ItemRegistry;
import sfiomn.legendarysurvivaloverhaul.util.AttachmentUtil;
import sfiomn.legendarysurvivaloverhaul.util.ItemUtil;
import sfiomn.legendarysurvivaloverhaul.util.WorldUtil;

public class RenderTooltipFrame {
    public static final ResourceLocation ICONS = ResourceLocation.fromNamespaceAndPath((String)"legendarysurvivaloverhaul", (String)"textures/gui/overlay.png");
    private static final int FRAME_HEIGHT = 20;
    private static final int FRAME_WIDTH = 122;
    private static final int LEFT_SIDE_FRAME_X_OFFSET = 0;
    private static final int LEFT_SIDE_FRAME_WIDTH = 6;
    private static final int MIDDLE_SIDE_FRAME_X_OFFSET = 4;
    private static final int RIGHT_SIDE_FRAME_WIDTH = 6;
    private static final int RIGHT_SIDE_FRAME_X_OFFSET = 116;
    private static final int MIDDLE_SIDE_FRAME_MAX_WIDTH = 114;
    private static Entity ENTITY_LOOKED_AT = null;

    public static void render(Gui gui, GuiGraphics guiGraphics, float partialTicks, int width, int height) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null && (ENTITY_LOOKED_AT == null || player.tickCount % 4 == 0)) {
            ENTITY_LOOKED_AT = WorldUtil.getEntityLookedAt((Player)player, player.getAttributeValue(Attributes.ENTITY_INTERACTION_RANGE));
        }
        if (ENTITY_LOOKED_AT instanceof ItemFrame && !((ItemFrame)ENTITY_LOOKED_AT).getItem().isEmpty()) {
            Item itemInFrame = ((ItemFrame)ENTITY_LOOKED_AT).getItem().getItem();
            Component text = null;
            if (LegendarySurvivalOverhaul.sereneSeasonsLoaded && (Objects.equals(BuiltInRegistries.ITEM.getKey((Object)itemInFrame), ResourceLocation.fromNamespaceAndPath((String)"sereneseasons", (String)"calendar")) || itemInFrame == ItemRegistry.SEASONAL_CALENDAR.get())) {
                text = SereneSeasonsUtil.seasonTooltip(ENTITY_LOOKED_AT.blockPosition(), ENTITY_LOOKED_AT.level());
            } else if (LegendarySurvivalOverhaul.eclipticSeasonsLoaded && itemInFrame == ItemRegistry.SEASONAL_CALENDAR.get()) {
                text = EclipticSeasonsUtil.seasonTooltip(ENTITY_LOOKED_AT.level());
            } else if (itemInFrame == ItemRegistry.THERMOMETER.get()) {
                TemperatureItemAttachment tempItemCap = AttachmentUtil.getTempItemAttachment(((ItemFrame)ENTITY_LOOKED_AT).getItem());
                float temperature = tempItemCap.getWorldTemperatureLevel();
                text = Config.Baked.renderTemperatureInFahrenheit ? Component.literal((String)(WorldUtil.toFahrenheit(temperature) + "\u00b0F")) : Component.literal((String)(temperature + "\u00b0C"));
            } else if (itemInFrame == Items.COMPASS) {
                String loc = ItemUtil.compassLocation(ENTITY_LOOKED_AT);
                if (!loc.isEmpty()) {
                    text = Component.literal((String)loc);
                }
            } else if (itemInFrame == Items.CLOCK) {
                text = Component.literal((String)WorldUtil.timeInGame(Minecraft.getInstance()));
            }
            if (text != null) {
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                Minecraft.getInstance().getProfiler().push("tooltip_frame");
                RenderTooltipFrame.drawTooltipInFrame(guiGraphics, width, height, text);
                Minecraft.getInstance().getProfiler().pop();
                RenderSystem.disableBlend();
            }
        }
    }

    public static void drawTooltipInFrame(GuiGraphics gui, int width, int height, Component text) {
        int textWidth = Minecraft.getInstance().font.width((FormattedText)text);
        int white = 0xFFFFFF;
        int left = width / 2 - textWidth / 2 - 6;
        int top = height / 2 + 10;
        int x = left;
        gui.blit(ICONS, x, top, 0, 18, 6, 20);
        int remainingTextWidth = textWidth;
        x = left + 6;
        while (remainingTextWidth > 0) {
            int renderedWidth = Math.min(remainingTextWidth, 114);
            gui.blit(ICONS, x, top, 4, 18, renderedWidth, 20);
            remainingTextWidth -= renderedWidth;
            x += renderedWidth;
        }
        x = left + 6 + textWidth;
        gui.blit(ICONS, x, top, 116, 18, 6, 20);
        gui.drawCenteredString(Minecraft.getInstance().font, text, width / 2, top + 10 - 4, white);
    }
}

