/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarysurvivaloverhaul.client.shaders;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.PostChain;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class FocusShader {
    public static final ResourceLocation BLUR_SHADER = ResourceLocation.parse((String)"shaders/post/blobs2.json");

    public void render(float intensity) {
        if (intensity <= 0.0f) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        PostChain effect = mc.gameRenderer.currentEffect();
        if (effect == null || !effect.getName().equals("minecraft:shaders/post/blobs2.json")) {
            try {
                mc.gameRenderer.loadEffect(BLUR_SHADER);
                effect = mc.gameRenderer.currentEffect();
            }
            catch (NullPointerException e) {
                return;
            }
        }
        this.updateIntensity(intensity);
    }

    public void stopRender() {
        Minecraft mc = Minecraft.getInstance();
        PostChain effect = mc.gameRenderer.currentEffect();
        if (effect != null && effect.getName().equals("minecraft:shaders/post/blobs2.json")) {
            mc.gameRenderer.shutdownEffect();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void updateIntensity(float intensity) {
        PostChain effect = Minecraft.getInstance().gameRenderer.currentEffect();
        if (effect != null) {
            effect.setUniform("Radius", intensity);
        }
    }
}

