/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarysurvivaloverhaul.common.attachments.food;

import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import sfiomn.legendarysurvivaloverhaul.api.food.IFoodAttachment;
import sfiomn.legendarysurvivaloverhaul.config.Config;

public class FoodAttachment
implements IFoodAttachment {
    private Vec3 oldPos;
    private boolean wasSprinting;
    private int updateTickTimer;

    public FoodAttachment() {
        this.init();
    }

    public void init() {
        this.oldPos = null;
        this.updateTickTimer = 0;
        this.wasSprinting = false;
    }

    @Override
    public void tickUpdate(Player player, Level world, boolean isStart) {
        if (isStart) {
            return;
        }
        if (this.oldPos == null) {
            this.oldPos = player.position();
        }
        ++this.updateTickTimer;
        if (this.updateTickTimer >= 10) {
            this.updateTickTimer = 0;
            if (this.oldPos.distanceTo(player.position()) > 1.0) {
                float foodExhausted = player.isSprinting() && this.wasSprinting ? (float)Config.Baked.sprintingFoodExhaustion : (player.isSprinting() || this.wasSprinting ? (float)((Config.Baked.sprintingFoodExhaustion + Config.Baked.baseFoodExhaustion) / 2.0) : (float)Config.Baked.baseFoodExhaustion);
                player.getFoodData().addExhaustion(foodExhausted);
                this.oldPos = player.position();
                this.wasSprinting = player.isSprinting();
            }
        }
    }
}

