/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarysurvivaloverhaul.common.blocks;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import sfiomn.legendarysurvivaloverhaul.common.blocks.HeaterBaseBlock;
import sfiomn.legendarysurvivaloverhaul.registry.BlockRegistry;

public class HeaterTopBlock
extends HorizontalDirectionalBlock {
    public static final MapCodec<HeaterTopBlock> CODEC = HeaterTopBlock.simpleCodec(HeaterTopBlock::new);
    private static final VoxelShape BASE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);
    private static final VoxelShape TUBE = Block.box((double)4.0, (double)2.0, (double)4.0, (double)12.0, (double)14.0, (double)12.0);
    private static final VoxelShape TOP = Block.box((double)3.0, (double)14.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);
    private static final VoxelShape XZ_AXIS_AABB = Shapes.or((VoxelShape)BASE, (VoxelShape[])new VoxelShape[]{TUBE, TOP});

    public HeaterTopBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    public static BlockBehaviour.Properties getProperties() {
        return BlockBehaviour.Properties.of().mapColor(MapColor.METAL).sound(SoundType.METAL).strength(3.0f, 10.0f).noOcclusion();
    }

    public MapCodec<HeaterTopBlock> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return XZ_AXIS_AABB;
    }

    @NotNull
    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        Block block;
        BlockState bottomState = level.getBlockState(pos.below());
        if (bottomState.is((Block)BlockRegistry.HEATER.get()) && (block = bottomState.getBlock()) instanceof HeaterBaseBlock) {
            HeaterBaseBlock heater = (HeaterBaseBlock)block;
            return heater.useWithoutItem(bottomState, level, pos.below(), player, hit);
        }
        return InteractionResult.PASS;
    }

    @NotNull
    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        Block block;
        BlockState bottomState = level.getBlockState(pos.below());
        if (bottomState.is((Block)BlockRegistry.HEATER.get()) && (block = bottomState.getBlock()) instanceof HeaterBaseBlock) {
            HeaterBaseBlock heater = (HeaterBaseBlock)block;
            return heater.onTopUseItem(stack, bottomState, level, pos.below(), player, hand, hit);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        super.onRemove(state, level, pos, newState, isMoving);
        if (!state.is(newState.getBlock()) && level.getBlockState(pos.below()).getBlock() instanceof HeaterBaseBlock) {
            level.removeBlock(pos.below(), false);
        }
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection());
    }
}

