/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarysurvivaloverhaul.common.blocks;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import sfiomn.legendarysurvivaloverhaul.registry.ParticleTypeRegistry;

public class SunFernGoldBlock
extends BushBlock {
    public static final MapCodec<SunFernGoldBlock> CODEC = SunFernGoldBlock.simpleCodec(SunFernGoldBlock::new);

    public SunFernGoldBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public static BlockBehaviour.Properties getProperties() {
        return BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).randomTicks().noOcclusion().noCollission().instabreak().sound(SoundType.CROP).pushReaction(PushReaction.DESTROY);
    }

    public MapCodec<SunFernGoldBlock> codec() {
        return CODEC;
    }

    protected boolean mayPlaceOn(BlockState blockState, BlockGetter level, BlockPos pos) {
        return blockState.is(Blocks.GRASS_BLOCK) || blockState.is(Blocks.DIRT) || blockState.is(Blocks.COARSE_DIRT) || blockState.is(Blocks.PODZOL) || blockState.is(Blocks.FARMLAND) || blockState.is(BlockTags.SAND);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource rand) {
        double offsetX = (2.0f * rand.nextFloat() - 1.0f) * 0.3f;
        double offsetZ = (2.0f * rand.nextFloat() - 1.0f) * 0.3f;
        double x = (double)pos.getX() + 0.5 + offsetX;
        double y = (double)pos.getY() + 0.5 + (double)(rand.nextFloat() * 0.05f);
        double z = (double)pos.getZ() + 0.5 + offsetZ;
        if (level.getGameTime() % 3L == 0L) {
            level.addParticle((ParticleOptions)ParticleTypeRegistry.SUN_FERN_BLOSSOM.get(), x, y, z, 0.04, 0.01, 0.04);
        }
    }
}

