/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarysurvivaloverhaul.common.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.server.command.EnumArgument;
import sfiomn.legendarysurvivaloverhaul.LegendarySurvivalOverhaul;
import sfiomn.legendarysurvivaloverhaul.api.bodydamage.BodyPartEnum;
import sfiomn.legendarysurvivaloverhaul.common.attachments.bodydamage.BodyDamageAttachment;
import sfiomn.legendarysurvivaloverhaul.common.commands.CommandBase;
import sfiomn.legendarysurvivaloverhaul.util.AttachmentUtil;

public class BodyDamageCommand
extends CommandBase {
    public BodyDamageCommand() {
        super((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"bodydamage").requires(p_198521_0_ -> p_198521_0_.hasPermission(2))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"target", (ArgumentType)EntityArgument.entities()).then(((LiteralArgumentBuilder)Commands.literal((String)"set").then(Commands.argument((String)"BodyPart", (ArgumentType)EnumArgument.enumArgument(BodyPartEnum.class)).then(Commands.argument((String)"Health", (ArgumentType)FloatArgumentType.floatArg((float)0.0f)).executes(src -> new BodyDamageCommand().set((CommandSourceStack)src.getSource(), EntityArgument.getEntities((CommandContext)src, (String)"target"), (BodyPartEnum)((Object)((Object)src.getArgument("BodyPart", BodyPartEnum.class))), FloatArgumentType.getFloat((CommandContext)src, (String)"Health")))))).then(Commands.literal((String)"ALL").then(Commands.argument((String)"Health", (ArgumentType)FloatArgumentType.floatArg((float)0.0f)).executes(src -> new BodyDamageCommand().setAll((CommandSourceStack)src.getSource(), EntityArgument.getEntities((CommandContext)src, (String)"target"), FloatArgumentType.getFloat((CommandContext)src, (String)"Health"))))))).then(((LiteralArgumentBuilder)Commands.literal((String)"heal").then(Commands.argument((String)"BodyPart", (ArgumentType)EnumArgument.enumArgument(BodyPartEnum.class)).then(Commands.argument((String)"Health", (ArgumentType)FloatArgumentType.floatArg((float)0.0f)).executes(src -> new BodyDamageCommand().heal((CommandSourceStack)src.getSource(), EntityArgument.getEntities((CommandContext)src, (String)"target"), (BodyPartEnum)((Object)((Object)src.getArgument("BodyPart", BodyPartEnum.class))), FloatArgumentType.getFloat((CommandContext)src, (String)"Health")))))).then(Commands.literal((String)"ALL").then(Commands.argument((String)"Health", (ArgumentType)FloatArgumentType.floatArg((float)0.0f)).executes(src -> new BodyDamageCommand().healAll((CommandSourceStack)src.getSource(), EntityArgument.getEntities((CommandContext)src, (String)"target"), FloatArgumentType.getFloat((CommandContext)src, (String)"Health"))))))).then(((LiteralArgumentBuilder)Commands.literal((String)"get").then(Commands.argument((String)"BodyPart", (ArgumentType)EnumArgument.enumArgument(BodyPartEnum.class)).executes(src -> new BodyDamageCommand().get((CommandSourceStack)src.getSource(), EntityArgument.getEntities((CommandContext)src, (String)"target"), (BodyPartEnum)((Object)((Object)src.getArgument("BodyPart", BodyPartEnum.class))))))).then(Commands.literal((String)"ALL").executes(src -> new BodyDamageCommand().getAll((CommandSourceStack)src.getSource(), EntityArgument.getEntities((CommandContext)src, (String)"target"))))))));
    }

    public int get(CommandSourceStack source, Collection<? extends Entity> entities, BodyPartEnum bodyPart) {
        try {
            StringBuilder reply = new StringBuilder();
            for (Entity entity : entities) {
                if (!(entity instanceof Player)) continue;
                Player player = (Player)entity;
                if (!(source.getEntity() instanceof Player)) continue;
                BodyDamageAttachment cap = AttachmentUtil.getBodyDamageAttachment(player);
                float bodyPartMaxHealth = cap.getBodyPartMaxHealth(bodyPart);
                float bodyPartHealth = bodyPartMaxHealth - cap.getBodyPartDamage(bodyPart);
                reply.append("Player ").append(player.getName().getString()).append("\n").append("Body Limb ").append(bodyPart.name()).append(" Health : ").append(bodyPartHealth).append("/").append(bodyPartMaxHealth).append("\n");
                source.sendSuccess(() -> Component.literal((String)reply.toString()), false);
            }
        }
        catch (Exception e) {
            LegendarySurvivalOverhaul.LOGGER.error(e.getMessage());
        }
        return 1;
    }

    public int getAll(CommandSourceStack source, Collection<? extends Entity> entities) {
        try {
            StringBuilder reply = new StringBuilder();
            for (Entity entity : entities) {
                if (!(entity instanceof Player)) continue;
                Player player = (Player)entity;
                if (!(source.getEntity() instanceof Player)) continue;
                BodyDamageAttachment cap = AttachmentUtil.getBodyDamageAttachment(player);
                reply.append("Player ").append(player.getName().getString()).append("\n");
                for (BodyPartEnum bodyPart : BodyPartEnum.values()) {
                    float bodyPartMaxHealth = cap.getBodyPartMaxHealth(bodyPart);
                    float bodyPartHealth = bodyPartMaxHealth - cap.getBodyPartDamage(bodyPart);
                    reply.append("Body Limb ").append(bodyPart.name()).append(" Health : ").append(bodyPartHealth).append("/").append(bodyPartMaxHealth).append("\n");
                }
                source.sendSuccess(() -> Component.literal((String)reply.toString()), false);
            }
        }
        catch (Exception e) {
            LegendarySurvivalOverhaul.LOGGER.error(e.getMessage());
        }
        return 1;
    }

    private int set(CommandSourceStack src, Collection<? extends Entity> entities, BodyPartEnum bodyPart, float healthValue) throws CommandSyntaxException {
        for (Entity entity : entities) {
            if (!(entity instanceof Player)) continue;
            Player player = (Player)entity;
            BodyDamageAttachment cap = AttachmentUtil.getBodyDamageAttachment(player);
            cap.setBodyPartDamage(bodyPart, cap.getBodyPartMaxHealth(bodyPart) - healthValue);
        }
        return 1;
    }

    private int setAll(CommandSourceStack src, Collection<? extends Entity> entities, float healthValue) throws CommandSyntaxException {
        for (Entity entity : entities) {
            if (!(entity instanceof Player)) continue;
            Player player = (Player)entity;
            BodyDamageAttachment cap = AttachmentUtil.getBodyDamageAttachment(player);
            for (BodyPartEnum bodyPart : BodyPartEnum.values()) {
                cap.setBodyPartDamage(bodyPart, cap.getBodyPartMaxHealth(bodyPart) - healthValue);
            }
        }
        return 1;
    }

    private int heal(CommandSourceStack src, Collection<? extends Entity> entities, BodyPartEnum bodyPart, float healthValue) throws CommandSyntaxException {
        for (Entity entity : entities) {
            if (!(entity instanceof Player)) continue;
            Player player = (Player)entity;
            BodyDamageAttachment cap = AttachmentUtil.getBodyDamageAttachment(player);
            cap.setBodyPartDamage(bodyPart, cap.getBodyPartDamage(bodyPart) - healthValue);
        }
        return 1;
    }

    private int healAll(CommandSourceStack src, Collection<? extends Entity> entities, float healthValue) throws CommandSyntaxException {
        for (Entity entity : entities) {
            if (!(entity instanceof Player)) continue;
            Player player = (Player)entity;
            BodyDamageAttachment cap = AttachmentUtil.getBodyDamageAttachment(player);
            for (BodyPartEnum bodyPart : BodyPartEnum.values()) {
                cap.setBodyPartDamage(bodyPart, cap.getBodyPartDamage(bodyPart) - healthValue);
            }
        }
        return 1;
    }
}

