/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarysurvivaloverhaul.common.commands;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import sfiomn.legendarysurvivaloverhaul.LegendarySurvivalOverhaul;
import sfiomn.legendarysurvivaloverhaul.api.bodydamage.BodyPartEnum;
import sfiomn.legendarysurvivaloverhaul.api.temperature.TemperatureEnum;
import sfiomn.legendarysurvivaloverhaul.api.temperature.TemperatureUtil;
import sfiomn.legendarysurvivaloverhaul.common.attachments.bodydamage.BodyDamageAttachment;
import sfiomn.legendarysurvivaloverhaul.common.attachments.health.HealthAttachment;
import sfiomn.legendarysurvivaloverhaul.common.attachments.temperature.TemperatureAttachment;
import sfiomn.legendarysurvivaloverhaul.common.attachments.thirst.ThirstAttachment;
import sfiomn.legendarysurvivaloverhaul.common.attachments.wetness.WetnessAttachment;
import sfiomn.legendarysurvivaloverhaul.common.commands.CommandBase;
import sfiomn.legendarysurvivaloverhaul.config.Config;
import sfiomn.legendarysurvivaloverhaul.util.AttachmentUtil;
import sfiomn.legendarysurvivaloverhaul.util.MathUtil;

public class ModDataCommand
extends CommandBase {
    public ModDataCommand() {
        super((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"lsodata").requires(p_198521_0_ -> p_198521_0_.hasPermission(2))).executes(src -> new ModDataCommand().get((CommandSourceStack)src.getSource()))));
    }

    @Override
    public int get(CommandSourceStack source) {
        try {
            Entity entity = source.getEntity();
            if (entity instanceof Player) {
                Player player = (Player)entity;
                StringBuilder output = new StringBuilder();
                output.append("\u2554\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2557\n");
                output.append("\u2551  LEGENDARY SURVIVAL OVERHAUL - DEBUG  \u2551\n");
                output.append("\u2560\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2563\n");
                output.append("\u2551 \u2139\ufe0f  SYSTEM INFO                        \u2551\n");
                output.append("\u2551   Side:        ").append(String.format("%-23s", player.level().isClientSide() ? "CLIENT" : "SERVER")).append("\u2551\n");
                output.append("\u2551   Player:      ").append(String.format("%-23s", player.getName().getString())).append("\u2551\n");
                output.append("\u2560\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2563\n");
                if (Config.Baked.temperatureEnabled) {
                    TemperatureAttachment tempCap = AttachmentUtil.getTempAttachment(player);
                    float bodyTemp = MathUtil.round(tempCap.getTemperatureLevel(), 2);
                    float targetTemp = MathUtil.round(TemperatureUtil.getPlayerTargetTemperature(player), 2);
                    float worldTemp = MathUtil.round(TemperatureUtil.getWorldTemperature(player.level(), player.blockPosition()), 2);
                    TemperatureEnum tempEnum = tempCap.getTemperatureEnum();
                    output.append("\u2551 \ud83c\udf21\ufe0f  TEMPERATURE                        \u2551\n");
                    output.append("\u2551   Body Temp:   ").append(String.format("%-23s", bodyTemp + "\u00b0C (" + tempEnum.name() + ")")).append("\u2551\n");
                    output.append("\u2551   Target Temp: ").append(String.format("%-23s", targetTemp + "\u00b0C")).append("\u2551\n");
                    output.append("\u2551   World Temp:  ").append(String.format("%-23s", worldTemp + "\u00b0C")).append("\u2551\n");
                    output.append("\u2560\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2563\n");
                }
                if (Config.Baked.thirstEnabled) {
                    ThirstAttachment thirstCap = AttachmentUtil.getThirstAttachment(player);
                    int hydration = thirstCap.getHydrationLevel();
                    float saturation = MathUtil.round(thirstCap.getSaturationLevel(), 2);
                    float exhaustion = MathUtil.round(thirstCap.getThirstExhaustion(), 2);
                    output.append("\u2551 \ud83d\udca7 THIRST                              \u2551\n");
                    output.append("\u2551   Hydration:   ").append(String.format("%-23s", hydration + "/20")).append("\u2551\n");
                    output.append("\u2551   Saturation:  ").append(String.format("%-23s", Float.valueOf(saturation))).append("\u2551\n");
                    output.append("\u2551   Exhaustion:  ").append(String.format("%-23s", exhaustion + "/4")).append("\u2551\n");
                    output.append("\u2560\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2563\n");
                }
                if (Config.Baked.wetnessEnabled) {
                    WetnessAttachment wetnessCap = AttachmentUtil.getWetnessAttachment(player);
                    int wetness = wetnessCap.getWetness();
                    int ticksWet = wetnessCap.getWetnessTickTimer();
                    output.append("\u2551 \ud83c\udf0a WETNESS                             \u2551\n");
                    output.append("\u2551   Wetness:     ").append(String.format("%-23s", wetness + "/400")).append("\u2551\n");
                    output.append("\u2551   Ticks Wet:   ").append(String.format("%-23s", ticksWet)).append("\u2551\n");
                    output.append("\u2560\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2563\n");
                }
                if (Config.Baked.healthOverhaulEnabled) {
                    HealthAttachment healthCap = AttachmentUtil.getHealthAttachment(player);
                    float currentHealth = MathUtil.round(player.getHealth(), 2);
                    float maxHealth = MathUtil.round(player.getMaxHealth(), 2);
                    float additionalHealth = MathUtil.round(healthCap.getAdditionalHealth(), 2);
                    float shieldHealth = MathUtil.round(healthCap.getShieldHealth(), 2);
                    output.append("\u2551 \u2764\ufe0f  HEALTH                             \u2551\n");
                    output.append("\u2551   Current:     ").append(String.format("%-23s", currentHealth + "/" + maxHealth)).append("\u2551\n");
                    output.append("\u2551   Additional:  ").append(String.format("%-23s", Float.valueOf(additionalHealth))).append("\u2551\n");
                    output.append("\u2551   Shield:      ").append(String.format("%-23s", Float.valueOf(shieldHealth))).append("\u2551\n");
                    output.append("\u2560\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2563\n");
                }
                if (Config.Baked.localizedBodyDamageEnabled) {
                    BodyDamageAttachment bodyCap = AttachmentUtil.getBodyDamageAttachment(player);
                    output.append("\u2551 \ud83e\ude79 BODY DAMAGE                         \u2551\n");
                    for (BodyPartEnum bodyPart : BodyPartEnum.values()) {
                        float damage = MathUtil.round(bodyCap.getBodyPartDamage(bodyPart), 2);
                        float healthRatio = bodyCap.getBodyPartHealthRatio(bodyPart);
                        float healthPercent = MathUtil.round(healthRatio * 100.0f, 0);
                        String partName = bodyPart.name().replace("_", " ");
                        output.append("\u2551   ").append(String.format("%-11s", partName)).append(": ");
                        output.append(String.format("%-20s", healthPercent + "% (" + damage + " dmg)")).append("\u2551\n");
                    }
                    output.append("\u2560\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2563\n");
                }
                output.append("\u2551 \u2139\ufe0f  GAME INFO                          \u2551\n");
                output.append("\u2551   Game Mode:   ").append(String.format("%-23s", player.isCreative() ? "CREATIVE" : (player.isSpectator() ? "SPECTATOR" : "SURVIVAL"))).append("\u2551\n");
                output.append("\u255a\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u255d");
                String finalOutput = output.toString();
                LegendarySurvivalOverhaul.LOGGER.info("LSO Debug Data for player {}:\n{}", (Object)player.getName().getString(), (Object)finalOutput);
                source.sendSuccess(() -> Component.literal((String)finalOutput), false);
            }
        }
        catch (Exception e) {
            LegendarySurvivalOverhaul.LOGGER.error("Error executing lsodata command: " + e.getMessage());
            e.printStackTrace();
        }
        return 1;
    }
}

