/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarysurvivaloverhaul.common.containers;

import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.registries.DeferredHolder;
import sfiomn.legendarysurvivaloverhaul.api.block.ThermalTypeEnum;
import sfiomn.legendarysurvivaloverhaul.common.blockentities.AbstractThermalBlockEntity;

public abstract class AbstractThermalContainer
extends AbstractContainerMenu {
    public final AbstractThermalBlockEntity blockEntity;
    public final ThermalTypeEnum thermalType;
    public final Level level;
    public final ContainerData dataAccess;

    public AbstractThermalContainer(int windowId, Inventory playerInventory, AbstractThermalBlockEntity be, ContainerData dataAccess, DeferredHolder<MenuType<?>, ? extends MenuType<?>> menuTypeSupplier, ThermalTypeEnum thermalType) {
        super((MenuType)menuTypeSupplier.get(), windowId);
        AbstractThermalContainer.checkContainerSize((Container)playerInventory, (int)4);
        this.thermalType = thermalType;
        this.blockEntity = be;
        this.level = playerInventory.player.level();
        this.dataAccess = dataAccess;
        this.addSlot(this.addThermalSlot(be, 0, 14, 32));
        this.addSlot(this.addThermalSlot(be, 1, 34, 32));
        this.addSlot(this.addThermalSlot(be, 2, 14, 52));
        this.addSlot(this.addThermalSlot(be, 3, 34, 52));
        this.layoutPlayerInventorySlots(playerInventory, 8, 84);
        this.addDataSlots(dataAccess);
    }

    private Slot addThermalSlot(final AbstractThermalBlockEntity be, int index, int posX, int posY) {
        return new Slot(this, (Container)be, index, posX, posY){

            public boolean mayPlace(ItemStack stack) {
                return be.isItemValid(stack.getItem());
            }
        };
    }

    public ThermalTypeEnum getThermalType() {
        return this.thermalType;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isPowered() {
        return this.blockEntity.isPowered();
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getFuelTimeScale() {
        if (this.dataAccess.get(1) != 0) {
            return (float)this.dataAccess.get(0) / (float)this.dataAccess.get(1);
        }
        return 0.0f;
    }

    private int addSlotRange(Inventory playerInventory, int index, int x, int y, int amount, int dx) {
        for (int i = 0; i < amount; ++i) {
            this.addSlot(new Slot((Container)playerInventory, index, x, y));
            x += dx;
            ++index;
        }
        return index;
    }

    private int addSlotBox(Inventory playerInventory, int index, int x, int y, int horAmount, int dx, int verAmount, int dy) {
        for (int j = 0; j < verAmount; ++j) {
            index = this.addSlotRange(playerInventory, index, x, y, horAmount, dx);
            y += dy;
        }
        return index;
    }

    private void layoutPlayerInventorySlots(Inventory playerInventory, int leftCol, int topRow) {
        int lastIndex = this.addSlotRange(playerInventory, 0, leftCol, topRow + 58, 9, 18);
        this.addSlotBox(playerInventory, lastIndex, leftCol, topRow, 9, 18, 3, 18);
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (index < 4) {
                if (!this.moveItemStackTo(itemstack1, 13, this.slots.size(), false)) {
                    return ItemStack.EMPTY;
                }
            } else if (index < this.slots.size()) {
                if (this.blockEntity.isItemValid(itemstack1.getItem()) ? !this.moveItemStackTo(itemstack1, 0, 4, false) : (index < 13 ? !this.moveItemStackTo(itemstack1, 13, this.slots.size(), false) : !this.moveItemStackTo(itemstack1, 4, 13, false))) {
                    return ItemStack.EMPTY;
                }
            } else {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (itemstack1.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, itemstack1);
        }
        return itemstack;
    }
}

