/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarysurvivaloverhaul.common.containers;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.ItemCombinerMenu;
import net.minecraft.world.inventory.ItemCombinerMenuSlotDefinition;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import sfiomn.legendarysurvivaloverhaul.api.temperature.TemperatureUtil;
import sfiomn.legendarysurvivaloverhaul.common.integration.mutantmonsters.MutantMonstersUtil;
import sfiomn.legendarysurvivaloverhaul.common.items.CoatItem;
import sfiomn.legendarysurvivaloverhaul.common.recipe.SewingRecipe;
import sfiomn.legendarysurvivaloverhaul.registry.BlockRegistry;
import sfiomn.legendarysurvivaloverhaul.registry.ContainerRegistry;
import sfiomn.legendarysurvivaloverhaul.registry.SoundRegistry;

public class SewingTableContainer
extends ItemCombinerMenu {
    public static final int INPUT_SLOT = 0;
    public static final int ADDITIONAL_SLOT = 1;
    public static final int RESULT_SLOT = 2;
    @Nullable
    private RecipeHolder<SewingRecipe> selectedRecipe;

    public SewingTableContainer(int windowId, Inventory playerInventory, FriendlyByteBuf data) {
        this(windowId, playerInventory, ContainerLevelAccess.NULL);
    }

    public SewingTableContainer(int windowId, Inventory playerInventory, ContainerLevelAccess access) {
        super((MenuType)ContainerRegistry.SEWING_TABLE_CONTAINER.get(), windowId, playerInventory, access);
    }

    public static boolean isItemArmor(ItemStack itemStack) {
        return itemStack.getItem() instanceof ArmorItem || MutantMonstersUtil.isMutantMonstersArmor(itemStack.getItem());
    }

    public static boolean isItemCoat(ItemStack itemStack) {
        return itemStack.getItem() instanceof CoatItem;
    }

    @NotNull
    protected ItemCombinerMenuSlotDefinition createInputSlotDefinitions() {
        return ItemCombinerMenuSlotDefinition.create().withSlot(0, 18, 39, itemStack -> true).withSlot(1, 65, 39, itemStack -> true).withResultSlot(2, 134, 39).build();
    }

    public void createResult() {
        RecipeInput recipeInput = new RecipeInput(){

            public ItemStack getItem(int index) {
                return SewingTableContainer.this.inputSlots.getItem(index);
            }

            public int size() {
                return SewingTableContainer.this.inputSlots.getContainerSize();
            }
        };
        List sewingRecipes = this.player.level().getRecipeManager().getRecipesFor((RecipeType)SewingRecipe.Type.INSTANCE, recipeInput, this.player.level());
        ItemStack itemStack = ItemStack.EMPTY;
        if (!SewingTableContainer.isItemArmor(this.inputSlots.getItem(0)) || !SewingTableContainer.isItemCoat(this.inputSlots.getItem(1))) {
            if (!sewingRecipes.isEmpty()) {
                this.selectedRecipe = (RecipeHolder)sewingRecipes.get(0);
                itemStack = ((SewingRecipe)this.selectedRecipe.value()).assemble(recipeInput, (HolderLookup.Provider)this.player.level().registryAccess());
                this.resultSlots.setRecipeUsed(this.selectedRecipe);
            }
        } else if (!Objects.equals(TemperatureUtil.getArmorCoatTag(this.inputSlots.getItem(0)), ((CoatItem)this.inputSlots.getItem((int)1).getItem()).coat.id())) {
            if (!sewingRecipes.isEmpty()) {
                this.selectedRecipe = (RecipeHolder)sewingRecipes.get(0);
                itemStack = ((SewingRecipe)this.selectedRecipe.value()).assemble(recipeInput, (HolderLookup.Provider)this.player.level().registryAccess());
                this.resultSlots.setRecipeUsed(this.selectedRecipe);
            } else {
                itemStack = this.inputSlots.getItem(0).copy();
                CoatItem coatItem = (CoatItem)this.inputSlots.getItem(1).getItem();
                TemperatureUtil.setArmorCoatTag(itemStack, coatItem.coat.id());
                Player player = this.player;
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    AdvancementHolder sewCoatAdvancement = serverPlayer.server.getAdvancements().get(ResourceLocation.parse((String)"legendarysurvivaloverhaul:main/sew_a_coat"));
                    if (sewCoatAdvancement != null) {
                        for (String criteria : serverPlayer.getAdvancements().getOrStartProgress(sewCoatAdvancement).getRemainingCriteria()) {
                            serverPlayer.getAdvancements().award(sewCoatAdvancement, criteria);
                        }
                    }
                }
            }
        }
        this.resultSlots.setItem(0, itemStack);
        this.broadcastChanges();
    }

    private void shrinkStackInSlot(int index) {
        this.inputSlots.removeItem(index, 1);
    }

    protected boolean mayPickup(Player player, boolean b) {
        return true;
    }

    protected void onTake(Player player, ItemStack itemStack) {
        itemStack.onCraftedBy(player.level(), player, itemStack.getCount());
        this.resultSlots.awardUsedRecipes(player, Collections.singletonList(itemStack));
        this.shrinkStackInSlot(0);
        this.shrinkStackInSlot(1);
        this.player.level().playSound(null, player.blockPosition(), (SoundEvent)SoundRegistry.SEWING_TABLE.get(), SoundSource.BLOCKS);
    }

    protected boolean isValidBlock(BlockState blockState) {
        return blockState.is((Block)BlockRegistry.SEWING_TABLE.get());
    }
}

