/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarysurvivaloverhaul.common.events;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.LevelData;
import net.minecraft.world.level.storage.PrimaryLevelData;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.event.ItemAttributeModifierEvent;
import net.neoforged.neoforge.event.OnDatapackSyncEvent;
import net.neoforged.neoforge.event.entity.living.LivingEntityUseItemEvent;
import net.neoforged.neoforge.event.entity.living.LivingEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;
import net.neoforged.neoforge.event.entity.player.AttackEntityEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.event.level.LevelEvent;
import net.neoforged.neoforge.event.level.SleepFinishedTimeEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import sfiomn.legendarysurvivaloverhaul.LegendarySurvivalOverhaul;
import sfiomn.legendarysurvivaloverhaul.api.ModDamageTypes;
import sfiomn.legendarysurvivaloverhaul.api.bodydamage.BodyDamageUtil;
import sfiomn.legendarysurvivaloverhaul.api.bodydamage.BodyPartEnum;
import sfiomn.legendarysurvivaloverhaul.api.bodydamage.DamageDistributionEnum;
import sfiomn.legendarysurvivaloverhaul.api.data.json.JsonBodyPartResistance;
import sfiomn.legendarysurvivaloverhaul.api.data.json.JsonBodyPartsDamageSource;
import sfiomn.legendarysurvivaloverhaul.api.data.json.JsonTemperatureResistance;
import sfiomn.legendarysurvivaloverhaul.api.data.json.JsonThirstBlock;
import sfiomn.legendarysurvivaloverhaul.api.data.manager.BodyDamageDataManager;
import sfiomn.legendarysurvivaloverhaul.api.health.HealthUtil;
import sfiomn.legendarysurvivaloverhaul.api.temperature.AttributeModifierBase;
import sfiomn.legendarysurvivaloverhaul.api.temperature.TemperatureUtil;
import sfiomn.legendarysurvivaloverhaul.api.thirst.ThirstUtil;
import sfiomn.legendarysurvivaloverhaul.common.attachments.bodydamage.BodyDamageAttachment;
import sfiomn.legendarysurvivaloverhaul.common.attachments.health.HealthAttachment;
import sfiomn.legendarysurvivaloverhaul.common.attachments.temperature.TemperatureAttachment;
import sfiomn.legendarysurvivaloverhaul.common.attachments.thirst.ThirstAttachment;
import sfiomn.legendarysurvivaloverhaul.common.attachments.wetness.WetnessAttachment;
import sfiomn.legendarysurvivaloverhaul.common.integration.curios.CuriosUtil;
import sfiomn.legendarysurvivaloverhaul.common.integration.medsandherbs.MedsAndHerbsUtil;
import sfiomn.legendarysurvivaloverhaul.common.integration.supplementaries.SupplementariesUtil;
import sfiomn.legendarysurvivaloverhaul.common.items.heal.BodyHealingItem;
import sfiomn.legendarysurvivaloverhaul.common.listeners.BodyDamageHealingConsumableListener;
import sfiomn.legendarysurvivaloverhaul.common.listeners.BodyPartResistanceItemListener;
import sfiomn.legendarysurvivaloverhaul.common.listeners.BodyPartsDamageSourceListener;
import sfiomn.legendarysurvivaloverhaul.common.listeners.TemperatureBiomeListener;
import sfiomn.legendarysurvivaloverhaul.common.listeners.TemperatureBlockListener;
import sfiomn.legendarysurvivaloverhaul.common.listeners.TemperatureConsumableListener;
import sfiomn.legendarysurvivaloverhaul.common.listeners.TemperatureDimensionListener;
import sfiomn.legendarysurvivaloverhaul.common.listeners.TemperatureFuelItemListener;
import sfiomn.legendarysurvivaloverhaul.common.listeners.TemperatureItemListener;
import sfiomn.legendarysurvivaloverhaul.common.listeners.TemperatureMountListener;
import sfiomn.legendarysurvivaloverhaul.common.listeners.TemperatureOriginListener;
import sfiomn.legendarysurvivaloverhaul.common.listeners.ThirstBlockListener;
import sfiomn.legendarysurvivaloverhaul.common.listeners.ThirstConsumableListener;
import sfiomn.legendarysurvivaloverhaul.config.Config;
import sfiomn.legendarysurvivaloverhaul.network.payloads.UpdateBodyDamagePayload;
import sfiomn.legendarysurvivaloverhaul.network.payloads.UpdateHeartsPayload;
import sfiomn.legendarysurvivaloverhaul.network.payloads.UpdateTemperaturesPayload;
import sfiomn.legendarysurvivaloverhaul.network.payloads.UpdateThirstPayload;
import sfiomn.legendarysurvivaloverhaul.network.payloads.UpdateWetnessPayload;
import sfiomn.legendarysurvivaloverhaul.registry.ItemRegistry;
import sfiomn.legendarysurvivaloverhaul.registry.MobEffectRegistry;
import sfiomn.legendarysurvivaloverhaul.registry.SoundRegistry;
import sfiomn.legendarysurvivaloverhaul.registry.TemperatureModifierRegistry;
import sfiomn.legendarysurvivaloverhaul.util.AttachmentUtil;
import sfiomn.legendarysurvivaloverhaul.util.ItemUtil;
import sfiomn.legendarysurvivaloverhaul.util.PlayerModelUtil;
import sfiomn.legendarysurvivaloverhaul.util.internal.BodyDamageUtilInternal;
import sfiomn.legendarysurvivaloverhaul.util.internal.TemperatureUtilInternal;

@EventBusSubscriber(modid="legendarysurvivaloverhaul", bus=EventBusSubscriber.Bus.GAME)
public class CommonForgeEvents {
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onItemUse(PlayerInteractEvent.RightClickItem event) {
        ItemStack itemStackInBasket;
        Player player;
        block7: {
            block6: {
                Player entity = event.getEntity();
                if (!(entity instanceof Player)) break block6;
                player = entity;
                if (event.getHand() == event.getEntity().getUsedItemHand()) break block7;
            }
            return;
        }
        ItemStack usedItemStack = event.getItemStack();
        if (LegendarySurvivalOverhaul.supplementariesLoaded && (itemStackInBasket = SupplementariesUtil.getSelectedItemInLunchBasket(event.getItemStack())) != ItemStack.EMPTY) {
            usedItemStack = itemStackInBasket;
        }
        ResourceLocation itemRegistryName = BuiltInRegistries.ITEM.getKey((Object)usedItemStack.getItem());
        if (LegendarySurvivalOverhaul.medsandherbsLoaded && itemRegistryName != null && itemRegistryName.getNamespace().equals("meds_and_herbs")) {
            if (itemRegistryName.equals((Object)ResourceLocation.fromNamespaceAndPath((String)"meds_and_herbs", (String)"syringe_morphine")) && !MedsAndHerbsUtil.triggerMorphineBehavior(player)) {
                event.setCanceled(true);
                event.setCancellationResult(InteractionResult.CONSUME);
            }
            BodyDamageUtil.applyConsumableHealing(player, usedItemStack, true);
        }
    }

    @SubscribeEvent
    public static void onFinishUseItem(LivingEntityUseItemEvent.Finish event) {
        ItemStack itemStackInBasket;
        LivingEntity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        ItemStack usedItemStack = event.getItem();
        if (LegendarySurvivalOverhaul.supplementariesLoaded && (itemStackInBasket = SupplementariesUtil.getSelectedItemInLunchBasket(event.getItem())) != ItemStack.EMPTY) {
            usedItemStack = itemStackInBasket;
        }
        if (!entity.level().isClientSide) {
            ResourceLocation itemRegistryName = BuiltInRegistries.ITEM.getKey((Object)usedItemStack.getItem());
            TemperatureUtil.applyConsumableTemperature(player, itemRegistryName);
        }
        if (!entity.level().isClientSide) {
            ThirstUtil.takeDrink(player, usedItemStack);
        }
        if (!(usedItemStack.getItem() instanceof BodyHealingItem)) {
            BodyDamageUtil.applyConsumableHealing(player, usedItemStack, true);
        }
    }

    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        Player player;
        ThirstAttachment thirstAttachment;
        if (CommonForgeEvents.shouldApplyThirst(event.getEntity()) && event.getHand() == InteractionHand.MAIN_HAND && event.getEntity().getMainHandItem().isEmpty() && !(thirstAttachment = AttachmentUtil.getThirstAttachment(player = event.getEntity())).isHydrationLevelAtMax()) {
            boolean hasMenu = event.getLevel().getBlockEntity(event.getHitVec().getBlockPos()) instanceof MenuProvider;
            if (hasMenu) {
                return;
            }
            JsonThirstBlock jsonBlockThirst = ThirstUtil.getBlockThirstLookedAt(player, (float)(player.getAttributeValue(Attributes.BLOCK_INTERACTION_RANGE) / 2.0));
            JsonThirstBlock jsonFluidThirst = ThirstUtil.getFluidThirstLookedAt(player, (float)(player.getAttributeValue(Attributes.BLOCK_INTERACTION_RANGE) / 2.0));
            if (!(jsonBlockThirst == null || jsonBlockThirst.hydration == 0 && jsonBlockThirst.saturation == 0.0f || event.getEntity().isCrouching())) {
                if (event.getLevel().isClientSide) {
                    CommonForgeEvents.playerDrinkEffect(event.getEntity());
                } else {
                    ThirstUtil.takeDrink(event.getEntity(), jsonBlockThirst.hydration, jsonBlockThirst.saturation, jsonBlockThirst.effects);
                }
                event.setCanceled(true);
                event.setCancellationResult(InteractionResult.CONSUME);
                return;
            }
            if (jsonFluidThirst != null && (jsonFluidThirst.hydration != 0 || jsonFluidThirst.saturation != 0.0f)) {
                if (event.getLevel().isClientSide) {
                    CommonForgeEvents.playerDrinkEffect(event.getEntity());
                } else {
                    ThirstUtil.takeDrink(event.getEntity(), jsonFluidThirst.hydration, jsonFluidThirst.saturation, jsonFluidThirst.effects);
                }
                return;
            }
        }
        if (Config.Baked.temperatureEnabled && event.getHand() == InteractionHand.MAIN_HAND && !event.getLevel().isClientSide()) {
            player = event.getEntity();
            BlockState usedBlock = event.getLevel().getBlockState(event.getHitVec().getBlockPos());
            if (player != null) {
                TemperatureUtil.applyConsumableBlockTemperature(player, usedBlock);
            }
        }
    }

    @SubscribeEvent
    public static void onAttributeModifier(ItemAttributeModifierEvent event) {
        if (!Config.Baked.temperatureEnabled && !Config.Baked.localizedBodyDamageEnabled) {
            return;
        }
        if (FMLEnvironment.dist == Dist.CLIENT && Minecraft.getInstance().level == null) {
            return;
        }
        if (ItemUtil.canBeEquippedInSlot(event.getItemStack(), ItemUtil.getEquippableSlot(event.getItemStack()))) {
            if (Config.Baked.temperatureEnabled) {
                JsonTemperatureResistance config = new JsonTemperatureResistance();
                for (AttributeModifierBase attributeModifier : new AttributeModifierBase[]{(AttributeModifierBase)TemperatureModifierRegistry.ITEM_ATTRIBUTE.get(), (AttributeModifierBase)TemperatureModifierRegistry.COAT_ATTRIBUTE.get()}) {
                    config.add(attributeModifier.getItemAttributes(event.getItemStack()));
                }
                UUID modifierUuid = TemperatureUtilInternal.equipmentSlotTemperatureUuid.get(ItemUtil.getEquippableSlot(event.getItemStack()));
                if (config.temperature != 0.0f) {
                    TemperatureUtilInternal.HEATING_TEMPERATURE.addModifier(event, modifierUuid, (double)Math.max(config.temperature, 0.0f));
                    TemperatureUtilInternal.COOLING_TEMPERATURE.addModifier(event, modifierUuid, (double)Math.min(config.temperature, 0.0f));
                }
                if (config.heatResistance != 0.0f) {
                    TemperatureUtilInternal.HEAT_RESISTANCE.addModifier(event, modifierUuid, (double)config.heatResistance);
                }
                if (config.coldResistance != 0.0f) {
                    TemperatureUtilInternal.COLD_RESISTANCE.addModifier(event, modifierUuid, (double)config.coldResistance);
                }
                if (config.thermalResistance != 0.0f) {
                    TemperatureUtilInternal.THERMAL_RESISTANCE.addModifier(event, modifierUuid, (double)config.thermalResistance);
                }
            }
            if (Config.Baked.localizedBodyDamageEnabled) {
                ResourceLocation itemRegistryName = BuiltInRegistries.ITEM.getKey((Object)event.getItemStack().getItem());
                JsonBodyPartResistance config = BodyDamageDataManager.getBodyResistanceItem(itemRegistryName);
                if (itemRegistryName == null || config == null) {
                    return;
                }
                UUID modifierUuid = BodyDamageUtilInternal.equipmentSlotBodyResistanceUuid.get(ItemUtil.getEquippableSlot(event.getItemStack()));
                if (config.bodyResistance != 0.0f) {
                    BodyDamageUtilInternal.BODY_RESISTANCE.addModifier(event, modifierUuid, (double)config.bodyResistance);
                }
                if (config.headResistance != 0.0f) {
                    BodyDamageUtilInternal.HEAD_RESISTANCE.addModifier(event, modifierUuid, (double)config.headResistance);
                }
                if (config.chestResistance != 0.0f) {
                    BodyDamageUtilInternal.CHEST_RESISTANCE.addModifier(event, modifierUuid, (double)config.chestResistance);
                }
                if (config.rightArmResistance != 0.0f) {
                    BodyDamageUtilInternal.RIGHT_ARM_RESISTANCE.addModifier(event, modifierUuid, (double)config.rightArmResistance);
                }
                if (config.leftArmResistance != 0.0f) {
                    BodyDamageUtilInternal.LEFT_ARM_RESISTANCE.addModifier(event, modifierUuid, (double)config.leftArmResistance);
                }
                if (config.legsResistance != 0.0f) {
                    BodyDamageUtilInternal.LEGS_RESISTANCE.addModifier(event, modifierUuid, (double)config.legsResistance);
                }
                if (config.feetResistance != 0.0f) {
                    BodyDamageUtilInternal.FEET_RESISTANCE.addModifier(event, modifierUuid, (double)config.feetResistance);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onJump(LivingEvent.LivingJumpEvent event) {
        LivingEntity entity = event.getEntity();
        if (entity instanceof Player && CommonForgeEvents.shouldApplyThirst((Player)entity) && !entity.level().isClientSide) {
            ThirstUtil.addExhaustion((Player)entity, (float)Config.Baked.onJumpHydrationExhaustion);
        }
    }

    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        Player player = event.getPlayer();
        if (CommonForgeEvents.shouldApplyThirst(player) && !player.level().isClientSide && event.getState().getDestroySpeed((BlockGetter)event.getLevel(), event.getPos()) > 0.0f) {
            ThirstUtil.addExhaustion(player, (float)Config.Baked.onBlockBreakHydrationExhaustion);
        }
    }

    @SubscribeEvent
    public static void onAttackEntity(AttackEntityEvent event) {
        Entity monster;
        Player player = event.getEntity();
        if (CommonForgeEvents.shouldApplyThirst(player) && !player.level().isClientSide && (monster = event.getTarget()).isAttackable()) {
            ThirstUtil.addExhaustion(player, (float)Config.Baked.onAttackHydrationExhaustion);
            player.causeFoodExhaustion((float)Config.Baked.onAttackFoodExhaustion);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onEntityHurt(LivingIncomingDamageEvent event) {
        if (!(event.getSource().is(DamageTypes.FALL) || event.getSource().is(DamageTypes.STARVE) || event.getSource().is(DamageTypes.FREEZE) || event.getSource().is(DamageTypes.DROWN) || event.getSource().is(ModDamageTypes.DEHYDRATION) || event.getSource().is(ModDamageTypes.HYPOTHERMIA) || event.getSource().is(ModDamageTypes.HYPERTHERMIA) || !event.getEntity().hasEffect(MobEffectRegistry.VULNERABILITY))) {
            event.setAmount(event.getAmount() * (1.0f + 0.2f * (float)Objects.requireNonNull(event.getEntity().getEffect(MobEffectRegistry.VULNERABILITY)).getAmplifier() + 1.0f));
        } else if (event.getSource().is(DamageTypes.FALL) && event.getEntity().hasEffect(MobEffectRegistry.HARD_FALLING)) {
            event.setAmount(event.getAmount() * (1.0f + 0.2f * (float)Objects.requireNonNull(event.getEntity().getEffect(MobEffectRegistry.HARD_FALLING)).getAmplifier() + 1.0f));
            event.getEntity().level().playSound(null, (Entity)event.getEntity(), (SoundEvent)SoundRegistry.HARD_FALLING_HURT.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onEntityHurtDamage(LivingIncomingDamageEvent event) {
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getEntity();
        if (player.level().isClientSide) {
            return;
        }
        if (CommonForgeEvents.shouldApplyHealthOverhaul(player)) {
            event.setAmount(HealthUtil.hurtPlayer(player, event.getAmount()));
        }
        if (CommonForgeEvents.shouldApplyLocalizedBodyDamage(player)) {
            float bodyPartDamageValue = event.getAmount() * (float)Config.Baked.bodyDamageMultiplier;
            DamageSource source = event.getSource();
            JsonBodyPartsDamageSource damageSourceBodyParts = BodyDamageDataManager.getBodyParts(source.getMsgId());
            ArrayList<BodyPartEnum> hitBodyParts = new ArrayList<BodyPartEnum>();
            if (damageSourceBodyParts != null) {
                if (damageSourceBodyParts.damageDistribution != DamageDistributionEnum.NONE) {
                    hitBodyParts.addAll(damageSourceBodyParts.getBodyParts(player));
                }
            } else {
                List<BodyPartEnum> possibleHitParts;
                if (source.is(DamageTypeTags.IS_PROJECTILE) && source.getDirectEntity() != null) {
                    hitBodyParts.addAll(PlayerModelUtil.getPreciseEntityImpact(source.getDirectEntity(), player));
                } else if (source.getDirectEntity() != null && !(possibleHitParts = PlayerModelUtil.getEntityImpact(source.getDirectEntity(), player)).isEmpty()) {
                    hitBodyParts.addAll(DamageDistributionEnum.ONE_OF.getBodyParts(player, possibleHitParts));
                }
                if (hitBodyParts.isEmpty()) {
                    hitBodyParts.addAll(DamageDistributionEnum.ONE_OF.getBodyParts(player, Arrays.asList(BodyPartEnum.values())));
                }
            }
            if (!hitBodyParts.isEmpty()) {
                BodyDamageUtil.balancedHurtBodyParts(player, hitBodyParts, bodyPartDamageValue);
            }
            if (source.is(DamageTypeTags.IS_PROJECTILE) && hitBodyParts.contains((Object)BodyPartEnum.HEAD) && Config.Baked.headCriticalShotMultiplier > 1.0 && player.getItemBySlot(EquipmentSlot.HEAD).isEmpty()) {
                event.setAmount(event.getAmount() * (float)Config.Baked.headCriticalShotMultiplier);
                player.level().playLocalSound(player.blockPosition(), (SoundEvent)SoundRegistry.HEADSHOT.get(), SoundSource.HOSTILE, 1.0f, 1.0f, false);
            }
        }
    }

    @SubscribeEvent
    public static void onSleepFinished(SleepFinishedTimeEvent event) {
        for (Player player : event.getLevel().players()) {
            if (!player.isSleepingLongEnough()) continue;
            if (Config.Baked.localizedBodyDamageEnabled && Config.Baked.bodyHealthRatioRecoveredFromSleep > 0.0) {
                for (BodyPartEnum bodyPart : BodyPartEnum.values()) {
                    double healthRecovered = (double)BodyDamageUtil.getMaxHealth(player, bodyPart) * Config.Baked.bodyHealthRatioRecoveredFromSleep;
                    BodyDamageUtil.healBodyPart(player, bodyPart, (float)healthRecovered);
                }
                AttachmentUtil.getBodyDamageAttachment(player).updateBrokenHearts(player);
                BodyDamageUtil.updatePlayerBrokenHeartAttribute(player);
            }
            if (!(Config.Baked.healthRatioRecoveredFromSleep > 0.0)) continue;
            HealthUtil.updatePlayerMaxHealthAttribute(player);
            double healthRecovered = (double)player.getMaxHealth() * Config.Baked.healthRatioRecoveredFromSleep;
            player.heal((float)healthRecovered);
        }
    }

    @SubscribeEvent
    public static void onPlayerEffect(MobEffectEvent.Applicable event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (!event.getEntity().level().isClientSide) {
                if (Config.Baked.healthOverhaulEnabled && event.getEffectInstance().getEffect() == MobEffects.ABSORPTION && Config.Baked.absorptionEffectOverride) {
                    HealthAttachment healthAttachment = AttachmentUtil.getHealthAttachment(player);
                    healthAttachment.addShieldHealth(2.0f);
                    event.setResult(MobEffectEvent.Applicable.Result.DO_NOT_APPLY);
                }
                if (event.getEffectInstance().getEffect() == MobEffectRegistry.THIRST.get() && CuriosUtil.isCurioItemEquipped(player, (Item)ItemRegistry.WATER_PURIFIER.get())) {
                    event.setResult(MobEffectEvent.Applicable.Result.DO_NOT_APPLY);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        if (event.isEndConquered()) {
            return;
        }
        if (Config.Baked.temperatureImmunityOnDeathEnabled && Config.Baked.temperatureEnabled) {
            event.getEntity().addEffect(new MobEffectInstance(MobEffectRegistry.TEMPERATURE_IMMUNITY, Config.Baked.temperatureImmunityOnDeathTime, 0, false, false, true));
        }
        if (Config.Baked.localizedBodyDamageEnabled) {
            Player player = event.getEntity();
            BodyDamageAttachment bodyCap = AttachmentUtil.getBodyDamageAttachment(player);
            for (BodyPartEnum part : BodyPartEnum.values()) {
                bodyCap.setBodyPartDamage(part, 0.0f);
            }
            bodyCap.updateBrokenHearts(player);
            bodyCap.setManualDirty();
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                UpdateBodyDamagePayload.sendToPlayer(serverPlayer, bodyCap.writeNBT());
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        if (Config.Baked.temperatureImmunityOnFirstSpawnEnabled && Config.Baked.temperatureEnabled && !event.getEntity().getPersistentData().getBoolean("tempImmuneOnSpawn")) {
            event.getEntity().getPersistentData().putBoolean("tempImmuneOnSpawn", true);
            event.getEntity().addEffect(new MobEffectInstance(MobEffectRegistry.TEMPERATURE_IMMUNITY, Config.Baked.temperatureImmunityOnFirstSpawnTime, 0, false, false, true));
        }
        if (Config.Baked.healthOverhaulEnabled) {
            HealthUtil.initializeHealthAttributes(event.getEntity());
        }
        HealthUtil.updatePlayerMaxHealthAttribute(event.getEntity());
        BodyDamageUtil.updatePlayerBrokenHeartAttribute(event.getEntity());
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (Config.Baked.temperatureEnabled) {
                TemperatureAttachment tempCap = AttachmentUtil.getTempAttachment((Player)serverPlayer);
                UpdateTemperaturesPayload.sendToPlayer(serverPlayer, tempCap.writeNBT());
            }
            if (Config.Baked.thirstEnabled) {
                ThirstAttachment thirstCap = AttachmentUtil.getThirstAttachment((Player)serverPlayer);
                UpdateThirstPayload.sendToPlayer(serverPlayer, thirstCap.writeNBT());
            }
            if (Config.Baked.wetnessEnabled) {
                WetnessAttachment wetnessCap = AttachmentUtil.getWetnessAttachment((Player)serverPlayer);
                UpdateWetnessPayload.sendToPlayer(serverPlayer, wetnessCap.writeNBT());
            }
            if (Config.Baked.localizedBodyDamageEnabled) {
                BodyDamageAttachment bodyCap = AttachmentUtil.getBodyDamageAttachment((Player)serverPlayer);
                UpdateBodyDamagePayload.sendToPlayer(serverPlayer, bodyCap.writeNBT());
            }
            if (Config.Baked.healthOverhaulEnabled) {
                HealthAttachment healthCap = AttachmentUtil.getHealthAttachment((Player)serverPlayer);
                UpdateHeartsPayload.sendToPlayer(serverPlayer, healthCap.writeNBT());
            }
        }
    }

    @SubscribeEvent
    public static void onLevelLoad(LevelEvent.Load event) {
        LevelData levelData;
        if (!event.getLevel().isClientSide() && (levelData = event.getLevel().getLevelData()) instanceof PrimaryLevelData) {
            PrimaryLevelData primaryLevelData = (PrimaryLevelData)levelData;
            ((GameRules.BooleanValue)primaryLevelData.getGameRules().getRule(GameRules.RULE_NATURAL_REGENERATION)).set(Config.Baked.naturalRegenerationEnabled, event.getLevel().getServer());
        }
    }

    @SubscribeEvent
    public static void onDataPackSyncEvent(OnDatapackSyncEvent event) {
        ServerPlayer player = event.getPlayer();
        ThirstBlockListener.sendDataToClient(player);
        ThirstConsumableListener.sendDataToClient(player);
        TemperatureBiomeListener.sendDataToClient(player);
        TemperatureBlockListener.sendDataToClient(player);
        TemperatureConsumableListener.sendDataToClient(player);
        TemperatureDimensionListener.sendDataToClient(player);
        TemperatureFuelItemListener.sendDataToClient(player);
        TemperatureItemListener.sendDataToClient(player);
        TemperatureMountListener.sendDataToClient(player);
        TemperatureOriginListener.sendDataToClient(player);
        BodyDamageHealingConsumableListener.sendDataToClient(player);
        BodyPartsDamageSourceListener.sendDataToClient(player);
        BodyPartResistanceItemListener.sendDataToClient(player);
    }

    @SubscribeEvent
    public static void onPlayerTick(PlayerTickEvent.Post event) {
        HealthAttachment healthCap;
        boolean isStart;
        Player player = event.getEntity();
        if (player.level().isClientSide || !(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        Level level = player.level();
        boolean bl = isStart = player.tickCount < 20;
        if (Config.Baked.temperatureEnabled) {
            TemperatureAttachment tempCap = AttachmentUtil.getTempAttachment(player);
            tempCap.tickUpdate(player, level, isStart);
            if (tempCap.isDirty()) {
                UpdateTemperaturesPayload.sendToPlayer(serverPlayer, tempCap.writeNBT());
                tempCap.setClean();
            }
        }
        if (Config.Baked.thirstEnabled && CommonForgeEvents.shouldApplyThirst(player)) {
            ThirstAttachment thirstCap = AttachmentUtil.getThirstAttachment(player);
            thirstCap.tickUpdate(player, level, isStart);
            if (thirstCap.isDirty()) {
                UpdateThirstPayload.sendToPlayer(serverPlayer, thirstCap.writeNBT());
                thirstCap.setClean();
            }
        }
        if (Config.Baked.wetnessEnabled) {
            WetnessAttachment wetnessCap = AttachmentUtil.getWetnessAttachment(player);
            wetnessCap.tickUpdate(player, level, isStart);
            if (wetnessCap.isDirty()) {
                UpdateWetnessPayload.sendToPlayer(serverPlayer, wetnessCap.writeNBT());
                wetnessCap.setClean();
            }
        }
        if (Config.Baked.temperatureEnabled) {
            AttachmentUtil.getFoodAttachment(player).tickUpdate(player, level, isStart);
        }
        if (Config.Baked.localizedBodyDamageEnabled) {
            BodyDamageAttachment bodyCap = AttachmentUtil.getBodyDamageAttachment(player);
            bodyCap.tickUpdate(player, level, isStart);
            if (bodyCap.isDirty()) {
                UpdateBodyDamagePayload.sendToPlayer(serverPlayer, bodyCap.writeNBT());
                bodyCap.setClean();
            }
        }
        if (Config.Baked.healthOverhaulEnabled && (healthCap = AttachmentUtil.getHealthAttachment(player)).isDirty()) {
            UpdateHeartsPayload.sendToPlayer(serverPlayer, healthCap.writeNBT());
            healthCap.setClean();
        }
    }

    private static boolean shouldApplyThirst(Player player) {
        return !player.isCreative() && !player.isSpectator() && Config.Baked.thirstEnabled && ThirstUtil.isThirstActive(player);
    }

    private static boolean shouldApplyLocalizedBodyDamage(Player player) {
        return !player.isCreative() && !player.isSpectator() && Config.Baked.localizedBodyDamageEnabled;
    }

    private static boolean shouldApplyHealthOverhaul(Player player) {
        return !player.isCreative() && !player.isSpectator() && Config.Baked.healthOverhaulEnabled;
    }

    public static void playerDrinkEffect(Player player) {
        player.swing(InteractionHand.MAIN_HAND);
        player.playSound(SoundEvents.GENERIC_DRINK, 1.0f, 1.0f);
    }
}

