/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarysurvivaloverhaul.common.integration.curios;

import java.lang.reflect.Constructor;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.NonNullList;
import net.minecraft.util.Tuple;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.ICancellableEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.common.NeoForge;
import sfiomn.legendarysurvivaloverhaul.LegendarySurvivalOverhaul;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;

public class CuriosUtil {
    public static boolean isThermometerEquipped = false;

    public static boolean isCurioItemEquipped(Player player, Item item) {
        if (LegendarySurvivalOverhaul.curiosLoaded) {
            Optional curiosInventory = CuriosApi.getCuriosInventory((LivingEntity)player);
            return curiosInventory.map(handler -> handler.isEquipped(item)).orElse(false);
        }
        return player.getItemInHand(InteractionHand.MAIN_HAND).is(item) || player.getItemInHand(InteractionHand.OFF_HAND).is(item);
    }

    public static boolean isCuriosItem(ItemStack stack) {
        if (!LegendarySurvivalOverhaul.curiosLoaded) {
            return false;
        }
        boolean isClient = FMLEnvironment.dist == Dist.CLIENT;
        return !CuriosApi.getItemStackSlots((ItemStack)stack, (boolean)isClient).isEmpty();
    }

    public static boolean equipCurio(Player player, ItemStack stack, InteractionHand hand) {
        if (!LegendarySurvivalOverhaul.curiosLoaded || stack.isEmpty()) {
            return false;
        }
        Optional curiosInventoryOpt = CuriosApi.getCuriosInventory((LivingEntity)player);
        if (curiosInventoryOpt.isEmpty()) {
            return false;
        }
        ICuriosItemHandler curiosInventory = (ICuriosItemHandler)curiosInventoryOpt.get();
        Map curios = curiosInventory.getCurios();
        Tuple firstSlot = null;
        for (Map.Entry entry : curios.entrySet()) {
            String id = (String)entry.getKey();
            ICurioStacksHandler handler = (ICurioStacksHandler)entry.getValue();
            IDynamicStackHandler slots = handler.getStacks();
            NonNullList renderStates = handler.getRenders();
            for (int ix = 0; ix < slots.getSlots(); ++ix) {
                SlotContext slotContext = new SlotContext(id, (LivingEntity)player, ix, false, renderStates.size() > ix && (Boolean)renderStates.get(ix) != false);
                if (!slots.isItemValid(ix, stack)) continue;
                ItemStack present = slots.getStackInSlot(ix);
                if (present.isEmpty()) {
                    slots.setStackInSlot(ix, stack.copy());
                    if (!player.isCreative()) {
                        stack.shrink(stack.getCount());
                    }
                    return true;
                }
                if (firstSlot != null || !CuriosUtil.canUnequipViaCuriosEvent(present, slotContext) || slots.extractItem(ix, stack.getMaxStackSize(), true).getCount() != stack.getCount()) continue;
                firstSlot = new Tuple((Object)slots, (Object)slotContext);
            }
        }
        if (firstSlot != null) {
            IDynamicStackHandler targetStacks = (IDynamicStackHandler)firstSlot.getA();
            SlotContext slotContext = (SlotContext)firstSlot.getB();
            int i = slotContext.index();
            ItemStack present = targetStacks.getStackInSlot(i);
            targetStacks.setStackInSlot(i, stack.copy());
            if (!player.isCreative()) {
                player.setItemInHand(hand, present.copy());
            }
            return true;
        }
        return false;
    }

    private static boolean canUnequipViaCuriosEvent(ItemStack present, SlotContext slotContext) {
        try {
            Class<?> evtClass = Class.forName("top.theillusivec4.curios.api.event.CurioUnequipEvent");
            Constructor<?> ctor = evtClass.getConstructor(ItemStack.class, SlotContext.class);
            Object evt = ctor.newInstance(present, slotContext);
            Event posted = NeoForge.EVENT_BUS.post((Event)evt);
            if (posted instanceof ICancellableEvent) {
                ICancellableEvent c = (ICancellableEvent)posted;
                return !c.isCanceled();
            }
            return true;
        }
        catch (Throwable ignored) {
            return true;
        }
    }
}

