/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarysurvivaloverhaul.common.integration.eclipticseasons;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;

public final class EclipticSeasonsCompat {
    private static final String API_CLASS = "com.teamtea.eclipticseasons.api.EclipticSeasonsApi";

    private EclipticSeasonsCompat() {
    }

    private static Object apiInstance() throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Class<?> api = Class.forName(API_CLASS);
        Method getInstance = api.getMethod("getInstance", new Class[0]);
        return getInstance.invoke(null, new Object[0]);
    }

    public static boolean isSeasonEnabled(Level level) {
        try {
            Boolean b;
            Object api = EclipticSeasonsCompat.apiInstance();
            Method m = api.getClass().getMethod("isSeasonEnabled", Level.class);
            Object res = m.invoke(api, level);
            return res instanceof Boolean && (b = (Boolean)res) != false;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static Object getSolarTerm(Level level) {
        try {
            Object api = EclipticSeasonsCompat.apiInstance();
            Method m = api.getClass().getMethod("getSolarTerm", Level.class);
            return m.invoke(api, level);
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static boolean isSolarTermNone(Level level) {
        Object term = EclipticSeasonsCompat.getSolarTerm(level);
        if (term == null) {
            return true;
        }
        try {
            Method name = term.getClass().getMethod("name", new Class[0]);
            Object n = name.invoke(term, new Object[0]);
            return "NONE".equals(String.valueOf(n));
        }
        catch (Throwable t) {
            return true;
        }
    }

    public static int getSolarTermDayTime(Level level) {
        Object term = EclipticSeasonsCompat.getSolarTerm(level);
        if (term == null) {
            return 12000;
        }
        try {
            int n;
            Method m = term.getClass().getMethod("getDayTime", new Class[0]);
            Object res = m.invoke(term, new Object[0]);
            if (res instanceof Number) {
                Number n2 = (Number)res;
                n = n2.intValue();
            } else {
                n = 12000;
            }
            return n;
        }
        catch (Throwable t) {
            return 12000;
        }
    }

    public static int getLastingDaysOfEachTerm(Level level) {
        try {
            int n;
            Object api = EclipticSeasonsCompat.apiInstance();
            Method m = api.getClass().getMethod("getLastingDaysOfEachTerm", Level.class);
            Object res = m.invoke(api, level);
            if (res instanceof Number) {
                Number n2 = (Number)res;
                n = n2.intValue();
            } else {
                n = 0;
            }
            return n;
        }
        catch (Throwable t) {
            return 0;
        }
    }

    public static double getSolarDays(Level level) {
        try {
            double d;
            Object api = EclipticSeasonsCompat.apiInstance();
            Method m = api.getClass().getMethod("getSolarDays", Level.class);
            Object res = m.invoke(api, level);
            if (res instanceof Number) {
                Number n = (Number)res;
                d = n.doubleValue();
            } else {
                d = 0.0;
            }
            return d;
        }
        catch (Throwable t) {
            return 0.0;
        }
    }

    public static float getTimeInTerm(Level level) {
        try {
            float f;
            Object api = EclipticSeasonsCompat.apiInstance();
            Method m = api.getClass().getMethod("getTimeInTerm", Level.class);
            Object res = m.invoke(api, level);
            if (res instanceof Number) {
                Number n = (Number)res;
                f = n.floatValue();
            } else {
                f = 0.0f;
            }
            return f;
        }
        catch (Throwable t) {
            return 0.0f;
        }
    }

    public static Biome.Precipitation getCurrentPrecipitationAt(Level level, BlockPos pos) {
        try {
            Object api = EclipticSeasonsCompat.apiInstance();
            Method m = api.getClass().getMethod("getCurrentPrecipitationAt", Level.class, BlockPos.class);
            Object res = m.invoke(api, level, pos);
            return (Biome.Precipitation)res;
        }
        catch (Throwable t) {
            return Biome.Precipitation.NONE;
        }
    }

    public static int getSolarTermOrdinal(Level level) {
        Object term = EclipticSeasonsCompat.getSolarTerm(level);
        if (term == null) {
            return 0;
        }
        try {
            int n;
            Method m = term.getClass().getMethod("ordinal", new Class[0]);
            Object res = m.invoke(term, new Object[0]);
            if (res instanceof Number) {
                Number n2 = (Number)res;
                n = n2.intValue();
            } else {
                n = 0;
            }
            return n;
        }
        catch (Throwable t) {
            return 0;
        }
    }

    public static Component getSolarTermTranslation(Level level) {
        Object term = EclipticSeasonsCompat.getSolarTerm(level);
        if (term == null) {
            return Component.empty();
        }
        try {
            Method m = term.getClass().getMethod("getTranslation", new Class[0]);
            Object res = m.invoke(term, new Object[0]);
            return (Component)res;
        }
        catch (Throwable t) {
            return Component.empty();
        }
    }

    public static Component getSeasonTranslation(Level level) {
        Object term = EclipticSeasonsCompat.getSolarTerm(level);
        if (term == null) {
            return Component.empty();
        }
        try {
            Method getSeason = term.getClass().getMethod("getSeason", new Class[0]);
            Object season = getSeason.invoke(term, new Object[0]);
            if (season == null) {
                return Component.empty();
            }
            Method getTranslation = season.getClass().getMethod("getTranslation", new Class[0]);
            Object res = getTranslation.invoke(season, new Object[0]);
            return (Component)res;
        }
        catch (Throwable t) {
            return Component.empty();
        }
    }
}

