/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarysurvivaloverhaul.common.integration.eclipticseasons;

import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import sfiomn.legendarysurvivaloverhaul.LegendarySurvivalOverhaul;
import sfiomn.legendarysurvivaloverhaul.api.temperature.ModifierBase;
import sfiomn.legendarysurvivaloverhaul.common.integration.eclipticseasons.EclipticSeasonsCompat;
import sfiomn.legendarysurvivaloverhaul.common.integration.eclipticseasons.EclipticSeasonsUtil;
import sfiomn.legendarysurvivaloverhaul.config.Config;

public class EclipticSeasonsModifier
extends ModifierBase {
    @Override
    public float getWorldInfluence(Player player, Level level, BlockPos pos) {
        if (!LegendarySurvivalOverhaul.eclipticSeasonsLoaded || !Config.Baked.eclipticSeasonsEnabled) {
            return 0.0f;
        }
        try {
            return this.getUncaughtWorldInfluence(level, pos);
        }
        catch (Exception e) {
            LegendarySurvivalOverhaul.LOGGER.error("An error has occurred with Ecliptic Seasons compatibility, disabling modifier", (Throwable)e);
            LegendarySurvivalOverhaul.eclipticSeasonsLoaded = false;
            return 0.0f;
        }
    }

    public float getUncaughtWorldInfluence(Level level, BlockPos pos) {
        if (!EclipticSeasonsUtil.hasDimensionSeason(level)) {
            return 0.0f;
        }
        if (EclipticSeasonsCompat.isSolarTermNone(level)) {
            return 0.0f;
        }
        int timeInSubSeason = (int)(EclipticSeasonsCompat.getTimeInTerm(level) * 24000.0f + (float)(level.getLevelData().getDayTime() % 24000L));
        int subSeasonDuration = EclipticSeasonsUtil.getDaysInSolarTerm(level) * 24000;
        int ordinal = EclipticSeasonsCompat.getSolarTermOrdinal(level);
        float value = EclipticSeasonsUtil.getBlendedSeasonModifier(EclipticSeasonsUtil.getSeasonModifier(ordinal - 1), EclipticSeasonsUtil.getSeasonModifier(ordinal), EclipticSeasonsUtil.getSeasonModifier(ordinal + 1), timeInSubSeason, subSeasonDuration);
        double targetUndergroundTemperature = 0.0;
        return this.applyUndergroundEffect(value, level, pos, (float)targetUndergroundTemperature);
    }
}

