/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarysurvivaloverhaul.common.integration.sereneseasons;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import sereneseasons.api.season.ISeasonState;
import sereneseasons.api.season.SeasonHelper;
import sfiomn.legendarysurvivaloverhaul.LegendarySurvivalOverhaul;
import sfiomn.legendarysurvivaloverhaul.api.temperature.ModifierBase;
import sfiomn.legendarysurvivaloverhaul.common.integration.sereneseasons.SereneSeasonsUtil;
import sfiomn.legendarysurvivaloverhaul.config.Config;

public class SereneSeasonsModifier
extends ModifierBase {
    @Override
    public float getWorldInfluence(Player player, Level level, BlockPos pos) {
        if (!LegendarySurvivalOverhaul.sereneSeasonsLoaded) {
            return 0.0f;
        }
        if (!Config.Baked.sereneSeasonsEnabled) {
            return 0.0f;
        }
        try {
            return this.getUncaughtWorldInfluence(level, pos);
        }
        catch (Exception e) {
            LegendarySurvivalOverhaul.LOGGER.error("An error has occurred with Serene Seasons compatibility, disabling modifier", (Throwable)e);
            LegendarySurvivalOverhaul.sereneSeasonsLoaded = false;
            return 0.0f;
        }
    }

    public float getUncaughtWorldInfluence(Level level, BlockPos pos) {
        ISeasonState seasonState = SeasonHelper.getSeasonState((Level)level);
        if (seasonState == null || !SereneSeasonsUtil.hasSeasons(level)) {
            return 0.0f;
        }
        Vec3i[] posOffsets = Config.Baked.ssTropicalSeasonsEnabled ? new Vec3i[]{new Vec3i(0, 0, 0), new Vec3i(10, 0, 0), new Vec3i(-10, 0, 0), new Vec3i(0, 0, 10), new Vec3i(0, 0, -10)} : new Vec3i[]{new Vec3i(0, 0, 0)};
        float value = 0.0f;
        int validSpot = posOffsets.length;
        double targetUndergroundTemperature = 0.0;
        block22: for (Vec3i offset : posOffsets) {
            int timeInSubSeason;
            SereneSeasonsUtil.SeasonType seasonType = SereneSeasonsUtil.getSeasonType((Holder<Biome>)level.getBiome(pos.offset(offset)));
            if (seasonType == SereneSeasonsUtil.SeasonType.NO_SEASON) {
                --validSpot;
                continue;
            }
            if (seasonType != SereneSeasonsUtil.SeasonType.TROPICAL_SEASON) {
                timeInSubSeason = seasonState.getSeasonCycleTicks() % seasonState.getSubSeasonDuration();
                targetUndergroundTemperature = SereneSeasonsUtil.averageSeasonTemperature;
                switch (seasonState.getSubSeason()) {
                    case EARLY_SPRING: {
                        value += SereneSeasonsUtil.getSeasonModifier(Config.Baked.ssLateWinterModifier, Config.Baked.ssEarlySpringModifier, Config.Baked.ssMidSpringModifier, timeInSubSeason, seasonState.getSubSeasonDuration());
                        break;
                    }
                    case MID_SPRING: {
                        value += SereneSeasonsUtil.getSeasonModifier(Config.Baked.ssEarlySpringModifier, Config.Baked.ssMidSpringModifier, Config.Baked.ssLateSpringModifier, timeInSubSeason, seasonState.getSubSeasonDuration());
                        break;
                    }
                    case LATE_SPRING: {
                        value += SereneSeasonsUtil.getSeasonModifier(Config.Baked.ssMidSpringModifier, Config.Baked.ssLateSpringModifier, Config.Baked.ssEarlySummerModifier, timeInSubSeason, seasonState.getSubSeasonDuration());
                        break;
                    }
                    case EARLY_SUMMER: {
                        value += SereneSeasonsUtil.getSeasonModifier(Config.Baked.ssLateSpringModifier, Config.Baked.ssEarlySummerModifier, Config.Baked.ssMidSummerModifier, timeInSubSeason, seasonState.getSubSeasonDuration());
                        break;
                    }
                    case MID_SUMMER: {
                        value += SereneSeasonsUtil.getSeasonModifier(Config.Baked.ssEarlySummerModifier, Config.Baked.ssMidSummerModifier, Config.Baked.ssLateSummerModifier, timeInSubSeason, seasonState.getSubSeasonDuration());
                        break;
                    }
                    case LATE_SUMMER: {
                        value += SereneSeasonsUtil.getSeasonModifier(Config.Baked.ssMidSummerModifier, Config.Baked.ssLateSummerModifier, Config.Baked.ssEarlyAutumnModifier, timeInSubSeason, seasonState.getSubSeasonDuration());
                        break;
                    }
                    case EARLY_AUTUMN: {
                        value += SereneSeasonsUtil.getSeasonModifier(Config.Baked.ssLateSummerModifier, Config.Baked.ssEarlyAutumnModifier, Config.Baked.ssMidAutumnModifier, timeInSubSeason, seasonState.getSubSeasonDuration());
                        break;
                    }
                    case MID_AUTUMN: {
                        value += SereneSeasonsUtil.getSeasonModifier(Config.Baked.ssEarlyAutumnModifier, Config.Baked.ssMidAutumnModifier, Config.Baked.ssLateAutumnModifier, timeInSubSeason, seasonState.getSubSeasonDuration());
                        break;
                    }
                    case LATE_AUTUMN: {
                        value += SereneSeasonsUtil.getSeasonModifier(Config.Baked.ssMidAutumnModifier, Config.Baked.ssLateAutumnModifier, Config.Baked.ssEarlyWinterModifier, timeInSubSeason, seasonState.getSubSeasonDuration());
                        break;
                    }
                    case EARLY_WINTER: {
                        value += SereneSeasonsUtil.getSeasonModifier(Config.Baked.ssLateAutumnModifier, Config.Baked.ssEarlyWinterModifier, Config.Baked.ssMidWinterModifier, timeInSubSeason, seasonState.getSubSeasonDuration());
                        break;
                    }
                    case MID_WINTER: {
                        value += SereneSeasonsUtil.getSeasonModifier(Config.Baked.ssEarlyWinterModifier, Config.Baked.ssMidWinterModifier, Config.Baked.ssLateWinterModifier, timeInSubSeason, seasonState.getSubSeasonDuration());
                        break;
                    }
                    case LATE_WINTER: {
                        value += SereneSeasonsUtil.getSeasonModifier(Config.Baked.ssMidWinterModifier, Config.Baked.ssLateWinterModifier, Config.Baked.ssEarlySpringModifier, timeInSubSeason, seasonState.getSubSeasonDuration());
                    }
                }
                continue;
            }
            timeInSubSeason = (seasonState.getSeasonCycleTicks() + seasonState.getSubSeasonDuration()) % (seasonState.getSubSeasonDuration() * 2);
            targetUndergroundTemperature = SereneSeasonsUtil.averageTropicalSeasonTemperature;
            switch (seasonState.getTropicalSeason()) {
                case EARLY_DRY: {
                    value += SereneSeasonsUtil.getSeasonModifier(Config.Baked.ssLateWetSeasonModifier, Config.Baked.earlyDrySeasonModifier, Config.Baked.midDrySeasonModifier, timeInSubSeason, seasonState.getSubSeasonDuration() * 2);
                    continue block22;
                }
                case MID_DRY: {
                    value += SereneSeasonsUtil.getSeasonModifier(Config.Baked.earlyDrySeasonModifier, Config.Baked.midDrySeasonModifier, Config.Baked.lateDrySeasonModifier, timeInSubSeason, seasonState.getSubSeasonDuration() * 2);
                    continue block22;
                }
                case LATE_DRY: {
                    value += SereneSeasonsUtil.getSeasonModifier(Config.Baked.midDrySeasonModifier, Config.Baked.lateDrySeasonModifier, Config.Baked.ssEarlyWetSeasonModifier, timeInSubSeason, seasonState.getSubSeasonDuration() * 2);
                    continue block22;
                }
                case EARLY_WET: {
                    value += SereneSeasonsUtil.getSeasonModifier(Config.Baked.lateDrySeasonModifier, Config.Baked.ssEarlyWetSeasonModifier, Config.Baked.ssMidWetSeasonModifier, timeInSubSeason, seasonState.getSubSeasonDuration() * 2);
                    continue block22;
                }
                case MID_WET: {
                    value += SereneSeasonsUtil.getSeasonModifier(Config.Baked.ssEarlyWetSeasonModifier, Config.Baked.ssMidWetSeasonModifier, Config.Baked.ssLateWetSeasonModifier, timeInSubSeason, seasonState.getSubSeasonDuration() * 2);
                    continue block22;
                }
                case LATE_WET: {
                    value += SereneSeasonsUtil.getSeasonModifier(Config.Baked.ssMidWetSeasonModifier, Config.Baked.ssLateWetSeasonModifier, Config.Baked.earlyDrySeasonModifier, timeInSubSeason, seasonState.getSubSeasonDuration() * 2);
                }
            }
        }
        value = validSpot == 0 ? 0.0f : value / (float)validSpot;
        return this.applyUndergroundEffect(value, level, pos, (float)targetUndergroundTemperature);
    }
}

