/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarysurvivaloverhaul.common.integration.sereneseasons;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import sereneseasons.api.season.ISeasonState;
import sereneseasons.api.season.Season;
import sereneseasons.api.season.SeasonHelper;
import sereneseasons.init.ModConfig;
import sereneseasons.init.ModFertility;
import sereneseasons.init.ModTags;
import sereneseasons.season.SeasonTime;
import sfiomn.legendarysurvivaloverhaul.config.Config;
import sfiomn.legendarysurvivaloverhaul.util.MathUtil;

public class SereneSeasonsUtil {
    public static double averageSeasonTemperature;
    public static double averageTropicalSeasonTemperature;

    public static Component seasonTooltip(BlockPos blockPos, Level level) {
        if (!SereneSeasonsUtil.hasSeasons(level)) {
            return Component.translatable((String)"message.legendarysurvivaloverhaul.sereneseasons.no_season_dimension");
        }
        SeasonType seasonType = SereneSeasonsUtil.getSeasonType((Holder<Biome>)level.getBiome(blockPos));
        ISeasonState season = SeasonHelper.getSeasonState((Level)level);
        int subSeasonDuration = (int)((double)season.getSubSeasonDuration() / (double)season.getDayDuration());
        StringBuilder subSeasonName = new StringBuilder();
        if (seasonType == SeasonType.NO_SEASON) {
            return Component.translatable((String)"message.legendarysurvivaloverhaul.sereneseasons.no_season_info");
        }
        if (seasonType == SeasonType.TROPICAL_SEASON) {
            for (String word : season.getTropicalSeason().toString().split("_", 0)) {
                subSeasonName.append(word.charAt(0)).append(word.substring(1).toLowerCase()).append(" ");
            }
            return Component.translatable((String)"message.legendarysurvivaloverhaul.sereneseasons.season_info", (Object[])new Object[]{subSeasonName.toString(), (season.getDay() + subSeasonDuration) % (subSeasonDuration * 2) + 1, subSeasonDuration * 2});
        }
        for (String word : season.getSubSeason().toString().split("_", 0)) {
            subSeasonName.append(word.charAt(0)).append(word.substring(1).toLowerCase()).append(" ");
        }
        return Component.translatable((String)"message.legendarysurvivaloverhaul.sereneseasons.season_info", (Object[])new Object[]{subSeasonName.toString(), season.getDay() % subSeasonDuration + 1, subSeasonDuration});
    }

    public static SeasonType getSeasonType(Holder<Biome> biome) {
        if (Config.Baked.ssTropicalSeasonsEnabled && biome.is(ModTags.Biomes.TROPICAL_BIOMES)) {
            return SeasonType.TROPICAL_SEASON;
        }
        if (!Config.Baked.ssDefaultSeasonEnabled && biome.is(ModTags.Biomes.BLACKLISTED_BIOMES)) {
            return SeasonType.NO_SEASON;
        }
        return SeasonType.NORMAL_SEASON;
    }

    public static boolean isGlassAboveBlock(Level world, BlockPos cropPos) {
        for (int i = 0; i < 16; ++i) {
            if (!world.getBlockState(cropPos.offset(0, i + 1, 0)).is(ModTags.Blocks.GREENHOUSE_GLASS)) continue;
            return true;
        }
        return false;
    }

    public static boolean plantCanGrow(Level level, BlockPos pos, BlockState plant) {
        ResourceLocation resourceLocation = BuiltInRegistries.BLOCK.getKey((Object)plant.getBlock());
        if (resourceLocation != null) {
            boolean isFertile = ModFertility.isCropFertile((String)resourceLocation.getPath(), (Level)level, (BlockPos)pos);
            if (ModConfig.fertility.seasonalCrops && ModFertility.isCrop((BlockState)plant) && !isFertile && !SereneSeasonsUtil.isGlassAboveBlock(level, pos)) {
                return ModConfig.fertility.outOfSeasonCropBehavior != 1 && ModConfig.fertility.outOfSeasonCropBehavior != 2;
            }
        }
        return true;
    }

    public static double getTimeInSeasonCycle(Level level) {
        int seasonCycleTicks = SeasonHelper.getSeasonState((Level)level).getSeasonCycleTicks();
        return (float)seasonCycleTicks / (float)SeasonTime.ZERO.getCycleDuration();
    }

    public static boolean hasSeasons(Level level) {
        return ModConfig.seasons.isDimensionWhitelisted(level.dimension());
    }

    public static float getSeasonModifier(double previousSeasonModifier, double currentSeasonModifier, double nextSeasonModifier, int time, int subSeasonDuration) {
        return time < subSeasonDuration / 2 ? SereneSeasonsUtil.calculateSinusoidalBetweenSeasons(previousSeasonModifier, currentSeasonModifier, time + subSeasonDuration / 2, subSeasonDuration) : SereneSeasonsUtil.calculateSinusoidalBetweenSeasons(currentSeasonModifier, nextSeasonModifier, time - subSeasonDuration / 2, subSeasonDuration);
    }

    public static float calculateSinusoidalBetweenSeasons(double previousSeasonModifier, double nextSeasonModifier, int time, int subSeasonDuration) {
        double tempDiff = nextSeasonModifier - previousSeasonModifier;
        double seasonModifier = (Math.sin((double)time * Math.PI / (double)subSeasonDuration - 1.5707963267948966) + 1.0) * (tempDiff / 2.0) + previousSeasonModifier;
        return MathUtil.round((float)seasonModifier, 2);
    }

    public static void initAverageTemperatures() {
        averageSeasonTemperature += Config.Baked.ssEarlyAutumnModifier;
        averageSeasonTemperature += Config.Baked.ssEarlySpringModifier;
        averageSeasonTemperature += Config.Baked.ssEarlySummerModifier;
        averageSeasonTemperature += Config.Baked.ssEarlyWinterModifier;
        averageSeasonTemperature += Config.Baked.ssMidAutumnModifier;
        averageSeasonTemperature += Config.Baked.ssMidSpringModifier;
        averageSeasonTemperature += Config.Baked.ssMidSummerModifier;
        averageSeasonTemperature += Config.Baked.ssMidWinterModifier;
        averageSeasonTemperature += Config.Baked.ssLateAutumnModifier;
        averageSeasonTemperature += Config.Baked.ssLateSpringModifier;
        averageSeasonTemperature += Config.Baked.ssLateSummerModifier;
        averageSeasonTemperature += Config.Baked.ssLateWinterModifier;
        averageSeasonTemperature /= 12.0;
        averageTropicalSeasonTemperature += Config.Baked.ssEarlyWetSeasonModifier;
        averageTropicalSeasonTemperature += Config.Baked.earlyDrySeasonModifier;
        averageTropicalSeasonTemperature += Config.Baked.ssMidWetSeasonModifier;
        averageTropicalSeasonTemperature += Config.Baked.midDrySeasonModifier;
        averageTropicalSeasonTemperature += Config.Baked.ssLateWetSeasonModifier;
        averageTropicalSeasonTemperature += Config.Baked.lateDrySeasonModifier;
        averageTropicalSeasonTemperature /= 6.0;
    }

    public static enum SeasonType {
        NO_SEASON(0.9f),
        TROPICAL_SEASON(0.1f),
        NORMAL_SEASON(0.0f);

        public final float propertyValue;

        private SeasonType(float propertyValue) {
            this.propertyValue = propertyValue;
        }
    }

    public static enum TropicalSeason {
        DRY(Season.TropicalSeason.EARLY_DRY, Season.TropicalSeason.MID_DRY, Season.TropicalSeason.LATE_DRY),
        WET(Season.TropicalSeason.EARLY_WET, Season.TropicalSeason.MID_WET, Season.TropicalSeason.LATE_WET);

        public final Season.TropicalSeason earlyTropicalSeason;
        public final Season.TropicalSeason midTropicalSeason;
        public final Season.TropicalSeason lateTropicalSeason;

        private TropicalSeason(Season.TropicalSeason earlyTropicalSeason, Season.TropicalSeason midTropicalSeason, Season.TropicalSeason lateTropicalSeason) {
            this.earlyTropicalSeason = earlyTropicalSeason;
            this.midTropicalSeason = midTropicalSeason;
            this.lateTropicalSeason = lateTropicalSeason;
        }

        public static TropicalSeason getTropicalSeason(Season.TropicalSeason subTropicalSeason) {
            for (TropicalSeason season : TropicalSeason.values()) {
                if (subTropicalSeason != season.earlyTropicalSeason && subTropicalSeason != season.midTropicalSeason && subTropicalSeason != season.lateTropicalSeason) continue;
                return season;
            }
            return null;
        }
    }
}

