/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarysurvivaloverhaul.common.integration.terrafirmacraft;

import net.dries007.tfc.util.climate.Climate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import sfiomn.legendarysurvivaloverhaul.LegendarySurvivalOverhaul;
import sfiomn.legendarysurvivaloverhaul.api.temperature.ModifierBase;
import sfiomn.legendarysurvivaloverhaul.config.Config;

public class TerraFirmaCraftModifier
extends ModifierBase {
    @Override
    public float getWorldInfluence(Player player, Level level, BlockPos pos) {
        if (!LegendarySurvivalOverhaul.terraFirmaCraftLoaded) {
            return 0.0f;
        }
        if (Config.Baked.tfcTemperatureMultiplier == 0.0) {
            return 0.0f;
        }
        try {
            return this.getUncaughtWorldInfluence(level, pos);
        }
        catch (Exception e) {
            LegendarySurvivalOverhaul.LOGGER.error("An error has occurred with TerraFirmaCraft compatibility, disabling integration", (Throwable)e);
            LegendarySurvivalOverhaul.terraFirmaCraftLoaded = false;
            return 0.0f;
        }
    }

    public float getUncaughtWorldInfluence(Level level, BlockPos pos) {
        Vec3i[] posOffsets = new Vec3i[]{new Vec3i(0, 0, 0), new Vec3i(10, 0, 0), new Vec3i(-10, 0, 0), new Vec3i(0, 0, 10), new Vec3i(0, 0, -10)};
        float value = 0.0f;
        for (Vec3i offset : posOffsets) {
            value += (float)((double)Climate.getTemperature((Level)level, (BlockPos)pos.offset(offset)) * Config.Baked.tfcTemperatureMultiplier);
        }
        return value /= (float)posOffsets.length;
    }
}

