/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarysurvivaloverhaul.common.items;

import com.mojang.blaze3d.platform.InputConstants;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import sfiomn.legendarysurvivaloverhaul.LegendarySurvivalOverhaul;
import sfiomn.legendarysurvivaloverhaul.common.attachments.temperature.TemperatureItemAttachment;
import sfiomn.legendarysurvivaloverhaul.config.Config;
import sfiomn.legendarysurvivaloverhaul.registry.KeyMappingRegistry;
import sfiomn.legendarysurvivaloverhaul.util.AttachmentUtil;
import sfiomn.legendarysurvivaloverhaul.util.WorldUtil;

public class ThermometerItem
extends Item {
    public ThermometerItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        if (level.isClientSide()) {
            TemperatureItemAttachment tempCap = AttachmentUtil.getTempItemAttachment(player.getMainHandItem());
            float temperature = tempCap.getWorldTemperatureLevel();
            MutableComponent temperatureComponent = Config.Baked.renderTemperatureInFahrenheit ? Component.literal((String)(WorldUtil.toFahrenheit(temperature) + "\u00b0F")) : Component.literal((String)(temperature + "\u00b0C"));
            player.displayClientMessage((Component)temperatureComponent, true);
        }
        return super.use(level, player, hand);
    }

    public void appendHoverText(ItemStack stack, @Nullable Item.TooltipContext level, @NotNull List<Component> tooltipComponents, @NotNull TooltipFlag isAdvanced) {
        super.appendHoverText(stack, level, tooltipComponents, isAdvanced);
        ArrayList<MutableComponent> text = new ArrayList<MutableComponent>();
        if (InputConstants.isKeyDown((long)Minecraft.getInstance().getWindow().getWindow(), (int)KeyMappingRegistry.showAddedDesc.getKey().getValue())) {
            text.add(Component.translatable((String)"tooltip.legendarysurvivaloverhaul.thermometer.description"));
            if (LegendarySurvivalOverhaul.curiosLoaded) {
                text.add(Component.translatable((String)"tooltip.legendarysurvivaloverhaul.thermometer.bauble_description"));
            }
        } else {
            text.add(Component.literal((String)(String.valueOf(ChatFormatting.GRAY) + I18n.get((String)"tooltip.legendarysurvivaloverhaul.added_desc.activate", (Object[])new Object[]{ChatFormatting.LIGHT_PURPLE, I18n.get((String)KeyMappingRegistry.showAddedDesc.getTranslatedKeyMessage().getString(), (Object[])new Object[0]), ChatFormatting.GRAY}))));
        }
        tooltipComponents.addAll(text);
    }
}

