/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarysurvivaloverhaul.common.items.drink;

import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import sfiomn.legendarysurvivaloverhaul.common.attachments.thirst.ThirstAttachment;
import sfiomn.legendarysurvivaloverhaul.config.Config;
import sfiomn.legendarysurvivaloverhaul.util.AttachmentUtil;

public class DrinkItem
extends Item {
    public DrinkItem(Item.Properties properties) {
        super(properties);
    }

    public void runSecondaryEffect(Player player, ItemStack stack) {
    }

    @NotNull
    public UseAnim getUseAnimation(@NotNull ItemStack stack) {
        return UseAnim.DRINK;
    }

    public int getUseDuration(@NotNull ItemStack stack, LivingEntity entity) {
        return 16;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!Config.Baked.thirstEnabled) {
            player.startUsingItem(hand);
            return InteractionResultHolder.success((Object)stack);
        }
        ThirstAttachment capability = AttachmentUtil.getThirstAttachment(player);
        if (!capability.isHydrationLevelAtMax()) {
            player.startUsingItem(hand);
            return InteractionResultHolder.success((Object)stack);
        }
        return InteractionResultHolder.fail((Object)stack);
    }

    @NotNull
    public ItemStack finishUsingItem(@NotNull ItemStack stack, Level level, @NotNull LivingEntity entity) {
        if (level.isClientSide || !(entity instanceof Player)) {
            return stack;
        }
        Player player = (Player)entity;
        this.runSecondaryEffect(player, stack);
        stack.shrink(1);
        return stack;
    }

    public boolean isEnchantable(ItemStack stack) {
        return false;
    }
}

