/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarysurvivaloverhaul.common.items.heal;

import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import sfiomn.legendarysurvivaloverhaul.api.bodydamage.BodyDamageUtil;
import sfiomn.legendarysurvivaloverhaul.api.bodydamage.BodyPartEnum;
import sfiomn.legendarysurvivaloverhaul.api.data.json.JsonHealingConsumable;
import sfiomn.legendarysurvivaloverhaul.api.data.manager.BodyDamageDataManager;
import sfiomn.legendarysurvivaloverhaul.common.attachments.bodydamage.BodyDamageAttachment;
import sfiomn.legendarysurvivaloverhaul.config.Config;
import sfiomn.legendarysurvivaloverhaul.registry.MobEffectRegistry;
import sfiomn.legendarysurvivaloverhaul.util.AttachmentUtil;

public class BodyHealingItem
extends Item {
    public BodyHealingItem(Item.Properties properties) {
        super(properties);
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.BOW;
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 20;
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!Config.Baked.localizedBodyDamageEnabled) {
            player.startUsingItem(hand);
            return InteractionResultHolder.success((Object)stack);
        }
        ResourceLocation registryName = BuiltInRegistries.ITEM.getKey((Object)this);
        JsonHealingConsumable jsonConsumableHeal = BodyDamageDataManager.getHealingItem(registryName);
        if (jsonConsumableHeal != null) {
            BodyDamageAttachment capability = AttachmentUtil.getBodyDamageAttachment(player);
            if (jsonConsumableHeal.healingCharges == 0) {
                for (BodyPartEnum bodyPart : BodyPartEnum.values()) {
                    if (!(capability.getBodyPartDamage(bodyPart) > 0.0f) && !(player.getHealth() < player.getMaxHealth())) continue;
                    player.startUsingItem(hand);
                    return InteractionResultHolder.success((Object)stack);
                }
            } else if (jsonConsumableHeal.healingCharges > 0) {
                player.startUsingItem(hand);
                return InteractionResultHolder.success((Object)stack);
            }
        }
        return InteractionResultHolder.fail((Object)stack);
    }

    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity entity) {
        if (!(entity instanceof Player)) {
            return stack;
        }
        Player player = (Player)entity;
        ResourceLocation registryName = BuiltInRegistries.ITEM.getKey((Object)this);
        JsonHealingConsumable jsonConsumableHeal = BodyDamageDataManager.getHealingItem(registryName);
        if (jsonConsumableHeal == null) {
            return stack;
        }
        if (!Config.Baked.localizedBodyDamageEnabled) {
            if (jsonConsumableHeal.recoveryEffectDuration > 0) {
                player.addEffect(new MobEffectInstance(MobEffectRegistry.RECOVERY, jsonConsumableHeal.recoveryEffectDuration, jsonConsumableHeal.recoveryEffectAmplifier, false, true, true));
            }
            stack.shrink(1);
            return stack;
        }
        BodyDamageUtil.applyConsumableHealing(player, stack, false);
        return stack;
    }

    public boolean isEnchantable(ItemStack stack) {
        return false;
    }
}

