/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarysurvivaloverhaul.common.listeners;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sfiomn.legendarysurvivaloverhaul.LegendarySurvivalOverhaul;
import sfiomn.legendarysurvivaloverhaul.api.data.json.JsonTemperatureResistance;
import sfiomn.legendarysurvivaloverhaul.api.data.manager.ITemperatureOriginManager;
import sfiomn.legendarysurvivaloverhaul.network.payloads.SyncTemperatureOriginsPayload;

public class TemperatureOriginListener
extends SimpleJsonResourceReloadListener
implements ITemperatureOriginManager {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final Map<ResourceLocation, JsonTemperatureResistance> TEMPERATURE_ORIGINS = new HashMap<ResourceLocation, JsonTemperatureResistance>();

    public TemperatureOriginListener() {
        super(GSON, "legendarysurvivaloverhaul/temperature/origins");
    }

    public static void sendDataToClient(@Nullable ServerPlayer player) {
        if (player == null) {
            PacketDistributor.sendToAllPlayers((CustomPacketPayload)new SyncTemperatureOriginsPayload(TEMPERATURE_ORIGINS), (CustomPacketPayload[])new CustomPacketPayload[0]);
        } else {
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new SyncTemperatureOriginsPayload(TEMPERATURE_ORIGINS), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public static void acceptServerTemperatureOrigins(Map<ResourceLocation, JsonTemperatureResistance> temperatureOrigins) {
        TEMPERATURE_ORIGINS.clear();
        TEMPERATURE_ORIGINS.putAll(temperatureOrigins);
    }

    protected void apply(@NotNull Map<ResourceLocation, JsonElement> resourceLocationJsonElementMap, @NotNull ResourceManager resourceManager, @NotNull ProfilerFiller profilerFiller) {
        TEMPERATURE_ORIGINS.clear();
        resourceLocationJsonElementMap.forEach((key, json) -> {
            try {
                DataResult parsedJson = JsonTemperatureResistance.CODEC.parse((DynamicOps)JsonOps.INSTANCE, json);
                JsonTemperatureResistance temperatures = (JsonTemperatureResistance)parsedJson.getOrThrow(err -> new IllegalStateException("Failed parsing temperature origin: " + err));
                if (ModList.get().isLoaded(key.getNamespace())) {
                    TEMPERATURE_ORIGINS.put((ResourceLocation)key, temperatures);
                }
            }
            catch (JsonParseException | IllegalStateException error) {
                LegendarySurvivalOverhaul.LOGGER.error("Failed to parse temperature origin json {}", key, (Object)error);
            }
        });
        LegendarySurvivalOverhaul.LOGGER.info("Loaded {} temperature origins", (Object)TEMPERATURE_ORIGINS.size());
    }

    @Override
    public JsonTemperatureResistance get(ResourceLocation originRegistryName) {
        return TEMPERATURE_ORIGINS.get(originRegistryName);
    }
}

