/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarysurvivaloverhaul.common.loot_modifiers;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.loot.LootModifier;
import sfiomn.legendarysurvivaloverhaul.LegendarySurvivalOverhaul;

public class AdditionalLootTable
extends LootModifier {
    public static final Supplier<MapCodec<AdditionalLootTable>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.mapCodec(instance -> AdditionalLootTable.codecStart((RecordCodecBuilder.Instance)instance).and((App)ResourceLocation.CODEC.fieldOf("lootTable").forGetter(m -> m.lootTable)).and((App)Codec.BOOL.optionalFieldOf("replace", (Object)false).forGetter(m -> m.replace)).apply((Applicative)instance, AdditionalLootTable::new)));
    private final ResourceLocation lootTable;
    private final boolean replace;

    public AdditionalLootTable(LootItemCondition[] conditions, ResourceLocation lootTable, boolean replace) {
        super(conditions);
        this.lootTable = lootTable;
        this.replace = replace;
    }

    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        if (this.replace) {
            generatedLoot.clear();
        }
        ServerLevel level = context.getLevel();
        ResourceKey lootTableKey = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)this.lootTable);
        context.getResolver().get(Registries.LOOT_TABLE, lootTableKey).ifPresent(table -> {
            ((LootTable)table.value()).getRandomItemsRaw(context, LootTable.createStackSplitter((ServerLevel)level, arg_0 -> ((ObjectArrayList)generatedLoot).add(arg_0)));
            LegendarySurvivalOverhaul.LOGGER.debug((Object)lootTableKey);
            LegendarySurvivalOverhaul.LOGGER.debug("gen loot : " + String.valueOf(generatedLoot));
        });
        return generatedLoot;
    }

    public MapCodec<? extends IGlobalLootModifier> codec() {
        return CODEC.get();
    }
}

