/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarysurvivaloverhaul.common.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.BlastingRecipe;
import net.minecraft.world.item.crafting.CookingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import sfiomn.legendarysurvivaloverhaul.api.thirst.HydrationEnum;
import sfiomn.legendarysurvivaloverhaul.api.thirst.ThirstUtil;
import sfiomn.legendarysurvivaloverhaul.common.items.drink.CanteenItem;

public class PurificationBlastingRecipe
extends BlastingRecipe {
    public PurificationBlastingRecipe(String group, CookingBookCategory cookingBookCategory, Ingredient ingredient, ItemStack result, float experience, int cookingTime) {
        super(group, cookingBookCategory, ingredient, result, experience, cookingTime);
    }

    public boolean matches(Container inventory, @NotNull Level level) {
        return this.ingredient.test(inventory.getItem(0)) && ThirstUtil.getCapacityTag(inventory.getItem(0)) > 0;
    }

    @NotNull
    public ItemStack assemble(Container inventory, @NotNull HolderLookup.Provider provider) {
        int hydrationCapacity = ThirstUtil.getCapacityTag(inventory.getItem(0));
        ItemStack result = this.result.copy();
        ThirstUtil.setHydrationEnumTag(result, HydrationEnum.PURIFIED);
        ThirstUtil.setCapacityTag(result, hydrationCapacity);
        return result;
    }

    @NotNull
    public ItemStack getResultItem(@NotNull HolderLookup.Provider provider) {
        ItemStack result = this.result.copy();
        int maxHydrationCapacity = 0;
        Item item = this.result.getItem();
        if (item instanceof CanteenItem) {
            CanteenItem resultItem = (CanteenItem)item;
            maxHydrationCapacity = resultItem.getMaxCapacity();
        }
        ThirstUtil.setHydrationEnumTag(result, HydrationEnum.PURIFIED);
        ThirstUtil.setCapacityTag(result, maxHydrationCapacity);
        return result;
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return Serializer.INSTANCE;
    }

    @NotNull
    public RecipeType<?> getType() {
        return RecipeType.BLASTING;
    }

    public static class Serializer
    implements RecipeSerializer<PurificationBlastingRecipe> {
        public static final Serializer INSTANCE = new Serializer(100);
        private static final StreamCodec<RegistryFriendlyByteBuf, PurificationBlastingRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, AbstractCookingRecipe::getGroup, (StreamCodec)ByteBufCodecs.fromCodec((Codec)CookingBookCategory.CODEC), AbstractCookingRecipe::category, (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, r -> PurificationBlastingRecipe.access$700(r), (StreamCodec)ItemStack.STREAM_CODEC, r -> PurificationBlastingRecipe.access$600(r), (StreamCodec)ByteBufCodecs.FLOAT, r -> Float.valueOf(((PurificationBlastingRecipe)r).experience), (StreamCodec)ByteBufCodecs.VAR_INT, r -> PurificationBlastingRecipe.access$400(r), PurificationBlastingRecipe::new);
        private final int defaultCookingTime;

        public Serializer(int cookingTime) {
            this.defaultCookingTime = cookingTime;
        }

        public MapCodec<PurificationBlastingRecipe> codec() {
            return RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(AbstractCookingRecipe::getGroup), (App)CookingBookCategory.CODEC.optionalFieldOf("category", (Object)CookingBookCategory.MISC).forGetter(AbstractCookingRecipe::category), (App)Ingredient.CODEC.fieldOf("ingredient").forGetter(r -> ((PurificationBlastingRecipe)r).ingredient), (App)ItemStack.CODEC.fieldOf("result").forGetter(r -> ((PurificationBlastingRecipe)r).result), (App)Codec.FLOAT.optionalFieldOf("experience", (Object)Float.valueOf(0.0f)).forGetter(r -> Float.valueOf(((PurificationBlastingRecipe)r).experience)), (App)Codec.INT.optionalFieldOf("cookingtime", (Object)this.defaultCookingTime).forGetter(r -> ((PurificationBlastingRecipe)r).cookingTime)).apply((Applicative)instance, (group, category, ingredient, result, exp, time) -> new PurificationBlastingRecipe((String)group, (CookingBookCategory)category, (Ingredient)ingredient, (ItemStack)result, exp.floatValue(), (int)time)));
        }

        public StreamCodec<RegistryFriendlyByteBuf, PurificationBlastingRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

