/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarysurvivaloverhaul.common.temperature;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import org.jetbrains.annotations.Nullable;
import sfiomn.legendarysurvivaloverhaul.api.temperature.ModifierBase;
import sfiomn.legendarysurvivaloverhaul.common.integration.terrafirmacraft.TerraFirmaCraftUtil;
import sfiomn.legendarysurvivaloverhaul.config.Config;

public class BiomeModifier
extends ModifierBase {
    @Override
    public float getWorldInfluence(@Nullable Player player, Level level, BlockPos pos) {
        if (TerraFirmaCraftUtil.shouldUseTerraFirmaCraftTemp()) {
            return 0.0f;
        }
        Vec3i[] posOffsets = new Vec3i[]{new Vec3i(0, 0, 0), new Vec3i(10, 0, 0), new Vec3i(-10, 0, 0), new Vec3i(0, 0, 10), new Vec3i(0, 0, -10), new Vec3i(7, 0, 7), new Vec3i(7, 0, -7), new Vec3i(-7, 0, 7), new Vec3i(-7, 0, -7)};
        float biomeAverage = 0.0f;
        float undergroundAverage = 0.0f;
        long worldTime = level.getLevelData().getDayTime() % 24000L;
        double drynessTimeMultiplier = 1.0;
        double drynessAverageMultiplier = 1.0;
        if (worldTime > 12000L && !level.dimensionType().hasCeiling() && Config.Baked.biomeDrynessMultiplier < 1.0) {
            drynessTimeMultiplier = 1.0 + Math.sin((double)worldTime * 2.6179938E-4) * (1.0 - Config.Baked.biomeDrynessMultiplier);
            drynessAverageMultiplier = (1.0 + Config.Baked.biomeDrynessMultiplier) / 2.0;
        }
        for (Vec3i offset : posOffsets) {
            Biome biome = (Biome)level.getBiome(pos.offset(offset)).value();
            float humidity = this.getHumidityForBiome(level, biome);
            float biomeTemperature = this.getNormalizedTempForBiome(level, biome);
            if (drynessTimeMultiplier < 1.0 && humidity < 0.2f && biomeTemperature > 0.8f) {
                undergroundAverage += (float)(drynessAverageMultiplier * (double)biomeTemperature);
                biomeAverage += (float)(drynessTimeMultiplier * (double)biomeTemperature);
                continue;
            }
            undergroundAverage += biomeTemperature;
            biomeAverage += biomeTemperature;
        }
        return this.applyUndergroundEffect((float)((double)this.normalizeToPositiveNegative(biomeAverage /= (float)posOffsets.length) * Config.Baked.biomeTemperatureMultiplier), level, pos, (float)((double)this.normalizeToPositiveNegative(undergroundAverage /= (float)posOffsets.length) * Config.Baked.biomeTemperatureMultiplier * Config.Baked.undergroundBiomeTemperatureMultiplier));
    }
}

