/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarysurvivaloverhaul.common.temperature;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import sfiomn.legendarysurvivaloverhaul.api.data.json.JsonTemperatureBlock;
import sfiomn.legendarysurvivaloverhaul.api.data.manager.TemperatureDataManager;
import sfiomn.legendarysurvivaloverhaul.api.temperature.ModifierBase;
import sfiomn.legendarysurvivaloverhaul.config.Config;
import sfiomn.legendarysurvivaloverhaul.util.MathUtil;
import sfiomn.legendarysurvivaloverhaul.util.SpreadPoint;

public class BlockModifier
extends ModifierBase {
    private float coldestValue = 0.0f;
    private float hottestValue = 0.0f;
    private float hotTotal = 0.0f;
    private float coldTotal = 0.0f;

    public int tempInfluenceMaximumDist() {
        return Config.Baked.tempInfluenceMaximumDist - 1;
    }

    @Override
    public float getWorldInfluence(@Nullable Player player, Level level, BlockPos pos) {
        this.coldestValue = 0.0f;
        this.hottestValue = 0.0f;
        this.hotTotal = 0.0f;
        this.coldTotal = 0.0f;
        this.doBlocksAndFluidsRoutine(level, pos);
        this.hotTotal -= this.hottestValue;
        this.coldTotal -= this.coldestValue;
        float hotLogValue = this.hottestValue * (float)Math.sqrt(this.easyLog(this.hotTotal));
        float coldLogValue = this.coldestValue * (float)Math.sqrt(this.easyLog(this.coldTotal));
        float result = hotLogValue + coldLogValue;
        if (result > this.hottestValue) {
            return Math.min(this.hottestValue + 2.5f, result);
        }
        if (result < this.coldestValue) {
            return Math.max(this.coldestValue - 2.5f, result);
        }
        return result;
    }

    private void doBlocksAndFluidsRoutine(Level level, BlockPos pos) {
        HashSet<BlockPos> visitedBlockPos = new HashSet<BlockPos>();
        ArrayList<SpreadPoint> visitedSpreadPoints = new ArrayList<SpreadPoint>();
        ArrayList<SpreadPoint> spreadPointsToProcess = new ArrayList<SpreadPoint>();
        HashMap cachedCanSeeSky = new HashMap();
        SpreadPoint spreadPointFeetPlayer = new SpreadPoint(pos, Direction.DOWN, this.tempInfluenceMaximumDist(), 0.0, level);
        SpreadPoint spreadPointHeadPlayer = new SpreadPoint(pos.above(), Direction.UP, this.tempInfluenceMaximumDist(), 0.0, level);
        spreadPointsToProcess.add(spreadPointFeetPlayer);
        spreadPointsToProcess.add(spreadPointHeadPlayer);
        visitedBlockPos.add(spreadPointFeetPlayer.position());
        visitedBlockPos.add(spreadPointHeadPlayer.position());
        visitedSpreadPoints.add(spreadPointFeetPlayer);
        visitedSpreadPoints.add(spreadPointHeadPlayer);
        boolean hasCeiling = level.dimensionType().hasCeiling();
        while (!spreadPointsToProcess.isEmpty()) {
            SpreadPoint spreadPoint = (SpreadPoint)spreadPointsToProcess.remove(0);
            spreadPoint.setCanSeeSky(!hasCeiling || level.canSeeSky(pos));
            Direction oppositeDirection = spreadPoint.originalDirection().getOpposite();
            for (Direction direction : Direction.values()) {
                if (direction == oppositeDirection || !spreadPoint.isValidSpreadDirection(direction)) continue;
                Vec3i newPosVector = direction.getNormal();
                SpreadPoint spreadPoint1 = this.processDirectionTo(spreadPointsToProcess, visitedBlockPos, visitedSpreadPoints, spreadPoint, spreadPoint.position().offset(newPosVector), direction, 1.0f);
                if (spreadPoint1 == null) continue;
                for (Direction direction1 : Direction.values()) {
                    if (direction1.getAxis() == direction.getAxis() || direction1 == oppositeDirection || !spreadPoint1.isValidSpreadDirection(direction)) continue;
                    newPosVector = newPosVector.relative(direction1, 1);
                    SpreadPoint spreadPoint2 = this.processDirectionTo(spreadPointsToProcess, visitedBlockPos, visitedSpreadPoints, spreadPoint, spreadPoint.position().offset(newPosVector), direction1, 1.414f);
                    if (spreadPoint2 == null) continue;
                    for (Direction direction2 : Direction.values()) {
                        if (direction2.getAxis() == direction1.getAxis() || direction2.getAxis() == direction.getAxis() || direction2 == oppositeDirection || !spreadPoint2.isValidSpreadDirection(direction)) continue;
                        newPosVector = newPosVector.relative(direction2, 1);
                        this.processDirectionTo(spreadPointsToProcess, visitedBlockPos, visitedSpreadPoints, spreadPoint, spreadPoint.position().offset(newPosVector), direction2, 1.732f);
                    }
                }
            }
        }
        HashMap<ResourceLocation, List<JsonTemperatureBlock>> cachedTemperatureBlocks = new HashMap<ResourceLocation, List<JsonTemperatureBlock>>();
        for (SpreadPoint spreadPoint : visitedSpreadPoints) {
            this.processTemp(this.getTemperatureFromSpreadPoint(level, spreadPoint, cachedTemperatureBlocks));
        }
    }

    private SpreadPoint processDirectionTo(ArrayList<SpreadPoint> spreadPointsToProcess, HashSet<BlockPos> visitedBlockPos, ArrayList<SpreadPoint> visitedSpreadPoints, SpreadPoint parentSpreadPoint, BlockPos newBlockPos, Direction originDirection, float distance) {
        if (!visitedBlockPos.contains(newBlockPos)) {
            SpreadPoint newSpreadPoint = parentSpreadPoint.spreadTo(newBlockPos, originDirection, distance);
            visitedBlockPos.add(newSpreadPoint.position());
            visitedSpreadPoints.add(newSpreadPoint);
            if (newSpreadPoint.isValidSpreadPoint(originDirection)) {
                spreadPointsToProcess.add(newSpreadPoint);
                return newSpreadPoint;
            }
        }
        return null;
    }

    private void processTemp(float temp) {
        if (temp == 0.0f) {
            return;
        }
        if (temp >= 0.0f) {
            this.hotTotal += temp;
            if (temp > this.hottestValue) {
                this.hottestValue = temp;
            }
        } else {
            this.coldTotal += temp;
            if (temp < this.coldestValue) {
                this.coldestValue = temp;
            }
        }
    }

    private float easyLog(float f) {
        if (f >= 0.0f) {
            return (float)Math.log10(f + 10.0f);
        }
        return (float)Math.log10(-1.0f * f + 10.0f);
    }

    private float getTemperatureFromSpreadPoint(Level level, SpreadPoint spreadPoint, Map<ResourceLocation, List<JsonTemperatureBlock>> cachedTemperatureBlocks) {
        List<JsonTemperatureBlock> tempPropertyList;
        BlockState blockState = level.getBlockState(spreadPoint.position());
        float temperature = 0.0f;
        ResourceLocation registryName = BuiltInRegistries.BLOCK.getKey((Object)blockState.getBlock());
        if (registryName == null || blockState.isAir()) {
            return 0.0f;
        }
        if (cachedTemperatureBlocks.containsKey(registryName)) {
            tempPropertyList = cachedTemperatureBlocks.get(registryName);
        } else {
            tempPropertyList = TemperatureDataManager.getBlock(registryName);
            cachedTemperatureBlocks.put(registryName, tempPropertyList);
        }
        if (tempPropertyList == null) {
            return 0.0f;
        }
        for (JsonTemperatureBlock tempInfo : tempPropertyList) {
            if (tempInfo == null || !tempInfo.matchesState(blockState)) continue;
            temperature = tempInfo.temperature;
            break;
        }
        return temperature == 0.0f ? temperature : this.temperatureAfterDistanceInfluence(temperature, spreadPoint);
    }

    private float temperatureAfterDistanceInfluence(float tempIn, SpreadPoint spreadPoint) {
        float capacityConsumed = MathUtil.round((float)Math.max((double)this.tempInfluenceMaximumDist() - spreadPoint.spreadCapacity() - 1.0, 0.0) / (float)this.tempInfluenceMaximumDist(), 2);
        return MathUtil.round((float)Math.sqrt(1.0f - capacityConsumed) * tempIn, 2);
    }
}

