/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarysurvivaloverhaul.common.temperature;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import sfiomn.legendarysurvivaloverhaul.api.temperature.ModifierBase;
import sfiomn.legendarysurvivaloverhaul.config.Config;

public class PlayerHuddlingModifier
extends ModifierBase {
    @Override
    public float getPlayerInfluence(Player player) {
        if (Config.Baked.playerHuddlingRadius == 0 || Config.Baked.playerHuddlingModifier == 0.0) {
            return 0.0f;
        }
        Level world = player.getCommandSenderWorld();
        BlockPos pos = player.blockPosition();
        int huddleRadius = Config.Baked.playerHuddlingRadius;
        BlockPos minPos = pos.offset(-huddleRadius, -huddleRadius, -huddleRadius);
        BlockPos maxPos = pos.offset(huddleRadius, huddleRadius, huddleRadius);
        AABB bounds = new AABB(Vec3.atLowerCornerOf((Vec3i)minPos), Vec3.atLowerCornerOf((Vec3i)maxPos));
        List players = world.getNearbyPlayers(TargetingConditions.DEFAULT, (LivingEntity)player, bounds);
        int playerCount = 0;
        for (Player p : players) {
            if (p.isCreative() || p.isSpectator()) continue;
            ++playerCount;
        }
        return (float)((double)playerCount * Config.Baked.playerHuddlingModifier);
    }
}

