/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarysurvivaloverhaul.config.json_old;

import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import org.apache.commons.io.FileUtils;
import sfiomn.legendarysurvivaloverhaul.LegendarySurvivalOverhaul;
import sfiomn.legendarysurvivaloverhaul.api.block.ThermalTypeEnum;
import sfiomn.legendarysurvivaloverhaul.api.bodydamage.BodyPartEnum;
import sfiomn.legendarysurvivaloverhaul.api.bodydamage.DamageDistributionEnum;
import sfiomn.legendarysurvivaloverhaul.api.config.json_old.JsonPropertyValue;
import sfiomn.legendarysurvivaloverhaul.api.config.json_old.bodydamage.JsonBodyPartsDamageSource;
import sfiomn.legendarysurvivaloverhaul.api.config.json_old.bodydamage.JsonConsumableHeal;
import sfiomn.legendarysurvivaloverhaul.api.config.json_old.temperature.JsonBiomeIdentity;
import sfiomn.legendarysurvivaloverhaul.api.config.json_old.temperature.JsonBlockFluidTemperature;
import sfiomn.legendarysurvivaloverhaul.api.config.json_old.temperature.JsonConsumableTemperature;
import sfiomn.legendarysurvivaloverhaul.api.config.json_old.temperature.JsonFuelItem;
import sfiomn.legendarysurvivaloverhaul.api.config.json_old.temperature.JsonTemperature;
import sfiomn.legendarysurvivaloverhaul.api.config.json_old.temperature.JsonTemperatureResistance;
import sfiomn.legendarysurvivaloverhaul.api.config.json_old.thirst.JsonBlockFluidThirst;
import sfiomn.legendarysurvivaloverhaul.api.config.json_old.thirst.JsonConsumableThirst;
import sfiomn.legendarysurvivaloverhaul.api.config.json_old.thirst.JsonEffectParameter;
import sfiomn.legendarysurvivaloverhaul.api.temperature.TemporaryModifierGroupEnum;
import sfiomn.legendarysurvivaloverhaul.api.thirst.HydrationEnum;
import sfiomn.legendarysurvivaloverhaul.common.blocks.IceFernBlock;
import sfiomn.legendarysurvivaloverhaul.common.blocks.SunFernBlock;
import sfiomn.legendarysurvivaloverhaul.common.integration.IntegrationController;
import sfiomn.legendarysurvivaloverhaul.config.JsonFileName;
import sfiomn.legendarysurvivaloverhaul.config.JsonTypeToken;
import sfiomn.legendarysurvivaloverhaul.config.json_old.JsonConfig;
import sfiomn.legendarysurvivaloverhaul.data.builders.BodyPartsDamageSourceData;
import sfiomn.legendarysurvivaloverhaul.data.builders.HealingConsumableData;
import sfiomn.legendarysurvivaloverhaul.data.builders.TemperatureBiomeOverrideData;
import sfiomn.legendarysurvivaloverhaul.data.builders.TemperatureBlockData;
import sfiomn.legendarysurvivaloverhaul.data.builders.TemperatureConsumableData;
import sfiomn.legendarysurvivaloverhaul.data.builders.TemperatureData;
import sfiomn.legendarysurvivaloverhaul.data.builders.TemperatureDimensionData;
import sfiomn.legendarysurvivaloverhaul.data.builders.TemperatureFuelItemData;
import sfiomn.legendarysurvivaloverhaul.data.builders.TemperatureResistanceData;
import sfiomn.legendarysurvivaloverhaul.data.builders.ThirstData;

public class JsonConfigRegistration {
    public static Path customDatapackFolder = Paths.get(LegendarySurvivalOverhaul.modConfigPath.toString(), "customDataPack");

    public static void init(File configDir) {
        if (configDir.exists()) {
            JsonConfigRegistration.registerDefaults(configDir);
            JsonConfigRegistration.processAllJson(configDir);
        }
    }

    public static void registerDefaults(File configDir) {
        JsonConfig.registerDefaultDimensionTemperature("minecraft:overworld", 20.0f);
        JsonConfig.registerDefaultDimensionTemperature("minecraft:the_end", -15.0f);
        JsonConfig.registerDefaultDimensionTemperature("minecraft:the_nether", 28.0f);
        JsonConfig.registerDefaultBlockFluidTemperature("minecraft:campfire", 10.0f, new JsonPropertyValue("lit", "true"));
        JsonConfig.registerDefaultBlockFluidTemperature("minecraft:campfire", 0.0f, new JsonPropertyValue("lit", "false"));
        JsonConfig.registerDefaultBlockFluidTemperature("minecraft:soul_campfire", -10.0f, new JsonPropertyValue("lit", "true"));
        JsonConfig.registerDefaultBlockFluidTemperature("minecraft:soul_campfire", 0.0f, new JsonPropertyValue("lit", "false"));
        JsonConfig.registerDefaultBlockFluidTemperature("minecraft:torch", 1.5f, new JsonPropertyValue[0]);
        JsonConfig.registerDefaultBlockFluidTemperature("minecraft:soul_torch", -1.5f, new JsonPropertyValue[0]);
        JsonConfig.registerDefaultBlockFluidTemperature("minecraft:wall_torch", 1.5f, new JsonPropertyValue[0]);
        JsonConfig.registerDefaultBlockFluidTemperature("minecraft:soul_wall_torch", -1.5f, new JsonPropertyValue[0]);
        JsonConfig.registerDefaultBlockFluidTemperature("minecraft:fire", 7.0f, new JsonPropertyValue[0]);
        JsonConfig.registerDefaultBlockFluidTemperature("minecraft:soul_fire", -7.0f, new JsonPropertyValue[0]);
        JsonConfig.registerDefaultBlockFluidTemperature("minecraft:furnace", 6.0f, new JsonPropertyValue("lit", "true"));
        JsonConfig.registerDefaultBlockFluidTemperature("minecraft:blast_furnace", 6.0f, new JsonPropertyValue("lit", "true"));
        JsonConfig.registerDefaultBlockFluidTemperature("minecraft:smoker", 6.0f, new JsonPropertyValue("lit", "true"));
        JsonConfig.registerDefaultBlockFluidTemperature("minecraft:furnace", 0.0f, new JsonPropertyValue("lit", "false"));
        JsonConfig.registerDefaultBlockFluidTemperature("minecraft:blast_furnace", 0.0f, new JsonPropertyValue("lit", "false"));
        JsonConfig.registerDefaultBlockFluidTemperature("minecraft:smoker", 0.0f, new JsonPropertyValue("false", "true"));
        JsonConfig.registerDefaultBlockFluidTemperature("legendarysurvivaloverhaul:cooler", -15.0f, new JsonPropertyValue("lit", "true"));
        JsonConfig.registerDefaultBlockFluidTemperature("legendarysurvivaloverhaul:heater", 15.0f, new JsonPropertyValue("lit", "true"));
        JsonConfig.registerDefaultBlockFluidTemperature("legendarysurvivaloverhaul:cooler", 0.0f, new JsonPropertyValue("lit", "false"));
        JsonConfig.registerDefaultBlockFluidTemperature("legendarysurvivaloverhaul:heater", 0.0f, new JsonPropertyValue("lit", "false"));
        JsonConfig.registerDefaultBlockFluidTemperature("legendarysurvivaloverhaul:ice_fern_crop", -1.5f, new JsonPropertyValue(IceFernBlock.AGE.getName(), String.valueOf(3)));
        JsonConfig.registerDefaultBlockFluidTemperature("legendarysurvivaloverhaul:sun_fern_crop", 1.5f, new JsonPropertyValue(SunFernBlock.AGE.getName(), String.valueOf(3)));
        JsonConfig.registerDefaultBlockFluidTemperature("minecraft:magma_block", 12.0f, new JsonPropertyValue[0]);
        JsonConfig.registerDefaultBlockFluidTemperature("minecraft:jack_o_lantern", 3.0f, new JsonPropertyValue[0]);
        JsonConfig.registerDefaultBlockFluidTemperature("minecraft:lava", 12.5f, new JsonPropertyValue[0]);
        JsonConfig.registerDefaultBlockFluidTemperature("minecraft:flowing_lava", 12.5f, new JsonPropertyValue[0]);
        JsonConfig.registerDefaultItemTemperature("legendarysurvivaloverhaul:snow_boots", 0.0f, 0.0f, 0.5f, 0.0f);
        JsonConfig.registerDefaultItemTemperature("legendarysurvivaloverhaul:snow_leggings", 0.0f, 0.0f, 2.5f, 0.0f);
        JsonConfig.registerDefaultItemTemperature("legendarysurvivaloverhaul:snow_chestplate", 0.0f, 0.0f, 3.0f, 0.0f);
        JsonConfig.registerDefaultItemTemperature("legendarysurvivaloverhaul:snow_helmet", 0.0f, 0.0f, 1.5f, 0.0f);
        JsonConfig.registerDefaultItemTemperature("legendarysurvivaloverhaul:desert_boots", 0.0f, 0.5f, 0.0f, 0.0f);
        JsonConfig.registerDefaultItemTemperature("legendarysurvivaloverhaul:desert_leggings", 0.0f, 2.5f, 0.0f, 0.0f);
        JsonConfig.registerDefaultItemTemperature("legendarysurvivaloverhaul:desert_chestplate", 0.0f, 3.0f, 0.0f, 0.0f);
        JsonConfig.registerDefaultItemTemperature("legendarysurvivaloverhaul:desert_helmet", 0.0f, 1.5f, 0.0f, 0.0f);
        JsonConfig.registerDefaultItemTemperature("legendarysurvivaloverhaul:nether_chalice", 2.0f);
        JsonConfig.registerDefaultItemTemperature("minecraft:lava_bucket", 6.0f);
        JsonConfig.registerDefaultItemTemperature("minecraft:magma_block", 6.0f);
        JsonConfig.registerDefaultItemTemperature("minecraft:leather_boots", 0.0f, 0.0f, 0.5f, 0.0f);
        JsonConfig.registerDefaultItemTemperature("minecraft:leather_leggings", 0.0f, 0.0f, 1.0f, 0.0f);
        JsonConfig.registerDefaultItemTemperature("minecraft:leather_chestplate", 0.0f, 0.0f, 1.5f, 0.0f);
        JsonConfig.registerDefaultItemTemperature("minecraft:leather_helmet", 0.0f, 0.0f, 1.0f, 0.0f);
        JsonConfig.registerDefaultItemTemperature("minecraft:golden_boots", 0.0f, 0.0f, 0.5f, 0.0f);
        JsonConfig.registerDefaultItemTemperature("minecraft:golden_leggings", 0.0f, 0.0f, 1.0f, 0.0f);
        JsonConfig.registerDefaultItemTemperature("minecraft:golden_chestplate", 0.0f, 0.0f, 1.0f, 0.0f);
        JsonConfig.registerDefaultItemTemperature("minecraft:golden_helmet", 0.0f, 0.0f, 0.5f, 0.0f);
        JsonConfig.registerDefaultItemTemperature("minecraft:iron_boots", 0.0f, 0.5f, 0.0f, 0.0f);
        JsonConfig.registerDefaultItemTemperature("minecraft:iron_leggings", 0.0f, 1.0f, 0.0f, 0.0f);
        JsonConfig.registerDefaultItemTemperature("minecraft:iron_chestplate", 0.0f, 1.0f, 0.0f, 0.0f);
        JsonConfig.registerDefaultItemTemperature("minecraft:iron_helmet", 0.0f, 0.5f, 0.0f, 0.0f);
        JsonConfig.registerDefaultItemTemperature("minecraft:diamond_boots", 0.0f, 1.0f, 0.0f, 0.0f);
        JsonConfig.registerDefaultItemTemperature("minecraft:diamond_leggings", 0.0f, 1.0f, 0.0f, 0.0f);
        JsonConfig.registerDefaultItemTemperature("minecraft:diamond_chestplate", 0.0f, 1.5f, 0.0f, 0.0f);
        JsonConfig.registerDefaultItemTemperature("minecraft:diamond_helmet", 0.0f, 0.5f, 0.0f, 0.0f);
        JsonConfig.registerDefaultItemTemperature("minecraft:netherite_boots", 0.0f, 0.0f, 1.5f, 0.0f);
        JsonConfig.registerDefaultItemTemperature("minecraft:netherite_leggings", 0.0f, 0.0f, 1.5f, 0.0f);
        JsonConfig.registerDefaultItemTemperature("minecraft:netherite_chestplate", 0.0f, 0.0f, 2.0f, 0.0f);
        JsonConfig.registerDefaultItemTemperature("minecraft:netherite_helmet", 0.0f, 0.0f, 1.0f, 0.0f);
        JsonConfig.registerDefaultItemTemperature("minecraft:torch", 1.0f);
        JsonConfig.registerDefaultItemTemperature("minecraft:soul_torch", -1.0f);
        JsonConfig.registerDefaultItemTemperature("minecraft:ice", -1.0f);
        JsonConfig.registerDefaultItemTemperature("minecraft:packed_ice", -2.0f);
        JsonConfig.registerDefaultItemTemperature("minecraft:blue_ice", -3.0f);
        JsonConfig.registerDefaultEntityTemperature("minecraft:strider", -3.0f);
        JsonConfig.registerDefaultConsumableTemperature(TemporaryModifierGroupEnum.FOOD, "minecraft:mushroom_stew", 1, 1200);
        JsonConfig.registerDefaultConsumableTemperature(TemporaryModifierGroupEnum.DRINK, "minecraft:mushroom_stew", 1, 1200);
        JsonConfig.registerDefaultConsumableTemperature(TemporaryModifierGroupEnum.FOOD, "minecraft:rabbit_stew", 2, 1200);
        JsonConfig.registerDefaultConsumableTemperature(TemporaryModifierGroupEnum.FOOD, "minecraft:suspicious_stew", 1, 1200);
        JsonConfig.registerDefaultConsumableTemperature(TemporaryModifierGroupEnum.FOOD, "minecraft:melon_slice", -1, 1200);
        JsonConfig.registerDefaultConsumableTemperature(TemporaryModifierGroupEnum.DRINK, "legendarysurvivaloverhaul:melon_juice", -1, 1200);
        JsonConfig.registerDefaultConsumableTemperature(TemporaryModifierGroupEnum.DRINK, "legendarysurvivaloverhaul:glistering_melon_juice", -2, 3600);
        JsonConfig.registerDefaultBiomeOverride("minecraft:crimson_forest", 0.75f, false);
        JsonConfig.registerDefaultBiomeOverride("minecraft:warped_forest", 0.75f, false);
        JsonConfig.registerDefaultBiomeOverride("minecraft:nether_wastes", 1.0f, false);
        JsonConfig.registerDefaultBiomeOverride("minecraft:soul_sand_valley", 1.0f, false);
        JsonConfig.registerDefaultBiomeOverride("minecraft:basalt_deltas", 1.45f, false);
        JsonConfig.registerDefaultBiomeOverride("minecraft:frozen_ocean", -0.5f, false);
        JsonConfig.registerDefaultBiomeOverride("minecraft:deep_frozen_ocean", -0.5f, false);
        JsonConfig.registerDefaultFuelItems("minecraft:coal", ThermalTypeEnum.HEATING, 30);
        JsonConfig.registerDefaultFuelItems("minecraft:charcoal", ThermalTypeEnum.HEATING, 30);
        JsonConfig.registerDefaultFuelItems("minecraft:coal_block", ThermalTypeEnum.HEATING, 270);
        JsonConfig.registerDefaultFuelItems("minecraft:ice", ThermalTypeEnum.COOLING, 20);
        JsonConfig.registerDefaultFuelItems("minecraft:snowball", ThermalTypeEnum.COOLING, 20);
        JsonConfig.registerDefaultFuelItems("minecraft:snow_block", ThermalTypeEnum.COOLING, 30);
        JsonConfig.registerDefaultFuelItems("minecraft:blue_ice", ThermalTypeEnum.COOLING, 1620);
        JsonConfig.registerDefaultFuelItems("minecraft:packed_ice", ThermalTypeEnum.COOLING, 180);
        JsonConfig.registerDefaultBlockFluidThirst("minecraft:rain", 1, 0.0f);
        JsonConfig.registerDefaultBlockFluidThirst("minecraft:flowing_water", 3, 0.0f, new JsonEffectParameter[]{new JsonEffectParameter("legendarysurvivaloverhaul:thirst", 0.75f, 300, 0)}, new JsonPropertyValue[0]);
        JsonConfig.registerDefaultBlockFluidThirst("minecraft:water", 3, 0.0f, new JsonEffectParameter[]{new JsonEffectParameter("legendarysurvivaloverhaul:thirst", 0.75f, 300, 0)}, new JsonPropertyValue[0]);
        JsonConfig.registerDefaultBlockFluidThirst("minecraft:water_cauldron", 3, 0.0f, new JsonEffectParameter[]{new JsonEffectParameter("legendarysurvivaloverhaul:thirst", 0.75f, 300, 0)}, new JsonPropertyValue[0]);
        JsonConfig.registerDefaultConsumableThirst("minecraft:melon_slice", 2, 1.0f);
        JsonConfig.registerDefaultConsumableThirst("minecraft:apple", 2, 0.5f);
        JsonConfig.registerDefaultConsumableThirst("minecraft:beetroot_soup", 4, 2.0f);
        JsonConfig.registerDefaultConsumableThirst("minecraft:rabbit_stew", 6, 2.0f);
        JsonConfig.registerDefaultConsumableThirst("minecraft:mushroom_stew", 4, 2.0f);
        JsonConfig.registerDefaultConsumableThirst("minecraft:suspicious_stew", 4, 2.0f);
        JsonConfig.registerDefaultConsumableThirst("minecraft:rotten_flesh", -2, -1.0f, new JsonEffectParameter[]{new JsonEffectParameter("legendarysurvivaloverhaul:thirst", 1.0f, 600, 0)}, new JsonPropertyValue[0]);
        JsonConfig.registerDefaultConsumableThirst("legendarysurvivaloverhaul:apple_juice", 6, 3.0f);
        JsonConfig.registerDefaultConsumableThirst("legendarysurvivaloverhaul:beetroot_juice", 9, 4.0f);
        JsonConfig.registerDefaultConsumableThirst("legendarysurvivaloverhaul:cactus_juice", 9, 3.0f);
        JsonConfig.registerDefaultConsumableThirst("legendarysurvivaloverhaul:carrot_juice", 4, 2.0f);
        JsonConfig.registerDefaultConsumableThirst("legendarysurvivaloverhaul:chorus_fruit_juice", 12, 8.0f);
        JsonConfig.registerDefaultConsumableThirst("legendarysurvivaloverhaul:golden_apple_juice", 20, 20.0f);
        JsonConfig.registerDefaultConsumableThirst("legendarysurvivaloverhaul:golden_carrot_juice", 12, 12.0f);
        JsonConfig.registerDefaultConsumableThirst("legendarysurvivaloverhaul:glistering_melon_juice", 16, 16.0f);
        JsonConfig.registerDefaultConsumableThirst("legendarysurvivaloverhaul:melon_juice", 8, 4.0f);
        JsonConfig.registerDefaultConsumableThirst("legendarysurvivaloverhaul:pumpkin_juice", 7, 4.0f);
        JsonConfig.registerDefaultConsumableThirst("legendarysurvivaloverhaul:purified_water_bottle", 6, 1.5f);
        JsonConfig.registerDefaultConsumableThirst("legendarysurvivaloverhaul:water_plant_bag", 3, 0.0f);
        JsonConfig.registerDefaultConsumableThirst("legendarysurvivaloverhaul:canteen", 3, 0.0f, new JsonEffectParameter[]{new JsonEffectParameter("legendarysurvivaloverhaul:thirst", 0.75f, 300, 0)}, new JsonPropertyValue("legendarysurvivaloverhaul:HydrationPurity", HydrationEnum.NORMAL.getName()));
        JsonConfig.registerDefaultConsumableThirst("legendarysurvivaloverhaul:canteen", 6, 1.5f, new JsonPropertyValue("legendarysurvivaloverhaul:HydrationPurity", HydrationEnum.PURIFIED.getName()));
        JsonConfig.registerDefaultConsumableThirst("legendarysurvivaloverhaul:large_canteen", 3, 0.0f, new JsonEffectParameter[]{new JsonEffectParameter("legendarysurvivaloverhaul:thirst", 0.75f, 300, 0)}, new JsonPropertyValue("legendarysurvivaloverhaul:HydrationPurity", HydrationEnum.NORMAL.getName()));
        JsonConfig.registerDefaultConsumableThirst("legendarysurvivaloverhaul:large_canteen", 6, 1.5f, new JsonPropertyValue("legendarysurvivaloverhaul:HydrationPurity", HydrationEnum.PURIFIED.getName()));
        JsonConfig.registerDefaultConsumableThirst("minecraft:potion", 3, 0.0f, new JsonEffectParameter[]{new JsonEffectParameter("legendarysurvivaloverhaul:thirst", 0.75f, 300, 0)}, new JsonPropertyValue("Potion", "minecraft:water"));
        JsonConfig.registerDefaultConsumableThirst("minecraft:potion", 3, 0.0f, new JsonEffectParameter[]{new JsonEffectParameter("legendarysurvivaloverhaul:thirst", 0.75f, 300, 0)}, new JsonPropertyValue("Potion", "minecraft:mundane"));
        JsonConfig.registerDefaultConsumableThirst("minecraft:potion", 3, 0.0f, new JsonEffectParameter[]{new JsonEffectParameter("legendarysurvivaloverhaul:thirst", 0.75f, 300, 0)}, new JsonPropertyValue("Potion", "minecraft:thick"));
        JsonConfig.registerDefaultConsumableThirst("minecraft:potion", 3, 0.0f, new JsonEffectParameter[]{new JsonEffectParameter("legendarysurvivaloverhaul:thirst", 0.75f, 300, 0)}, new JsonPropertyValue("Potion", "minecraft:awkward"));
        JsonConfig.registerDefaultConsumableThirst("minecraft:potion", 0, 0.0f, new JsonEffectParameter[0], new JsonPropertyValue("Potion", "minecraft:empty"));
        JsonConfig.registerDefaultConsumableThirst("minecraft:potion", 6, 1.5f, new JsonEffectParameter[0], new JsonPropertyValue[0]);
        JsonConfig.registerDefaultConsumableHeal("legendarysurvivaloverhaul:healing_herbs", 1, 2.0f, 600);
        JsonConfig.registerDefaultConsumableHeal("legendarysurvivaloverhaul:plaster", 1, 3.0f, 400);
        JsonConfig.registerDefaultConsumableHeal("legendarysurvivaloverhaul:bandage", 3, 3.0f, 300);
        JsonConfig.registerDefaultConsumableHeal("legendarysurvivaloverhaul:tonic", 0, 5.0f, 600);
        JsonConfig.registerDefaultConsumableHeal("legendarysurvivaloverhaul:medikit", 0, 8.0f, 400);
        JsonConfig.registerDefaultDamageSourceBodyParts("fall", DamageDistributionEnum.ALL, Arrays.asList(BodyPartEnum.LEFT_FOOT, BodyPartEnum.RIGHT_FOOT));
        JsonConfig.registerDefaultDamageSourceBodyParts("hotFloor", DamageDistributionEnum.ALL, Arrays.asList(BodyPartEnum.LEFT_FOOT, BodyPartEnum.RIGHT_FOOT));
        JsonConfig.registerDefaultDamageSourceBodyParts("fallingBlock", DamageDistributionEnum.ALL, Collections.singletonList(BodyPartEnum.HEAD));
        JsonConfig.registerDefaultDamageSourceBodyParts("flyIntoWall", DamageDistributionEnum.ALL, Collections.singletonList(BodyPartEnum.HEAD));
        JsonConfig.registerDefaultDamageSourceBodyParts("anvil", DamageDistributionEnum.ALL, Collections.singletonList(BodyPartEnum.HEAD));
        JsonConfig.registerDefaultDamageSourceBodyParts("lightningBolt", DamageDistributionEnum.ALL, Arrays.asList(BodyPartEnum.values()));
        JsonConfig.registerDefaultDamageSourceBodyParts("onFire", DamageDistributionEnum.ALL, Arrays.asList(BodyPartEnum.values()));
        JsonConfig.registerDefaultDamageSourceBodyParts("explosion", DamageDistributionEnum.ALL, Arrays.asList(BodyPartEnum.values()));
        JsonConfig.registerDefaultDamageSourceBodyParts("bad_respawn_point", DamageDistributionEnum.ALL, Arrays.asList(BodyPartEnum.values()));
        JsonConfig.registerDefaultDamageSourceBodyParts("dragonBreath", DamageDistributionEnum.ALL, Arrays.asList(BodyPartEnum.values()));
        JsonConfig.registerDefaultDamageSourceBodyParts("inFire", DamageDistributionEnum.ALL, Arrays.asList(BodyPartEnum.LEFT_FOOT, BodyPartEnum.RIGHT_FOOT, BodyPartEnum.LEFT_LEG, BodyPartEnum.RIGHT_LEG));
        JsonConfig.registerDefaultDamageSourceBodyParts("cactus", DamageDistributionEnum.ONE_OF, Arrays.asList(BodyPartEnum.LEFT_FOOT, BodyPartEnum.RIGHT_FOOT, BodyPartEnum.LEFT_LEG, BodyPartEnum.RIGHT_LEG));
        JsonConfig.registerDefaultDamageSourceBodyParts("sweetBerryBush", DamageDistributionEnum.ONE_OF, Arrays.asList(BodyPartEnum.LEFT_FOOT, BodyPartEnum.RIGHT_FOOT, BodyPartEnum.LEFT_LEG, BodyPartEnum.RIGHT_LEG));
        JsonConfig.registerDefaultDamageSourceBodyParts("in_wall", DamageDistributionEnum.NONE, Collections.emptyList());
        JsonConfig.registerDefaultDamageSourceBodyParts("drown", DamageDistributionEnum.NONE, Collections.emptyList());
        JsonConfig.registerDefaultDamageSourceBodyParts("starve", DamageDistributionEnum.NONE, Collections.emptyList());
        JsonConfig.registerDefaultDamageSourceBodyParts("magic", DamageDistributionEnum.NONE, Collections.emptyList());
        JsonConfig.registerDefaultDamageSourceBodyParts("wither", DamageDistributionEnum.NONE, Collections.emptyList());
        JsonConfig.registerDefaultDamageSourceBodyParts("legendarysurvivaloverhaul.hypothermia", DamageDistributionEnum.NONE, Collections.emptyList());
        JsonConfig.registerDefaultDamageSourceBodyParts("legendarysurvivaloverhaul.hyperthermia", DamageDistributionEnum.NONE, Collections.emptyList());
        JsonConfig.registerDefaultDamageSourceBodyParts("legendarysurvivaloverhaul.dehydration", DamageDistributionEnum.NONE, Collections.emptyList());
        IntegrationController.initIntegration();
    }

    public static void writeAllToJson(File jsonDir) {
        JsonConfigRegistration.manuallyWriteToJson(JsonFileName.DIMENSION_TEMP, JsonConfig.defaultDimensionTemperatures, jsonDir);
        JsonConfigRegistration.manuallyWriteToJson(JsonFileName.BIOME_TEMP, JsonConfig.defaultBiomeOverrides, jsonDir);
        JsonConfigRegistration.manuallyWriteToJson(JsonFileName.ITEM_TEMP, JsonConfig.defaultItemTemperatures, jsonDir);
        JsonConfigRegistration.manuallyWriteToJson(JsonFileName.BLOCK_TEMP, JsonConfig.defaultBlockFluidTemperatures, jsonDir);
        JsonConfigRegistration.manuallyWriteToJson(JsonFileName.FUEL, JsonConfig.defaultFuelItems, jsonDir);
        JsonConfigRegistration.manuallyWriteToJson(JsonFileName.CONSUMABLE_TEMP, JsonConfig.defaultConsumableTemperature, jsonDir);
        JsonConfigRegistration.manuallyWriteToJson(JsonFileName.BLOCK_THIRST, JsonConfig.defaultBlockFluidThirst, jsonDir);
        JsonConfigRegistration.manuallyWriteToJson(JsonFileName.CONSUMABLE_THIRST, JsonConfig.defaultConsumableThirst, jsonDir);
        JsonConfigRegistration.manuallyWriteToJson(JsonFileName.CONSUMABLE_HEAL, JsonConfig.defaultConsumableHeal, jsonDir);
        JsonConfigRegistration.manuallyWriteToJson(JsonFileName.DAMAGE_SOURCE_BODY_PARTS, JsonConfig.defaultDamageSourceBodyParts, jsonDir);
    }

    public static void deleteAllJson(File jsonDir) {
        JsonConfigRegistration.deleteJson(JsonFileName.DIMENSION_TEMP, jsonDir);
        JsonConfigRegistration.deleteJson(JsonFileName.BIOME_TEMP, jsonDir);
        JsonConfigRegistration.deleteJson(JsonFileName.ITEM_TEMP, jsonDir);
        JsonConfigRegistration.deleteJson(JsonFileName.BLOCK_TEMP, jsonDir);
        JsonConfigRegistration.deleteJson(JsonFileName.FUEL, jsonDir);
        JsonConfigRegistration.deleteJson(JsonFileName.CONSUMABLE_TEMP, jsonDir);
        JsonConfigRegistration.deleteJson(JsonFileName.BLOCK_THIRST, jsonDir);
        JsonConfigRegistration.deleteJson(JsonFileName.CONSUMABLE_THIRST, jsonDir);
        JsonConfigRegistration.deleteJson(JsonFileName.CONSUMABLE_HEAL, jsonDir);
        JsonConfigRegistration.deleteJson(JsonFileName.DAMAGE_SOURCE_BODY_PARTS, jsonDir);
    }

    public static void deleteJsonDirs() {
        if (LegendarySurvivalOverhaul.modIntegrationConfigJsons.toFile().exists()) {
            LegendarySurvivalOverhaul.modIntegrationConfigJsons.toFile().delete();
        }
        if (LegendarySurvivalOverhaul.modConfigJsons.toFile().exists()) {
            LegendarySurvivalOverhaul.modConfigJsons.toFile().delete();
        }
    }

    private static void createDirectories(Path directory) {
        try {
            Files.createDirectories(directory, new FileAttribute[0]);
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
        }
        catch (IOException e) {
            LegendarySurvivalOverhaul.LOGGER.error("Failed to create custom datapack directory {}", (Object)directory);
            LegendarySurvivalOverhaul.LOGGER.error((Object)e.getStackTrace());
        }
    }

    private static void writeInFile(File file, JsonObject json) {
        try {
            FileUtils.write((File)file, (CharSequence)json.toString(), (String)null);
        }
        catch (IOException err) {
            LegendarySurvivalOverhaul.LOGGER.error("Failed to create json file {}", (Object)file);
            LegendarySurvivalOverhaul.LOGGER.error((Object)err.getStackTrace());
        }
    }

    private static void writeInFile(File file, JsonArray json) {
        try {
            FileUtils.write((File)file, (CharSequence)json.toString(), (String)null);
        }
        catch (IOException err) {
            LegendarySurvivalOverhaul.LOGGER.error("Failed to create json file {}", (Object)file);
            LegendarySurvivalOverhaul.LOGGER.error((Object)err.getStackTrace());
        }
    }

    public static void processAllJson(File jsonDir) {
        Map jsonDamageSourceBodyParts;
        Map jsonConsumableHeal;
        Object e;
        Map jsonConsumableThirsts;
        Object td;
        Iterator e2;
        Map jsonBlockFluidThirsts;
        Iterator e3;
        Map jsonConsumableTemperatures;
        Iterator e4;
        Map jsonFuelItemIdentities;
        Object e5;
        Map jsonBlockFluidTemperatures;
        Iterator e6;
        Map jsonEntityTemperatures;
        Object e7;
        Map jsonItemTemperatures;
        Object e8;
        Map jsonBiomeIdentities;
        Object e9;
        Gson gson = JsonConfigRegistration.buildNewGson();
        Map jsonDimensionTemperatures = (Map)JsonConfigRegistration.processJson(JsonFileName.DIMENSION_TEMP, jsonDir);
        if (jsonDimensionTemperatures != null) {
            LegendarySurvivalOverhaul.LOGGER.debug("Loaded " + jsonDimensionTemperatures.size() + " dimension temperature overrides from JSON");
            for (Map.Entry entry : jsonDimensionTemperatures.entrySet()) {
                JsonConfig.registerDimensionTemperature((String)entry.getKey(), ((JsonTemperature)entry.getValue()).temperature);
            }
            MapDifference diff = Maps.difference((Map)((Map)gson.fromJson(gson.toJson(JsonConfig.defaultDimensionTemperatures, Objects.requireNonNull(JsonTypeToken.get(JsonFileName.DIMENSION_TEMP))), Map.class)), (Map)((Map)gson.fromJson(gson.toJson(JsonConfig.dimensionTemperatures, Objects.requireNonNull(JsonTypeToken.get(JsonFileName.DIMENSION_TEMP))), Map.class)));
            ArrayList entriesToKeep = new ArrayList();
            if (!diff.entriesOnlyOnRight().isEmpty() || !diff.entriesDiffering().isEmpty()) {
                entriesToKeep.addAll(diff.entriesOnlyOnRight().keySet());
                entriesToKeep.addAll(diff.entriesDiffering().keySet());
                Iterator iterator = entriesToKeep.iterator();
                while (iterator.hasNext()) {
                    e9 = (String)iterator.next();
                    ResourceLocation rl = ResourceLocation.parse((String)e9);
                    Path endPath = Paths.get(customDatapackFolder.toString(), "data", rl.getNamespace(), "legendarysurvivaloverhaul", "temperature", "dimensions");
                    if (!endPath.toFile().exists()) {
                        JsonConfigRegistration.createDirectories(endPath);
                    }
                    File jsonFile = new File(endPath.toFile(), rl.getPath() + ".json");
                    TemperatureDimensionData tdd = new TemperatureDimensionData();
                    tdd.temperature(JsonConfig.dimensionTemperatures.get((Object)e9).temperature);
                    if (!rl.equals((Object)ResourceLocation.parse((String)"the_nether")) && !rl.equals((Object)ResourceLocation.parse((String)"the_end"))) {
                        tdd.hasAltitude().seaLevelHeight(64);
                    }
                    JsonConfigRegistration.writeInFile(jsonFile, tdd.build());
                }
            }
        }
        if ((jsonBiomeIdentities = (Map)JsonConfigRegistration.processJson(JsonFileName.BIOME_TEMP, jsonDir)) != null) {
            LegendarySurvivalOverhaul.LOGGER.debug("Loaded " + jsonBiomeIdentities.size() + " biome temperature overrides from JSON");
            for (Map.Entry entry : jsonBiomeIdentities.entrySet()) {
                JsonConfig.registerBiomeOverride((String)entry.getKey(), ((JsonBiomeIdentity)entry.getValue()).temperature, ((JsonBiomeIdentity)entry.getValue()).isDry);
            }
            MapDifference diff = Maps.difference((Map)((Map)gson.fromJson(gson.toJson(JsonConfig.defaultBiomeOverrides, Objects.requireNonNull(JsonTypeToken.get(JsonFileName.BIOME_TEMP))), Map.class)), (Map)((Map)gson.fromJson(gson.toJson(JsonConfig.biomeOverrides, Objects.requireNonNull(JsonTypeToken.get(JsonFileName.BIOME_TEMP))), Map.class)));
            ArrayList entriesToKeep = new ArrayList();
            if (!diff.entriesOnlyOnRight().isEmpty() || !diff.entriesDiffering().isEmpty()) {
                entriesToKeep.addAll(diff.entriesOnlyOnRight().keySet());
                entriesToKeep.addAll(diff.entriesDiffering().keySet());
                e9 = entriesToKeep.iterator();
                while (e9.hasNext()) {
                    e8 = (String)e9.next();
                    ResourceLocation rl = ResourceLocation.parse((String)e8);
                    Path endPath = Paths.get(customDatapackFolder.toString(), "data", rl.getNamespace(), "legendarysurvivaloverhaul", "temperature", "biomes");
                    if (!endPath.toFile().exists()) {
                        JsonConfigRegistration.createDirectories(endPath);
                    }
                    File jsonFile = new File(endPath.toFile(), rl.getPath() + ".json");
                    TemperatureBiomeOverrideData td2 = new TemperatureBiomeOverrideData();
                    td2.temperature(JsonConfig.biomeOverrides.get((Object)e8).temperature);
                    td2.isDry(JsonConfig.biomeOverrides.get((Object)e8).isDry);
                    JsonConfigRegistration.writeInFile(jsonFile, td2.build());
                }
            }
        }
        if ((jsonItemTemperatures = (Map)JsonConfigRegistration.processJson(JsonFileName.ITEM_TEMP, jsonDir)) != null) {
            LegendarySurvivalOverhaul.LOGGER.debug("Loaded " + jsonItemTemperatures.size() + " item temperature values from JSON");
            for (Map.Entry entry : jsonItemTemperatures.entrySet()) {
                JsonConfig.registerItemTemperature((String)entry.getKey(), ((JsonTemperatureResistance)entry.getValue()).temperature, ((JsonTemperatureResistance)entry.getValue()).heatResistance, ((JsonTemperatureResistance)entry.getValue()).coldResistance, ((JsonTemperatureResistance)entry.getValue()).thermalResistance);
            }
            MapDifference diff = Maps.difference((Map)((Map)gson.fromJson(gson.toJson(JsonConfig.defaultItemTemperatures, Objects.requireNonNull(JsonTypeToken.get(JsonFileName.ITEM_TEMP))), Map.class)), (Map)((Map)gson.fromJson(gson.toJson(JsonConfig.itemTemperatures, Objects.requireNonNull(JsonTypeToken.get(JsonFileName.ITEM_TEMP))), Map.class)));
            ArrayList entriesToKeep = new ArrayList();
            if (!diff.entriesOnlyOnRight().isEmpty() || !diff.entriesDiffering().isEmpty()) {
                entriesToKeep.addAll(diff.entriesOnlyOnRight().keySet());
                entriesToKeep.addAll(diff.entriesDiffering().keySet());
                e8 = entriesToKeep.iterator();
                while (e8.hasNext()) {
                    e7 = (String)e8.next();
                    ResourceLocation rl = ResourceLocation.parse((String)e7);
                    Path endPath = Paths.get(customDatapackFolder.toString(), "data", rl.getNamespace(), "legendarysurvivaloverhaul", "temperature", "items");
                    if (!endPath.toFile().exists()) {
                        JsonConfigRegistration.createDirectories(endPath);
                    }
                    File jsonFile = new File(endPath.toFile(), rl.getPath() + ".json");
                    TemperatureResistanceData td3 = new TemperatureResistanceData();
                    td3.temperature(JsonConfig.itemTemperatures.get((Object)e7).temperature);
                    td3.heatResistance(JsonConfig.itemTemperatures.get((Object)e7).heatResistance);
                    td3.coldResistance(JsonConfig.itemTemperatures.get((Object)e7).coldResistance);
                    td3.thermalResistance(JsonConfig.itemTemperatures.get((Object)e7).thermalResistance);
                    JsonConfigRegistration.writeInFile(jsonFile, td3.build());
                }
            }
        }
        if ((jsonEntityTemperatures = (Map)JsonConfigRegistration.processJson(JsonFileName.ENTITY_TEMP, jsonDir)) != null) {
            LegendarySurvivalOverhaul.LOGGER.debug("Loaded " + jsonEntityTemperatures.size() + " entity temperature values from JSON");
            for (Map.Entry entry : jsonEntityTemperatures.entrySet()) {
                JsonConfig.registerEntityTemperature((String)entry.getKey(), ((JsonTemperature)entry.getValue()).temperature);
            }
            MapDifference diff = Maps.difference((Map)((Map)gson.fromJson(gson.toJson(JsonConfig.defaultEntityTemperatures, Objects.requireNonNull(JsonTypeToken.get(JsonFileName.ENTITY_TEMP))), Map.class)), (Map)((Map)gson.fromJson(gson.toJson(JsonConfig.entityTemperatures, Objects.requireNonNull(JsonTypeToken.get(JsonFileName.ENTITY_TEMP))), Map.class)));
            ArrayList entriesToKeep = new ArrayList();
            if (!diff.entriesOnlyOnRight().isEmpty() || !diff.entriesDiffering().isEmpty()) {
                entriesToKeep.addAll(diff.entriesOnlyOnRight().keySet());
                entriesToKeep.addAll(diff.entriesDiffering().keySet());
                e7 = entriesToKeep.iterator();
                while (e7.hasNext()) {
                    e6 = (String)e7.next();
                    ResourceLocation rl = ResourceLocation.parse(e6);
                    Path endPath = Paths.get(customDatapackFolder.toString(), "data", rl.getNamespace(), "legendarysurvivaloverhaul", "temperature", "entities");
                    if (!endPath.toFile().exists()) {
                        JsonConfigRegistration.createDirectories(endPath);
                    }
                    File jsonFile = new File(endPath.toFile(), rl.getPath() + ".json");
                    TemperatureData td4 = new TemperatureData();
                    td4.temperature(JsonConfig.entityTemperatures.get(e6).temperature);
                    JsonConfigRegistration.writeInFile(jsonFile, td4.build());
                }
            }
        }
        if ((jsonBlockFluidTemperatures = (Map)JsonConfigRegistration.processJson(JsonFileName.BLOCK_TEMP, jsonDir)) != null) {
            LegendarySurvivalOverhaul.LOGGER.debug("Loaded " + jsonBlockFluidTemperatures.size() + " block/fluid temperature values from JSON");
            for (Map.Entry entry : jsonBlockFluidTemperatures.entrySet()) {
                for (JsonBlockFluidTemperature propTemp : (List)entry.getValue()) {
                    JsonConfig.registerBlockFluidTemperature((String)entry.getKey(), propTemp.temperature, propTemp.getPropertyArray());
                }
            }
            MapDifference diff = Maps.difference((Map)((Map)gson.fromJson(gson.toJson(JsonConfig.defaultBlockFluidTemperatures, Objects.requireNonNull(JsonTypeToken.get(JsonFileName.BLOCK_TEMP))), Map.class)), (Map)((Map)gson.fromJson(gson.toJson(JsonConfig.blockFluidTemperatures, Objects.requireNonNull(JsonTypeToken.get(JsonFileName.BLOCK_TEMP))), Map.class)));
            ArrayList entriesToKeep = new ArrayList();
            if (!diff.entriesOnlyOnRight().isEmpty() || !diff.entriesDiffering().isEmpty()) {
                entriesToKeep.addAll(diff.entriesOnlyOnRight().keySet());
                entriesToKeep.addAll(diff.entriesDiffering().keySet());
                e6 = entriesToKeep.iterator();
                while (e6.hasNext()) {
                    e5 = (String)e6.next();
                    ResourceLocation rl = ResourceLocation.parse((String)e5);
                    Path endPath = Paths.get(customDatapackFolder.toString(), "data", rl.getNamespace(), "legendarysurvivaloverhaul", "temperature", "blocks");
                    if (!endPath.toFile().exists()) {
                        JsonConfigRegistration.createDirectories(endPath);
                    }
                    File jsonFile = new File(endPath.toFile(), rl.getPath() + ".json");
                    JsonArray ja = new JsonArray();
                    for (JsonBlockFluidTemperature jbft : JsonConfig.blockFluidTemperatures.get(e5)) {
                        TemperatureBlockData tbd = new TemperatureBlockData();
                        tbd.temperature(jbft.temperature);
                        for (Map.Entry<String, String> entry : jbft.properties.entrySet()) {
                            tbd.addProperty(entry.getKey(), entry.getValue());
                        }
                        ja.add((JsonElement)tbd.build());
                    }
                    JsonConfigRegistration.writeInFile(jsonFile, ja);
                }
            }
        }
        if ((jsonFuelItemIdentities = (Map)JsonConfigRegistration.processJson(JsonFileName.FUEL, jsonDir)) != null) {
            LegendarySurvivalOverhaul.LOGGER.debug("Loaded " + jsonFuelItemIdentities.size() + " fuel item values from JSON");
            for (Map.Entry entry : jsonFuelItemIdentities.entrySet()) {
                JsonConfig.registerFuelItems((String)entry.getKey(), ((JsonFuelItem)entry.getValue()).thermalType, ((JsonFuelItem)entry.getValue()).fuelValue);
            }
            MapDifference diff = Maps.difference((Map)((Map)gson.fromJson(gson.toJson(JsonConfig.defaultFuelItems, Objects.requireNonNull(JsonTypeToken.get(JsonFileName.FUEL))), Map.class)), (Map)((Map)gson.fromJson(gson.toJson(JsonConfig.fuelItems, Objects.requireNonNull(JsonTypeToken.get(JsonFileName.FUEL))), Map.class)));
            ArrayList entriesToKeep = new ArrayList();
            if (!diff.entriesOnlyOnRight().isEmpty() || !diff.entriesDiffering().isEmpty()) {
                entriesToKeep.addAll(diff.entriesOnlyOnRight().keySet());
                entriesToKeep.addAll(diff.entriesDiffering().keySet());
                e5 = entriesToKeep.iterator();
                while (e5.hasNext()) {
                    e4 = (String)e5.next();
                    ResourceLocation rl = ResourceLocation.parse(e4);
                    Path endPath = Paths.get(customDatapackFolder.toString(), "data", rl.getNamespace(), "legendarysurvivaloverhaul", "temperature", "fuel_items");
                    if (!endPath.toFile().exists()) {
                        JsonConfigRegistration.createDirectories(endPath);
                    }
                    File jsonFile = new File(endPath.toFile(), rl.getPath() + ".json");
                    TemperatureFuelItemData td5 = new TemperatureFuelItemData();
                    td5.thermalType(JsonConfig.fuelItems.get(e4).thermalType);
                    td5.duration(JsonConfig.fuelItems.get(e4).fuelValue * 20);
                    JsonConfigRegistration.writeInFile(jsonFile, td5.build());
                }
            }
        }
        if ((jsonConsumableTemperatures = (Map)JsonConfigRegistration.processJson(JsonFileName.CONSUMABLE_TEMP, jsonDir)) != null) {
            LegendarySurvivalOverhaul.LOGGER.debug("Loaded " + jsonConsumableTemperatures.size() + " consumable temperature values from JSON");
            for (Map.Entry entry : jsonConsumableTemperatures.entrySet()) {
                for (JsonConsumableTemperature jct : (List)entry.getValue()) {
                    JsonConfig.registerConsumableTemperature(jct.group, (String)entry.getKey(), jct.temperatureLevel, jct.duration);
                }
            }
            MapDifference diff = Maps.difference((Map)((Map)gson.fromJson(gson.toJson(JsonConfig.defaultConsumableTemperature, Objects.requireNonNull(JsonTypeToken.get(JsonFileName.CONSUMABLE_TEMP))), Map.class)), (Map)((Map)gson.fromJson(gson.toJson(JsonConfig.consumableTemperature, Objects.requireNonNull(JsonTypeToken.get(JsonFileName.CONSUMABLE_TEMP))), Map.class)));
            ArrayList entriesToKeep = new ArrayList();
            if (!diff.entriesOnlyOnRight().isEmpty() || !diff.entriesDiffering().isEmpty()) {
                entriesToKeep.addAll(diff.entriesOnlyOnRight().keySet());
                entriesToKeep.addAll(diff.entriesDiffering().keySet());
                e4 = entriesToKeep.iterator();
                while (e4.hasNext()) {
                    e3 = (String)e4.next();
                    ResourceLocation rl = ResourceLocation.parse(e3);
                    Path endPath = Paths.get(customDatapackFolder.toString(), "data", rl.getNamespace(), "legendarysurvivaloverhaul", "temperature", "consumables");
                    if (!endPath.toFile().exists()) {
                        JsonConfigRegistration.createDirectories(endPath);
                    }
                    File jsonFile = new File(endPath.toFile(), rl.getPath() + ".json");
                    JsonArray ja = new JsonArray();
                    for (JsonConsumableTemperature jsonConsumableTemperature : JsonConfig.consumableTemperature.get(e3)) {
                        TemperatureConsumableData temperatureConsumableData = new TemperatureConsumableData();
                        temperatureConsumableData.group(jsonConsumableTemperature.group);
                        temperatureConsumableData.duration(jsonConsumableTemperature.duration);
                        temperatureConsumableData.temperatureLevel(jsonConsumableTemperature.temperatureLevel);
                        ja.add((JsonElement)temperatureConsumableData.build());
                    }
                    JsonConfigRegistration.writeInFile(jsonFile, ja);
                }
            }
        }
        if ((jsonBlockFluidThirsts = (Map)JsonConfigRegistration.processJson(JsonFileName.BLOCK_THIRST, jsonDir)) != null) {
            LegendarySurvivalOverhaul.LOGGER.debug("Loaded " + jsonBlockFluidThirsts.size() + " block/fluid thirst values from JSON");
            for (Map.Entry entry : jsonBlockFluidThirsts.entrySet()) {
                for (JsonBlockFluidThirst propThirst : (List)entry.getValue()) {
                    JsonConfig.registerBlockFluidThirst((String)entry.getKey(), propThirst.hydration, propThirst.saturation, propThirst.effects.toArray(new JsonEffectParameter[0]), propThirst.getPropertyArray());
                }
            }
            MapDifference diff = Maps.difference((Map)((Map)gson.fromJson(gson.toJson(JsonConfig.defaultBlockFluidThirst, Objects.requireNonNull(JsonTypeToken.get(JsonFileName.BLOCK_THIRST))), Map.class)), (Map)((Map)gson.fromJson(gson.toJson(JsonConfig.blockFluidThirst, Objects.requireNonNull(JsonTypeToken.get(JsonFileName.BLOCK_THIRST))), Map.class)));
            ArrayList entriesToKeep = new ArrayList();
            if (!diff.entriesOnlyOnRight().isEmpty() || !diff.entriesDiffering().isEmpty()) {
                entriesToKeep.addAll(diff.entriesOnlyOnRight().keySet());
                entriesToKeep.addAll(diff.entriesDiffering().keySet());
                e3 = entriesToKeep.iterator();
                while (e3.hasNext()) {
                    e2 = (String)e3.next();
                    ResourceLocation rl = ResourceLocation.parse(e2);
                    Path endPath = Paths.get(customDatapackFolder.toString(), "data", rl.getNamespace(), "legendarysurvivaloverhaul", "thirst", "blocks");
                    if (!endPath.toFile().exists()) {
                        JsonConfigRegistration.createDirectories(endPath);
                    }
                    File jsonFile = new File(endPath.toFile(), rl.getPath() + ".json");
                    JsonArray ja = new JsonArray();
                    for (JsonBlockFluidThirst jsonBlockFluidThirst : JsonConfig.blockFluidThirst.get(e2)) {
                        td = new ThirstData();
                        ((ThirstData)td).hydration(jsonBlockFluidThirst.hydration);
                        ((ThirstData)td).saturation(jsonBlockFluidThirst.saturation);
                        for (JsonEffectParameter jsonEffectParameter : jsonBlockFluidThirst.effects) {
                            MobEffect mobEffect = (MobEffect)BuiltInRegistries.MOB_EFFECT.get(ResourceLocation.parse((String)jsonEffectParameter.name));
                            if (mobEffect == null) continue;
                            ((ThirstData)td).addEffect(mobEffect, jsonEffectParameter.duration, jsonEffectParameter.chance, jsonEffectParameter.amplifier);
                        }
                        for (Map.Entry entry : jsonBlockFluidThirst.properties.entrySet()) {
                            ((ThirstData)td).addProperty((String)entry.getKey(), (String)entry.getValue());
                        }
                        ja.add((JsonElement)((ThirstData)td).build());
                    }
                    JsonConfigRegistration.writeInFile(jsonFile, ja);
                }
            }
        }
        if ((jsonConsumableThirsts = (Map)JsonConfigRegistration.processJson(JsonFileName.CONSUMABLE_THIRST, jsonDir)) != null) {
            LegendarySurvivalOverhaul.LOGGER.debug("Loaded " + jsonConsumableThirsts.size() + " consumable thirst values from JSON");
            for (Map.Entry entry : jsonConsumableThirsts.entrySet()) {
                for (JsonConsumableThirst jct : (List)entry.getValue()) {
                    JsonConfig.registerConsumableThirst((String)entry.getKey(), jct.hydration, jct.saturation, jct.effects.toArray(new JsonEffectParameter[0]), jct.getNbtArray());
                }
            }
            MapDifference diff = Maps.difference((Map)((Map)gson.fromJson(gson.toJson(JsonConfig.defaultConsumableThirst, Objects.requireNonNull(JsonTypeToken.get(JsonFileName.CONSUMABLE_THIRST))), Map.class)), (Map)((Map)gson.fromJson(gson.toJson(JsonConfig.consumableThirst, Objects.requireNonNull(JsonTypeToken.get(JsonFileName.CONSUMABLE_THIRST))), Map.class)));
            ArrayList entriesToKeep = new ArrayList();
            if (!diff.entriesOnlyOnRight().isEmpty() || !diff.entriesDiffering().isEmpty()) {
                entriesToKeep.addAll(diff.entriesOnlyOnRight().keySet());
                entriesToKeep.addAll(diff.entriesDiffering().keySet());
                e2 = entriesToKeep.iterator();
                while (e2.hasNext()) {
                    e = (String)e2.next();
                    ResourceLocation rl = ResourceLocation.parse((String)e);
                    Path endPath = Paths.get(customDatapackFolder.toString(), "data", rl.getNamespace(), "legendarysurvivaloverhaul", "thirst", "consumables");
                    if (!endPath.toFile().exists()) {
                        JsonConfigRegistration.createDirectories(endPath);
                    }
                    File jsonFile = new File(endPath.toFile(), rl.getPath() + ".json");
                    JsonArray jsonArray = new JsonArray();
                    for (JsonConsumableThirst jct : JsonConfig.consumableThirst.get(e)) {
                        ThirstData td6 = new ThirstData();
                        td6.hydration(jct.hydration);
                        td6.saturation(jct.saturation);
                        for (JsonEffectParameter jsonEffectParameter : jct.effects) {
                            MobEffect me = (MobEffect)BuiltInRegistries.MOB_EFFECT.get(ResourceLocation.parse((String)jsonEffectParameter.name));
                            if (me == null) continue;
                            td6.addEffect(me, jsonEffectParameter.duration, jsonEffectParameter.chance, jsonEffectParameter.amplifier);
                        }
                        for (Map.Entry<String, String> entry : jct.nbt.entrySet()) {
                            td6.addProperty(entry.getKey(), entry.getValue());
                        }
                        jsonArray.add((JsonElement)td6.build());
                    }
                    JsonConfigRegistration.writeInFile(jsonFile, jsonArray);
                }
            }
        }
        if ((jsonConsumableHeal = (Map)JsonConfigRegistration.processJson(JsonFileName.CONSUMABLE_HEAL, jsonDir)) != null) {
            LegendarySurvivalOverhaul.LOGGER.debug("Loaded " + jsonConsumableHeal.size() + " consumable heal values from JSON");
            for (Map.Entry entry : jsonConsumableHeal.entrySet()) {
                JsonConfig.registerConsumableHeal((String)entry.getKey(), ((JsonConsumableHeal)entry.getValue()).healingCharges, ((JsonConsumableHeal)entry.getValue()).healingValue, ((JsonConsumableHeal)entry.getValue()).healingTime);
            }
            MapDifference diff = Maps.difference((Map)((Map)gson.fromJson(gson.toJson(JsonConfig.defaultConsumableHeal, Objects.requireNonNull(JsonTypeToken.get(JsonFileName.CONSUMABLE_HEAL))), Map.class)), (Map)((Map)gson.fromJson(gson.toJson(JsonConfig.consumableHeal, Objects.requireNonNull(JsonTypeToken.get(JsonFileName.CONSUMABLE_HEAL))), Map.class)));
            ArrayList entriesToKeep = new ArrayList();
            if (!diff.entriesOnlyOnRight().isEmpty() || !diff.entriesDiffering().isEmpty()) {
                entriesToKeep.addAll(diff.entriesOnlyOnRight().keySet());
                entriesToKeep.addAll(diff.entriesDiffering().keySet());
                e = entriesToKeep.iterator();
                while (e.hasNext()) {
                    String e10 = (String)e.next();
                    ResourceLocation rl = ResourceLocation.parse((String)e10);
                    Path endPath = Paths.get(customDatapackFolder.toString(), "data", rl.getNamespace(), "legendarysurvivaloverhaul", "body_damage", "consumables");
                    if (!endPath.toFile().exists()) {
                        JsonConfigRegistration.createDirectories(endPath);
                    }
                    File file = new File(endPath.toFile(), rl.getPath() + ".json");
                    HealingConsumableData healingConsumableData = new HealingConsumableData();
                    healingConsumableData.duration(JsonConfig.consumableHeal.get((Object)e10).healingTime);
                    healingConsumableData.healingCharges(JsonConfig.consumableHeal.get((Object)e10).healingCharges);
                    healingConsumableData.healingValue(JsonConfig.consumableHeal.get((Object)e10).healingValue);
                    JsonConfigRegistration.writeInFile(file, healingConsumableData.build());
                }
            }
        }
        if ((jsonDamageSourceBodyParts = (Map)JsonConfigRegistration.processJson(JsonFileName.DAMAGE_SOURCE_BODY_PARTS, jsonDir)) != null) {
            LegendarySurvivalOverhaul.LOGGER.debug("Loaded " + jsonDamageSourceBodyParts.size() + " damage source body part values from JSON");
            for (Map.Entry entry : jsonDamageSourceBodyParts.entrySet()) {
                JsonConfig.registerDamageSourceBodyParts((String)entry.getKey(), ((JsonBodyPartsDamageSource)entry.getValue()).damageDistribution, ((JsonBodyPartsDamageSource)entry.getValue()).bodyParts);
            }
            MapDifference diff = Maps.difference((Map)((Map)gson.fromJson(gson.toJson(JsonConfig.defaultDamageSourceBodyParts, Objects.requireNonNull(JsonTypeToken.get(JsonFileName.DAMAGE_SOURCE_BODY_PARTS))), Map.class)), (Map)((Map)gson.fromJson(gson.toJson(JsonConfig.damageSourceBodyParts, Objects.requireNonNull(JsonTypeToken.get(JsonFileName.DAMAGE_SOURCE_BODY_PARTS))), Map.class)));
            ArrayList entriesToKeep = new ArrayList();
            if (!diff.entriesOnlyOnRight().isEmpty() || !diff.entriesDiffering().isEmpty()) {
                entriesToKeep.addAll(diff.entriesOnlyOnRight().keySet());
                entriesToKeep.addAll(diff.entriesDiffering().keySet());
                for (String e11 : entriesToKeep) {
                    ResourceLocation rl = ResourceLocation.parse((String)e11);
                    Path path = Paths.get(customDatapackFolder.toString(), "data", rl.getNamespace(), "legendarysurvivaloverhaul", "body_damage", "damage_sources");
                    if (!path.toFile().exists()) {
                        JsonConfigRegistration.createDirectories(path);
                    }
                    File file = new File(path.toFile(), rl.getPath() + ".json");
                    td = new BodyPartsDamageSourceData();
                    ((BodyPartsDamageSourceData)td).addBodyParts(JsonConfig.damageSourceBodyParts.get((Object)e11).bodyParts);
                    ((BodyPartsDamageSourceData)td).damageDistribution(JsonConfig.damageSourceBodyParts.get((Object)e11).damageDistribution);
                    JsonConfigRegistration.writeInFile(file, ((BodyPartsDamageSourceData)td).build());
                }
            }
        }
        if (customDatapackFolder.toFile().exists()) {
            JsonObject packMcMetaContent = new JsonObject();
            JsonObject packMcMetaContent2 = new JsonObject();
            packMcMetaContent2.addProperty("pack_format", (Number)10);
            packMcMetaContent2.addProperty("description", "Legendary Survival Overhaul datapack (modifies temperature/thirst/body damage values)");
            packMcMetaContent.add("pack", (JsonElement)packMcMetaContent2);
            File packMcMeta = new File(customDatapackFolder.toFile(), "pack.mcmeta");
            JsonConfigRegistration.writeInFile(packMcMeta, packMcMetaContent);
        }
    }

    @Nullable
    public static <T> T processJson(JsonFileName jfn, File jsonDir) {
        try {
            return JsonConfigRegistration.processUncaughtJson(jfn, jsonDir);
        }
        catch (Exception e) {
            LegendarySurvivalOverhaul.LOGGER.error("Error managing JSON file: " + jfn.get(), (Throwable)e);
            return null;
        }
    }

    @Nullable
    public static <T> T processUncaughtJson(JsonFileName jfn, File jsonDir) throws Exception {
        String jsonFileName = jfn.get();
        Type type = JsonTypeToken.get(jfn);
        File jsonFile = new File(jsonDir, jsonFileName);
        if (jsonFile.exists()) {
            Gson gson = JsonConfigRegistration.buildNewGson();
            return (T)gson.fromJson((Reader)new FileReader(jsonFile), type);
        }
        return null;
    }

    public static void deleteJson(JsonFileName jfn, File jsonDir) {
        String jsonFileName = jfn.get();
        File jsonFile = new File(jsonDir, jsonFileName);
        if (jsonFile.exists()) {
            jsonFile.delete();
        }
    }

    public static <T> void manuallyWriteToJson(JsonFileName jfn, T container, File jsonDir) {
        try {
            JsonConfigRegistration.manuallyWriteToJson(jfn, container, jsonDir, false);
        }
        catch (Exception e) {
            LegendarySurvivalOverhaul.LOGGER.error("Error writing " + String.valueOf((Object)jfn) + " JSON file", (Throwable)e);
        }
    }

    private static <T> void manuallyWriteToJson(JsonFileName jfn, T container, File jsonDir, boolean forceWrite) throws Exception {
        String jsonFileName = jfn.get();
        Type type = JsonTypeToken.get(jfn);
        Gson gson = JsonConfigRegistration.buildNewGson();
        File jsonFile = new File(jsonDir, jsonFileName);
        if (jsonFile.exists()) {
            LegendarySurvivalOverhaul.LOGGER.debug(jsonFile.getName() + " already exists!");
            if (forceWrite) {
                LegendarySurvivalOverhaul.LOGGER.debug("Overriding...");
            } else {
                return;
            }
        }
        FileUtils.write((File)jsonFile, (CharSequence)gson.toJson(container, type), (String)null);
    }

    private static Gson buildNewGson() {
        return new GsonBuilder().setPrettyPrinting().excludeFieldsWithModifiers(new int[]{2}).create();
    }
}

