/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarysurvivaloverhaul.data.builders;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import sfiomn.legendarysurvivaloverhaul.api.data.builder.IThirstData;

public class ThirstData
implements IThirstData {
    private final List<EffectData> effects;
    private final Map<String, String> properties;
    private int hydration;
    private float saturation;

    public ThirstData() {
        this.effects = new ArrayList<EffectData>();
        this.properties = new HashMap<String, String>();
    }

    public ThirstData(ThirstData copy) {
        this.hydration = copy.hydration;
        this.saturation = copy.saturation;
        this.effects = new ArrayList<EffectData>(copy.effects);
        this.properties = new HashMap<String, String>(copy.properties);
    }

    @Override
    public IThirstData hydration(int hydrationValue) {
        this.hydration = hydrationValue;
        return this;
    }

    @Override
    public IThirstData saturation(float saturationValue) {
        this.saturation = saturationValue;
        return this;
    }

    @Override
    public IThirstData addEffect(MobEffect effect, int durationInTick, float chance, int amplifier) {
        ResourceLocation effectName = Objects.requireNonNull(BuiltInRegistries.MOB_EFFECT.getKey((Object)effect));
        this.effects.add(new EffectData(effectName, Math.max(durationInTick, 0), Math.max(amplifier, 0), Mth.clamp((float)chance, (float)0.0f, (float)1.0f)));
        return this;
    }

    @Override
    public IThirstData addEffect(MobEffect effect, int durationInTick, float chance) {
        return this.addEffect(effect, durationInTick, chance, 0);
    }

    @Override
    public IThirstData addEffect(MobEffect effect, int durationInTick, int amplifier) {
        return this.addEffect(effect, durationInTick, 0.0f, amplifier);
    }

    @Override
    public IThirstData addEffect(MobEffect effect, int durationInTick) {
        return this.addEffect(effect, durationInTick, 1.0f, 0);
    }

    @Override
    public IThirstData addProperty(String propertyName, String propertyValue) {
        this.properties.put(propertyName, propertyValue);
        return this;
    }

    @Override
    public IThirstData copy() {
        return new ThirstData(this);
    }

    @Override
    public JsonObject build() {
        JsonObject json = new JsonObject();
        json.addProperty("hydration", (Number)this.hydration);
        json.addProperty("saturation", (Number)Float.valueOf(this.saturation));
        JsonArray jsonEffects = new JsonArray();
        this.effects.forEach(e -> {
            JsonObject jsonEffect = new JsonObject();
            jsonEffect.addProperty("effect", e.effect.toString());
            jsonEffect.addProperty("duration", (Number)e.duration);
            jsonEffect.addProperty("amplifier", (Number)e.amplifier);
            jsonEffect.addProperty("chance", (Number)Float.valueOf(e.chance));
            jsonEffects.add((JsonElement)jsonEffect);
        });
        json.add("effects", (JsonElement)jsonEffects);
        JsonObject jsonProperties = new JsonObject();
        this.properties.forEach((arg_0, arg_1) -> ((JsonObject)jsonProperties).addProperty(arg_0, arg_1));
        json.add("properties", (JsonElement)jsonProperties);
        return json;
    }

    public record EffectData(ResourceLocation effect, int duration, int amplifier, float chance) {
    }
}

