/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarysurvivaloverhaul.data.loot;

import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.loot.LootTableSubProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.EmptyLootItem;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import org.jetbrains.annotations.NotNull;
import sfiomn.legendarysurvivaloverhaul.registry.ItemRegistry;

public class ModChestLootTables
implements LootTableSubProvider {
    public static Map<ResourceKey<LootTable>, List<Item>> chestInjectedLootTables = Map.ofEntries(Map.entry(BuiltInLootTables.BURIED_TREASURE, List.of((Item)ItemRegistry.HEART_FRAGMENT.get())), Map.entry(BuiltInLootTables.JUNGLE_TEMPLE, List.of((Item)ItemRegistry.HEART_FRAGMENT.get())), Map.entry(BuiltInLootTables.ABANDONED_MINESHAFT, List.of((Item)ItemRegistry.HEART_FRAGMENT.get())), Map.entry(BuiltInLootTables.BASTION_TREASURE, List.of((Item)ItemRegistry.HEART_FRAGMENT.get(), (Item)ItemRegistry.COLD_RESISTANCE_RING.get())), Map.entry(BuiltInLootTables.DESERT_PYRAMID, List.of((Item)ItemRegistry.HEAT_RESISTANCE_RING.get())), Map.entry(BuiltInLootTables.PILLAGER_OUTPOST, List.of((Item)ItemRegistry.FIRST_AID_SUPPLIES.get())));

    public ModChestLootTables(HolderLookup.Provider provider) {
    }

    public void generate(@NotNull BiConsumer<ResourceKey<LootTable>, LootTable.Builder> biConsumer) {
        LootPool.Builder heartFragmentLoot = LootPool.lootPool().setRolls((NumberProvider)UniformGenerator.between((float)1.0f, (float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ItemRegistry.HEART_FRAGMENT.get())).setWeight(30)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ItemRegistry.HEART_FRAGMENT.get())).setWeight(5).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)2.0f)))).add((LootPoolEntryContainer.Builder)EmptyLootItem.emptyItem().setWeight(80));
        LootPool.Builder heatResistanceRing = LootPool.lootPool().setRolls((NumberProvider)UniformGenerator.between((float)1.0f, (float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ItemRegistry.HEAT_RESISTANCE_RING.get())).setWeight(5)).add((LootPoolEntryContainer.Builder)EmptyLootItem.emptyItem().setWeight(95));
        LootPool.Builder coldResistanceRing = LootPool.lootPool().setRolls((NumberProvider)UniformGenerator.between((float)1.0f, (float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ItemRegistry.COLD_RESISTANCE_RING.get())).setWeight(5)).add((LootPoolEntryContainer.Builder)EmptyLootItem.emptyItem().setWeight(95));
        LootPool.Builder firstAidSupplies = LootPool.lootPool().setRolls((NumberProvider)UniformGenerator.between((float)1.0f, (float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ItemRegistry.FIRST_AID_SUPPLIES.get())).setWeight(1)).add((LootPoolEntryContainer.Builder)EmptyLootItem.emptyItem().setWeight(99));
        for (Map.Entry<ResourceKey<LootTable>, List<Item>> entry : chestInjectedLootTables.entrySet()) {
            LootTable.Builder lootTable = LootTable.lootTable();
            if (entry.getValue().contains(ItemRegistry.HEART_FRAGMENT.get())) {
                lootTable.withPool(heartFragmentLoot);
            }
            if (entry.getValue().contains(ItemRegistry.HEAT_RESISTANCE_RING.get())) {
                lootTable.withPool(heatResistanceRing);
            }
            if (entry.getValue().contains(ItemRegistry.COLD_RESISTANCE_RING.get())) {
                lootTable.withPool(coldResistanceRing);
            }
            if (entry.getValue().contains(ItemRegistry.FIRST_AID_SUPPLIES.get())) {
                lootTable.withPool(firstAidSupplies);
            }
            biConsumer.accept((ResourceKey<LootTable>)ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"legendarysurvivaloverhaul", (String)("inject/" + entry.getKey().location().getPath()))), lootTable);
        }
    }
}

